/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.persistence.jest.AbstractCommand;
import org.apache.openjpa.persistence.jest.JESTCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ProcessingException;
import org.apache.openjpa.persistence.jest.PropertiesFormatter;
import org.w3c.dom.Document;

public class PropertiesCommand
extends AbstractCommand {
    private static final char DOT = '.';

    public PropertiesCommand(JPAServletContext ctx) {
        super(ctx);
    }

    @Override
    protected int getMaximumArguments() {
        return 0;
    }

    @Override
    public void process() throws ProcessingException, IOException {
        JPAServletContext ctx = this.getExecutionContext();
        HttpServletResponse response = ctx.getResponse();
        response.setContentType("text/xml");
        Map<String, Object> properties = ctx.getPersistenceContext().getProperties();
        this.removeBadEntries(properties);
        PropertiesFormatter formatter = new PropertiesFormatter();
        String caption = _loc.get("properties-caption", ctx.getPersistenceUnitName()).toString();
        Document xml = formatter.createXML(caption, "", "", properties);
        formatter.write(xml, (OutputStream)response.getOutputStream());
        response.setStatus(200);
    }

    private void removeBadEntries(Map<String, Object> map) {
        Iterator<String> keys = map.keySet().iterator();
        while (keys.hasNext()) {
            if (keys.next().indexOf(46) != -1) continue;
            keys.remove();
        }
    }

    @Override
    protected JESTCommand.Format getDefaultFormat() {
        return JESTCommand.Format.xml;
    }
}

