/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedQueryCacheImpl;
import org.apache.openjpa.jdbc.kernel.SelectResultObjectProvider;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.LogicalUnion;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

public class PreparedQueryImpl
implements PreparedQuery {
    private static Localizer _loc = Localizer.forPackage(PreparedQueryImpl.class);
    private final String _id;
    private String _sql;
    private boolean _initialized;
    private Class<?> _candidate;
    private boolean _subclasses;
    private QueryExpressions[] _exps;
    private Class<?>[] _projTypes;
    private Map<Object, int[]> _userParamPositions;
    private Map<Integer, Object> _template;
    private SelectImpl select;

    public PreparedQueryImpl(String id, Query compiled) {
        this(id, null, compiled);
    }

    public PreparedQueryImpl(String id, String sql2, Query compiled) {
        this._id = id;
        this._sql = sql2;
        if (compiled != null) {
            this._candidate = compiled.getCandidateType();
            this._subclasses = compiled.hasSubclasses();
        }
    }

    @Override
    public String getIdentifier() {
        return this._id;
    }

    @Override
    public String getLanguage() {
        return "openjpa.prepared.SQL";
    }

    @Override
    public String getOriginalQuery() {
        return this.getIdentifier();
    }

    @Override
    public String getTargetQuery() {
        return this._sql;
    }

    void setTargetQuery(String sql2) {
        this._sql = sql2;
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    public QueryExpressions[] getQueryExpressions() {
        return this._exps;
    }

    public Class[] getProjectionTypes() {
        return this._projTypes;
    }

    @Override
    public void setInto(Query q) {
        q.setQuery(this._id);
        q.setCandidateType(this._candidate, this._subclasses);
    }

    @Override
    public PreparedQueryCache.Exclusion initialize(Object result) {
        if (this.isInitialized()) {
            return null;
        }
        Object[] extract = this.extractSelectExecutor(result);
        SelectExecutor selector = (SelectExecutor)extract[0];
        if (selector == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, ((Localizer.Message)extract[1]).getMessage());
        }
        if (selector == null || selector.hasMultipleSelects() || selector instanceof Union && ((Union)selector).getSelects().length != 1) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-multi-select", this._id).getMessage());
        }
        this.select = this.extractImplementation(selector);
        if (this.select == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-no-select", this._id).getMessage());
        }
        SQLBuffer buffer = selector.getSQL();
        if (buffer == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-no-sql", this._id).getMessage());
        }
        if (this.isUsingFieldStrategy()) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-user-strategy", this._id).getMessage());
        }
        if (this.isPaginated()) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-pagination", this._id).getMessage());
        }
        this.setTargetQuery(buffer.getSQL());
        this.setParameters(buffer.getParameters());
        this.setUserParameterPositions(buffer.getUserParameters());
        this._initialized = true;
        return null;
    }

    private Object[] extractSelectExecutor(Object result) {
        int i;
        if (!(result instanceof ResultList)) {
            return new Object[]{null, _loc.get("exclude-not-result", this._id)};
        }
        Object userObject = ((ResultList)result).getUserObject();
        if (userObject == null || !userObject.getClass().isArray() || ((Object[])userObject).length != 2) {
            return new Object[]{null, _loc.get("exclude-no-user-object", this._id)};
        }
        Object provider = ((Object[])userObject)[0];
        Object executor = ((Object[])userObject)[1];
        if (!(executor instanceof StoreQuery.Executor)) {
            return new Object[]{null, _loc.get("exclude-not-executor", this._id)};
        }
        this._exps = ((StoreQuery.Executor)executor).getQueryExpressions();
        for (i = 0; i < this._exps.length; ++i) {
            QueryExpressions exp = this._exps[i];
            if (exp.hasInExpression) {
                return new Object[]{null, _loc.get("exclude-in-expression", this._id)};
            }
            if (!this.isUsingExternalizedParameter(exp)) continue;
            return new Object[]{null, _loc.get("exclude-externalized-param", this._id)};
        }
        if (this._exps[0].projections.length == 0) {
            this._projTypes = StoreQuery.EMPTY_CLASSES;
        } else {
            this._projTypes = new Class[this._exps[0].projections.length];
            for (i = 0; i < this._exps[0].projections.length; ++i) {
                this._projTypes[i] = this._exps[0].projections[i].getType();
            }
        }
        if (provider instanceof QueryImpl.PackingResultObjectProvider) {
            provider = ((QueryImpl.PackingResultObjectProvider)provider).getDelegate();
        }
        if (provider instanceof RangeResultObjectProvider) {
            provider = ((RangeResultObjectProvider)provider).getDelegate();
        }
        if (provider instanceof SelectResultObjectProvider) {
            return new Object[]{((SelectResultObjectProvider)provider).getSelect(), null};
        }
        return new Object[]{null, _loc.get("exclude-not-select-rop", this._id, provider.getClass().getName())};
    }

    private SelectImpl extractImplementation(SelectExecutor selector) {
        if (selector == null) {
            return null;
        }
        if (selector instanceof SelectImpl) {
            return (SelectImpl)selector;
        }
        if (selector instanceof LogicalUnion.UnionSelect) {
            return ((LogicalUnion.UnionSelect)selector).getDelegate();
        }
        if (selector instanceof Union) {
            return this.extractImplementation(((Union)selector).getSelects()[0]);
        }
        return null;
    }

    private boolean isUsingExternalizedParameter(QueryExpressions exp) {
        if (exp == null) {
            return false;
        }
        List<FieldMetaData> fmds = exp.getParameterizedFields();
        if (fmds == null || fmds.isEmpty()) {
            return false;
        }
        for (FieldMetaData fmd : fmds) {
            if (!fmd.isExternalized()) continue;
            return true;
        }
        return false;
    }

    private boolean isPaginated() {
        return this.select instanceof SelectImpl && (this.select.getStartIndex() != 0L || this.select.getEndIndex() != Long.MAX_VALUE);
    }

    private boolean isUsingFieldStrategy() {
        for (int i = 0; i < this._exps.length; ++i) {
            if (!this.isUsingFieldStrategy(this._exps[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUsingFieldStrategy(QueryExpressions exp) {
        if (exp == null) {
            return false;
        }
        List<FieldMetaData> fmds = exp.getParameterizedFields();
        if (fmds == null || fmds.isEmpty()) {
            return false;
        }
        for (FieldMetaData fmd : fmds) {
            if (((FieldMapping)fmd).getMappingInfo().getStrategy() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Integer, Object> reparametrize(Map user, Broker broker) {
        if (!this.isInitialized()) {
            throw new InternalException("reparameterize() on uninitialized.");
        }
        if (user == null || user.isEmpty()) {
            if (!this._userParamPositions.isEmpty()) {
                throw new UserException(_loc.get("uparam-null", this._userParamPositions.keySet(), this));
            }
            return this._template;
        }
        if (!((Object)this._userParamPositions.keySet()).equals(user.keySet())) {
            throw new UserException(_loc.get("uparam-mismatch", this._userParamPositions.keySet(), user.keySet(), this));
        }
        HashMap<Integer, Object> result = new HashMap<Integer, Object>(this._template);
        Set userSet = user.entrySet();
        for (Map.Entry userEntry : userSet) {
            Object key = userEntry.getKey();
            int[] indices = this._userParamPositions.get(key);
            if (indices == null || indices.length == 0) {
                throw new UserException(_loc.get("uparam-no-pos", key, this));
            }
            Object val = userEntry.getValue();
            if (ImplHelper.isManageable(val)) {
                this.setPersistenceCapableParameter(result, val, indices, broker);
                continue;
            }
            if (val instanceof Collection) {
                this.setCollectionValuedParameter(result, (Collection)val, indices, key, broker);
                continue;
            }
            for (int j : indices) {
                if (val instanceof Enum) {
                    val = this._template.get(j) instanceof Integer ? Integer.valueOf(((Enum)val).ordinal()) : ((Enum)val).name();
                }
                result.put(j, val);
            }
        }
        return result;
    }

    private void setPersistenceCapableParameter(Map<Integer, Object> result, Object pc, int[] indices, Broker broker) {
        Column[] pks;
        JDBCStore store = (JDBCStore)((Object)broker.getStoreManager().getInnermostDelegate());
        MappingRepository repos = store.getConfiguration().getMappingRepositoryInstance();
        ClassMapping mapping = repos.getMapping(pc.getClass(), broker.getClassLoader(), true);
        Object cols = mapping.toDataStoreValue(pc, pks = mapping.getPrimaryKeyColumns(), store);
        if (cols instanceof Object[]) {
            Object[] array = (Object[])cols;
            int n = array.length;
            if (n > indices.length || indices.length % n != 0) {
                throw new UserException(_loc.get("uparam-pc-key", pc.getClass(), n, Arrays.toString(indices)));
            }
            int k = 0;
            for (int j : indices) {
                result.put(j, array[k % n]);
                ++k;
            }
        } else {
            for (int j : indices) {
                result.put(j, cols);
            }
        }
    }

    private void setCollectionValuedParameter(Map<Integer, Object> result, Collection values, int[] indices, Object param, Broker broker) {
        int n = values.size();
        Object[] array = values.toArray();
        if (n > indices.length || indices.length % n != 0) {
            throw new UserException(_loc.get("uparam-coll-size", param, values, Arrays.toString(indices)));
        }
        int k = 0;
        for (int j : indices) {
            Object val = array[k % n];
            if (ImplHelper.isManageable(val)) {
                this.setPersistenceCapableParameter(result, val, indices, broker);
            } else {
                result.put(j, val);
            }
            ++k;
        }
    }

    void setUserParameterPositions(List list) {
        this._userParamPositions = new HashMap<Object, int[]>();
        for (int i = 1; list != null && i < list.size(); i += 2) {
            Object key = ((Parameter)list.get(i)).getParameterKey();
            int p = (Integer)list.get(i - 1);
            int[] positions = this._userParamPositions.get(key);
            if (positions == null) {
                positions = new int[]{p};
            } else {
                int[] temp = new int[positions.length + 1];
                System.arraycopy(positions, 0, temp, 0, positions.length);
                temp[positions.length] = p;
                positions = temp;
            }
            this._userParamPositions.put(key, positions);
        }
    }

    void setParameters(List list) {
        HashMap tmp = new HashMap();
        for (int i = 0; list != null && i < list.size(); ++i) {
            tmp.put(i, list.get(i));
        }
        this._template = Collections.unmodifiableMap(tmp);
    }

    SelectImpl getSelect() {
        return this.select;
    }

    public String toString() {
        return "PreparedQuery: [" + this.getOriginalQuery() + "] --> [" + this.getTargetQuery() + "]";
    }
}

