/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.jdbc.DistributedJDBCBrokerFactory;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    private static final Localizer _loc = Localizer.forPackage(ProductDerivation.class);
    public static final String PREFIX_SLICE = "openjpa.slice";
    public static final String HINT_TARGET = "openjpa.hint.slice.Target";

    @Override
    public void putBrokerFactoryAliases(Map m) {
        m.put("slice", DistributedJDBCBrokerFactory.class.getName());
    }

    @Override
    public String getConfigurationPrefix() {
        return PREFIX_SLICE;
    }

    @Override
    public int getType() {
        return 200;
    }

    @Override
    public boolean afterSpecificationSet(Configuration c) {
        if (!(c instanceof DistributedJDBCConfigurationImpl)) {
            return false;
        }
        DistributedJDBCConfigurationImpl conf = (DistributedJDBCConfigurationImpl)c;
        boolean modified = false;
        Log log = conf.getConfigurationLog();
        if (conf.getDistributionPolicyInstance() == null) {
            this.forceSet(conf.distributionPolicyPlugin, "random", log);
            modified = true;
        }
        if (conf.getReplicationPolicyInstance() == null) {
            this.forceSet(conf.replicationPolicyPlugin, "all", log);
            modified = true;
        }
        return modified;
    }

    void forceSet(Value v, String forced, Log log) {
        v.setString(forced);
        if (log.isWarnEnabled()) {
            log.warn(_loc.get("forced-set-config", v.getProperty(), forced));
        }
    }

    @Override
    public Set<String> getSupportedQueryHints() {
        return Collections.singleton(HINT_TARGET);
    }
}

