/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingResultSet
implements ResultSet,
Closeable {
    static final Constructor<DelegatingResultSet> concreteImpl;
    private final ResultSet _rs;
    private final DelegatingResultSet _del;
    private final Statement _stmnt;

    public DelegatingResultSet(ResultSet rs, Statement stmnt) {
        if (rs == null) {
            throw new IllegalArgumentException();
        }
        this._stmnt = stmnt;
        this._rs = rs;
        this._del = this._rs instanceof DelegatingResultSet ? (DelegatingResultSet)this._rs : null;
    }

    public static DelegatingResultSet newInstance(ResultSet rs, Statement stmnt) {
        return ConcreteClassGenerator.newInstance(concreteImpl, rs, stmnt);
    }

    protected abstract void enforceAbstract();

    public ResultSet getDelegate() {
        return this._rs;
    }

    public ResultSet getInnermostDelegate() {
        return this._del == null ? this._rs : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this._rs.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingResultSet) {
            other = ((DelegatingResultSet)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("resultset ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this._rs.next();
    }

    @Override
    public void close() throws SQLException {
        this._rs.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._rs.wasNull();
    }

    @Override
    public String getString(int a) throws SQLException {
        return this._rs.getString(a);
    }

    @Override
    public boolean getBoolean(int a) throws SQLException {
        return this._rs.getBoolean(a);
    }

    @Override
    public byte getByte(int a) throws SQLException {
        return this._rs.getByte(a);
    }

    @Override
    public short getShort(int a) throws SQLException {
        return this._rs.getShort(a);
    }

    @Override
    public int getInt(int a) throws SQLException {
        return this._rs.getInt(a);
    }

    @Override
    public long getLong(int a) throws SQLException {
        return this._rs.getLong(a);
    }

    @Override
    public float getFloat(int a) throws SQLException {
        return this._rs.getFloat(a);
    }

    @Override
    public double getDouble(int a) throws SQLException {
        return this._rs.getDouble(a);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int a, int b) throws SQLException {
        return this._rs.getBigDecimal(a, b);
    }

    @Override
    public byte[] getBytes(int a) throws SQLException {
        return this._rs.getBytes(a);
    }

    @Override
    public Date getDate(int a) throws SQLException {
        return this._rs.getDate(a);
    }

    @Override
    public Time getTime(int a) throws SQLException {
        return this._rs.getTime(a);
    }

    @Override
    public Timestamp getTimestamp(int a) throws SQLException {
        return this._rs.getTimestamp(a);
    }

    @Override
    public InputStream getAsciiStream(int a) throws SQLException {
        return this._rs.getAsciiStream(a);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int a) throws SQLException {
        return this._rs.getUnicodeStream(a);
    }

    @Override
    public InputStream getBinaryStream(int a) throws SQLException {
        return this._rs.getBinaryStream(a);
    }

    @Override
    public String getString(String a) throws SQLException {
        return this._rs.getString(a);
    }

    @Override
    public boolean getBoolean(String a) throws SQLException {
        return this._rs.getBoolean(a);
    }

    @Override
    public byte getByte(String a) throws SQLException {
        return this._rs.getByte(a);
    }

    @Override
    public short getShort(String a) throws SQLException {
        return this._rs.getShort(a);
    }

    @Override
    public int getInt(String a) throws SQLException {
        return this._rs.getInt(a);
    }

    @Override
    public long getLong(String a) throws SQLException {
        return this._rs.getLong(a);
    }

    @Override
    public float getFloat(String a) throws SQLException {
        return this._rs.getFloat(a);
    }

    @Override
    public double getDouble(String a) throws SQLException {
        return this._rs.getDouble(a);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String a, int b) throws SQLException {
        return this._rs.getBigDecimal(a, b);
    }

    @Override
    public byte[] getBytes(String a) throws SQLException {
        return this._rs.getBytes(a);
    }

    @Override
    public Date getDate(String a) throws SQLException {
        return this._rs.getDate(a);
    }

    @Override
    public Time getTime(String a) throws SQLException {
        return this._rs.getTime(a);
    }

    @Override
    public Timestamp getTimestamp(String a) throws SQLException {
        return this._rs.getTimestamp(a);
    }

    @Override
    public InputStream getAsciiStream(String a) throws SQLException {
        return this._rs.getAsciiStream(a);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String a) throws SQLException {
        return this._rs.getUnicodeStream(a);
    }

    @Override
    public InputStream getBinaryStream(String a) throws SQLException {
        return this._rs.getBinaryStream(a);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._rs.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this._rs.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rs.getMetaData();
    }

    @Override
    public Object getObject(int a) throws SQLException {
        return this._rs.getObject(a);
    }

    @Override
    public Object getObject(String a) throws SQLException {
        return this._rs.getObject(a);
    }

    @Override
    public int findColumn(String a) throws SQLException {
        return this._rs.findColumn(a);
    }

    @Override
    public Reader getCharacterStream(int a) throws SQLException {
        return this._rs.getCharacterStream(a);
    }

    @Override
    public Reader getCharacterStream(String a) throws SQLException {
        return this._rs.getCharacterStream(a);
    }

    @Override
    public BigDecimal getBigDecimal(int a) throws SQLException {
        return this._rs.getBigDecimal(a);
    }

    @Override
    public BigDecimal getBigDecimal(String a) throws SQLException {
        return this._rs.getBigDecimal(a);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._rs.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._rs.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this._rs.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._rs.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this._rs.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this._rs.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this._rs.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this._rs.getRow();
    }

    @Override
    public boolean absolute(int a) throws SQLException {
        return this._rs.absolute(a);
    }

    @Override
    public boolean relative(int a) throws SQLException {
        return this._rs.relative(a);
    }

    @Override
    public boolean previous() throws SQLException {
        return this._rs.previous();
    }

    @Override
    public void setFetchDirection(int a) throws SQLException {
        this._rs.setFetchDirection(a);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._rs.getFetchDirection();
    }

    @Override
    public void setFetchSize(int a) throws SQLException {
        this._rs.setFetchSize(a);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._rs.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this._rs.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._rs.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this._rs.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this._rs.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this._rs.rowDeleted();
    }

    @Override
    public void updateNull(int a) throws SQLException {
        this._rs.updateNull(a);
    }

    @Override
    public void updateBoolean(int a, boolean b) throws SQLException {
        this._rs.updateBoolean(a, b);
    }

    @Override
    public void updateByte(int a, byte b) throws SQLException {
        this._rs.updateByte(a, b);
    }

    @Override
    public void updateShort(int a, short b) throws SQLException {
        this._rs.updateShort(a, b);
    }

    @Override
    public void updateInt(int a, int b) throws SQLException {
        this._rs.updateInt(a, b);
    }

    @Override
    public void updateLong(int a, long b) throws SQLException {
        this._rs.updateLong(a, b);
    }

    @Override
    public void updateFloat(int a, float b) throws SQLException {
        this._rs.updateFloat(a, b);
    }

    @Override
    public void updateDouble(int a, double b) throws SQLException {
        this._rs.updateDouble(a, b);
    }

    @Override
    public void updateBigDecimal(int a, BigDecimal b) throws SQLException {
        this._rs.updateBigDecimal(a, b);
    }

    @Override
    public void updateString(int a, String b) throws SQLException {
        this._rs.updateString(a, b);
    }

    @Override
    public void updateBytes(int a, byte[] b) throws SQLException {
        this._rs.updateBytes(a, b);
    }

    @Override
    public void updateDate(int a, Date b) throws SQLException {
        this._rs.updateDate(a, b);
    }

    @Override
    public void updateTime(int a, Time b) throws SQLException {
        this._rs.updateTime(a, b);
    }

    @Override
    public void updateTimestamp(int a, Timestamp b) throws SQLException {
        this._rs.updateTimestamp(a, b);
    }

    @Override
    public void updateAsciiStream(int a, InputStream in, int b) throws SQLException {
        this._rs.updateAsciiStream(a, in, b);
    }

    @Override
    public void updateBinaryStream(int a, InputStream in, int b) throws SQLException {
        this._rs.updateBinaryStream(a, in, b);
    }

    @Override
    public void updateBlob(int a, Blob blob) throws SQLException {
        this._rs.updateBlob(a, blob);
    }

    @Override
    public void updateCharacterStream(int a, Reader reader, int b) throws SQLException {
        this._rs.updateCharacterStream(a, reader, b);
    }

    @Override
    public void updateClob(int a, Clob clob) throws SQLException {
        this._rs.updateClob(a, clob);
    }

    @Override
    public void updateObject(int a, Object ob, int b) throws SQLException {
        this._rs.updateObject(a, ob, b);
    }

    @Override
    public void updateObject(int a, Object ob) throws SQLException {
        this._rs.updateObject(a, ob);
    }

    @Override
    public void updateNull(String a) throws SQLException {
        this._rs.updateNull(a);
    }

    @Override
    public void updateBoolean(String a, boolean b) throws SQLException {
        this._rs.updateBoolean(a, b);
    }

    @Override
    public void updateByte(String a, byte b) throws SQLException {
        this._rs.updateByte(a, b);
    }

    @Override
    public void updateShort(String a, short b) throws SQLException {
        this._rs.updateShort(a, b);
    }

    @Override
    public void updateInt(String a, int b) throws SQLException {
        this._rs.updateInt(a, b);
    }

    @Override
    public void updateLong(String a, long b) throws SQLException {
        this._rs.updateLong(a, b);
    }

    @Override
    public void updateFloat(String a, float b) throws SQLException {
        this._rs.updateFloat(a, b);
    }

    @Override
    public void updateDouble(String a, double b) throws SQLException {
        this._rs.updateDouble(a, b);
    }

    @Override
    public void updateBigDecimal(String a, BigDecimal b) throws SQLException {
        this._rs.updateBigDecimal(a, b);
    }

    @Override
    public void updateString(String a, String b) throws SQLException {
        this._rs.updateString(a, b);
    }

    @Override
    public void updateBytes(String a, byte[] b) throws SQLException {
        this._rs.updateBytes(a, b);
    }

    @Override
    public void updateDate(String a, Date b) throws SQLException {
        this._rs.updateDate(a, b);
    }

    @Override
    public void updateTime(String a, Time b) throws SQLException {
        this._rs.updateTime(a, b);
    }

    @Override
    public void updateTimestamp(String a, Timestamp b) throws SQLException {
        this._rs.updateTimestamp(a, b);
    }

    @Override
    public void updateAsciiStream(String a, InputStream in, int b) throws SQLException {
        this._rs.updateAsciiStream(a, in, b);
    }

    @Override
    public void updateBinaryStream(String a, InputStream in, int b) throws SQLException {
        this._rs.updateBinaryStream(a, in, b);
    }

    @Override
    public void updateCharacterStream(String a, Reader reader, int b) throws SQLException {
        this._rs.updateCharacterStream(a, reader, b);
    }

    @Override
    public void updateObject(String a, Object ob, int b) throws SQLException {
        this._rs.updateObject(a, ob, b);
    }

    @Override
    public void updateObject(String a, Object b) throws SQLException {
        this._rs.updateObject(a, b);
    }

    @Override
    public void insertRow() throws SQLException {
        this._rs.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this._rs.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this._rs.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this._rs.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this._rs.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this._rs.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this._rs.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._stmnt;
    }

    @Override
    public Object getObject(int a, Map<String, Class<?>> b) throws SQLException {
        return this._rs.getObject(a, b);
    }

    @Override
    public Ref getRef(int a) throws SQLException {
        return this._rs.getRef(a);
    }

    @Override
    public Blob getBlob(int a) throws SQLException {
        return this._rs.getBlob(a);
    }

    @Override
    public Clob getClob(int a) throws SQLException {
        return this._rs.getClob(a);
    }

    @Override
    public Array getArray(int a) throws SQLException {
        return this._rs.getArray(a);
    }

    @Override
    public Object getObject(String a, Map<String, Class<?>> b) throws SQLException {
        return this._rs.getObject(a, b);
    }

    @Override
    public Ref getRef(String a) throws SQLException {
        return this._rs.getRef(a);
    }

    @Override
    public Blob getBlob(String a) throws SQLException {
        return this._rs.getBlob(a);
    }

    @Override
    public Clob getClob(String a) throws SQLException {
        return this._rs.getClob(a);
    }

    @Override
    public Array getArray(String a) throws SQLException {
        return this._rs.getArray(a);
    }

    @Override
    public Date getDate(int a, Calendar b) throws SQLException {
        return this._rs.getDate(a, b);
    }

    @Override
    public Date getDate(String a, Calendar b) throws SQLException {
        return this._rs.getDate(a, b);
    }

    @Override
    public Time getTime(int a, Calendar b) throws SQLException {
        return this._rs.getTime(a, b);
    }

    @Override
    public Time getTime(String a, Calendar b) throws SQLException {
        return this._rs.getTime(a, b);
    }

    @Override
    public Timestamp getTimestamp(int a, Calendar b) throws SQLException {
        return this._rs.getTimestamp(a, b);
    }

    @Override
    public Timestamp getTimestamp(String a, Calendar b) throws SQLException {
        return this._rs.getTimestamp(a, b);
    }

    @Override
    public URL getURL(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int column, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int column, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapperFor(Class iface) {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    public Object unwrap(Class iface) {
        if (this.isWrapperFor(iface)) {
            return this.getDelegate();
        }
        return null;
    }

    static {
        try {
            concreteImpl = ConcreteClassGenerator.getConcreteConstructor(DelegatingResultSet.class, ResultSet.class, Statement.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

