/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedBrokerImpl;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.ReplicationPolicy;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.jdbc.DistributedDataSource;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedJDBCConfigurationImpl
extends JDBCConfigurationImpl
implements DistributedJDBCConfiguration {
    private final List<Slice> _slices = new ArrayList<Slice>();
    private Slice _master;
    private DistributedDataSource virtualDataSource;
    protected BooleanValue lenientPlugin;
    protected StringValue masterPlugin;
    protected StringListValue namesPlugin;
    public PluginValue distributionPolicyPlugin;
    public PluginValue replicationPolicyPlugin;
    protected Log log;
    protected String unit;
    public static final String DOT = ".";
    public static final String REGEX_DOT = "\\.";
    public static final String PREFIX_SLICE = "openjpa.slice.";
    public static final String PREFIX_OPENJPA = "openjpa.";
    private static Localizer _loc = Localizer.forPackage(DistributedJDBCConfigurationImpl.class);

    public DistributedJDBCConfigurationImpl(ConfigurationProvider cp) {
        super(true, false);
        Map<String, Object> p = cp.getProperties();
        this.log = this.getConfigurationLog();
        this.unit = this.getPersistenceUnitName(p);
        this.setDiagnosticContext(this, this.unit);
        this.brokerPlugin.setString(DistributedBrokerImpl.class.getName());
        this.distributionPolicyPlugin = this.addPlugin("openjpa.slice.DistributionPolicy", true);
        this.distributionPolicyPlugin.setAlias("random", DistributionPolicy.Default.class.getName());
        this.distributionPolicyPlugin.setDefault("random");
        this.distributionPolicyPlugin.setDynamic(true);
        this.replicationPolicyPlugin = this.addPlugin("openjpa.slice.ReplicationPolicy", true);
        this.replicationPolicyPlugin.setAlias("all", ReplicationPolicy.Default.class.getName());
        this.replicationPolicyPlugin.setDefault("all");
        this.replicationPolicyPlugin.setDynamic(true);
        this.lenientPlugin = this.addBoolean("openjpa.slice.Lenient");
        this.masterPlugin = this.addString("openjpa.slice.Master");
        this.namesPlugin = this.addStringList("openjpa.slice.Names");
        this.setSlices(p);
    }

    private String getPersistenceUnitName(Map p) {
        Object unit = p.get(PREFIX_OPENJPA + this.id.getProperty());
        return unit == null ? "?" : unit.toString();
    }

    private void setDiagnosticContext(OpenJPAConfiguration conf, String unit) {
        LogFactory logFactory = conf.getLogFactory();
        if (logFactory instanceof LogFactoryImpl) {
            ((LogFactoryImpl)logFactory).setDiagnosticContext(unit);
        }
    }

    @Override
    public List<String> getActiveSliceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Slice slice : this._slices) {
            if (!slice.isActive() || result.contains(slice.getName())) continue;
            result.add(slice.getName());
        }
        return result;
    }

    @Override
    public List<String> getAvailableSliceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Slice slice : this._slices) {
            result.add(slice.getName());
        }
        return result;
    }

    @Override
    public List<Slice> getSlices(Slice.Status ... statuses) {
        if (statuses == null) {
            return Collections.unmodifiableList(this._slices);
        }
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (Slice slice : this._slices) {
            for (Slice.Status status : statuses) {
                if (!slice.getStatus().equals((Object)status)) continue;
                result.add(slice);
            }
        }
        return result;
    }

    @Override
    public Slice getMaster() {
        return this._master;
    }

    @Override
    public Slice getSlice(String name) {
        return this.getSlice(name, false);
    }

    public Slice getSlice(String name, boolean mustExist) {
        for (Slice slice : this._slices) {
            if (!slice.getName().equals(name)) continue;
            return slice;
        }
        if (mustExist) {
            throw new UserException(_loc.get("slice-not-found", name, this.getActiveSliceNames()));
        }
        return null;
    }

    @Override
    public DistributionPolicy getDistributionPolicyInstance() {
        if (this.distributionPolicyPlugin.get() == null) {
            this.distributionPolicyPlugin.instantiate(DistributionPolicy.class, this, true);
        }
        return (DistributionPolicy)this.distributionPolicyPlugin.get();
    }

    @Override
    public String getDistributionPolicy() {
        if (this.distributionPolicyPlugin.get() == null) {
            this.distributionPolicyPlugin.instantiate(DistributionPolicy.class, this, true);
        }
        return this.distributionPolicyPlugin.getString();
    }

    @Override
    public void setDistributionPolicyInstance(DistributionPolicy policy) {
        this.distributionPolicyPlugin.set(policy);
    }

    @Override
    public void setDistributionPolicy(String policy) {
        this.distributionPolicyPlugin.setString(policy);
    }

    @Override
    public ReplicationPolicy getReplicationPolicyInstance() {
        if (this.replicationPolicyPlugin.get() == null) {
            this.replicationPolicyPlugin.instantiate(ReplicationPolicy.class, this, true);
        }
        return (ReplicationPolicy)this.replicationPolicyPlugin.get();
    }

    @Override
    public String getReplicationPolicy() {
        if (this.replicationPolicyPlugin.get() == null) {
            this.replicationPolicyPlugin.instantiate(ReplicationPolicy.class, this, true);
        }
        return this.replicationPolicyPlugin.getString();
    }

    @Override
    public void setReplicationPolicyInstance(ReplicationPolicy policy) {
        this.replicationPolicyPlugin.set(policy);
    }

    @Override
    public void setReplicationPolicy(String policy) {
        this.replicationPolicyPlugin.setString(policy);
    }

    @Override
    public DistributedDataSource getConnectionFactory() {
        if (this.virtualDataSource == null) {
            this.virtualDataSource = this.createDistributedDataStore();
            DataSourceFactory.installDBDictionary(this.getDBDictionaryInstance(), this.virtualDataSource, this, false);
        }
        return this.virtualDataSource;
    }

    public boolean isLenient() {
        return this.lenientPlugin.get();
    }

    private DistributedDataSource createDistributedDataStore() {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        boolean isXA = true;
        for (Slice slice : this._slices) {
            try {
                DataSource ds = this.createDataSource(slice);
                dataSources.add(ds);
                isXA &= this.isXACompliant(ds);
            }
            catch (Throwable ex) {
                this.handleBadConnection(this.isLenient(), slice, ex);
            }
        }
        if (dataSources.isEmpty()) {
            throw new UserException(_loc.get("no-slice"));
        }
        DistributedDataSource result = new DistributedDataSource(dataSources);
        return result;
    }

    DataSource createDataSource(Slice slice) throws Exception {
        JDBCConfiguration conf = (JDBCConfiguration)slice.getConfiguration();
        Log log = conf.getConfigurationLog();
        String url = this.getConnectionInfo(conf);
        if (log.isInfoEnabled()) {
            log.info(_loc.get("slice-connect", slice, url));
        }
        DataSource ds = DataSourceFactory.newDataSource(conf, false);
        DecoratingDataSource dds = DecoratingDataSource.newDecoratingDataSource(ds);
        ds = DataSourceFactory.installDBDictionary(conf.getDBDictionaryInstance(), dds, conf, false);
        this.verifyDataSource(slice, ds, conf);
        return ds;
    }

    String getConnectionInfo(OpenJPAConfiguration conf) {
        String result = conf.getConnectionURL();
        if (result == null) {
            result = conf.getConnectionDriverName();
            String props = conf.getConnectionProperties();
            if (props != null) {
                result = result + "(" + props + ")";
            }
        }
        return result;
    }

    boolean isXACompliant(DataSource ds) {
        if (ds instanceof DelegatingDataSource) {
            return ((DelegatingDataSource)ds).getInnermostDelegate() instanceof XADataSource;
        }
        return ds instanceof XADataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyDataSource(Slice slice, DataSource ds, JDBCConfiguration conf) {
        Connection con = null;
        try {
            con = ds.getConnection(conf.getConnectionUserName(), conf.getConnectionPassword());
            slice.setStatus(Slice.Status.ACTIVE);
            if (con == null) {
                slice.setStatus(Slice.Status.INACTIVE);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            slice.setStatus(Slice.Status.INACTIVE);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private void handleBadConnection(boolean isLenient, Slice slice, Throwable ex) {
        OpenJPAConfiguration conf = slice.getConfiguration();
        String url = conf.getConnectionURL();
        Log log = this.getLog("openjpa.Runtime");
        if (isLenient) {
            if (ex != null) {
                log.warn(_loc.get("slice-connect-known-warn", slice, url, ex.getCause()));
            } else {
                log.warn(_loc.get("slice-connect-warn", slice, url));
            }
        } else {
            if (ex != null) {
                throw new UserException(_loc.get("slice-connect-known-error", slice, url, ex), ex.getCause());
            }
            throw new UserException(_loc.get("slice-connect-error", slice, url));
        }
    }

    void setSlices(Map original) {
        List<String> sliceNames = this.findSlices(original);
        if (sliceNames.isEmpty()) {
            throw new UserException(_loc.get("slice-none-configured"));
        }
        for (String key : sliceNames) {
            Slice slice = this.newSlice(key, original);
            this._slices.add(slice);
        }
        this.setMaster(original);
    }

    protected Slice newSlice(String key, Map original) {
        JDBCConfigurationImpl child = new JDBCConfigurationImpl();
        child.fromProperties(this.createSliceProperties(original, key));
        child.setId(this.unit + DOT + key);
        this.setDiagnosticContext(child, this.unit + DOT + key);
        Slice slice = new Slice(key, child);
        if (this.log.isTraceEnabled()) {
            this.log.trace(_loc.get("slice-configuration", key, child.toProperties(false)));
        }
        return slice;
    }

    private List<String> findSlices(Map p) {
        ArrayList<String> sliceNames = new ArrayList();
        Log log = this.getConfigurationLog();
        String key = this.namesPlugin.getProperty();
        boolean explicit = p.containsKey(key);
        if (explicit) {
            String[] values;
            for (String name : values = p.get(key).toString().split("\\,")) {
                if (sliceNames.contains(name.trim())) continue;
                sliceNames.add(name.trim());
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn(_loc.get("no-slice-names", key));
            }
            sliceNames = this.scanForSliceNames(p);
            Collections.sort(sliceNames);
        }
        if (log.isInfoEnabled()) {
            log.info(_loc.get("slice-available", sliceNames));
        }
        return sliceNames;
    }

    private List<String> scanForSliceNames(Map p) {
        ArrayList<String> sliceNames = new ArrayList<String>();
        for (Object o : p.keySet()) {
            String sliceName;
            String key = o.toString();
            if (!key.startsWith(PREFIX_SLICE) || DistributedJDBCConfigurationImpl.getPartCount(key) <= 3 || sliceNames.contains(sliceName = DistributedJDBCConfigurationImpl.chopTail(DistributedJDBCConfigurationImpl.chopHead(o.toString(), PREFIX_SLICE), DOT))) continue;
            sliceNames.add(sliceName);
        }
        return sliceNames;
    }

    private static int getPartCount(String s) {
        return s == null ? 0 : s.split(REGEX_DOT).length;
    }

    private static String chopHead(String s, String head) {
        if (s.startsWith(head)) {
            return s.substring(head.length());
        }
        return s;
    }

    private static String chopTail(String s, String tail) {
        int i = s.lastIndexOf(tail);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    Map createSliceProperties(Map original, String slice) {
        Properties result = new Properties();
        String prefix = PREFIX_SLICE + slice + DOT;
        for (Object o : original.keySet()) {
            String newKey;
            String key = o.toString();
            Object value = original.get(key);
            if (value == null) continue;
            if (key.startsWith(prefix)) {
                newKey = PREFIX_OPENJPA + key.substring(prefix.length());
                result.put(newKey, value);
                continue;
            }
            if (key.startsWith(PREFIX_SLICE)) continue;
            if (key.startsWith(PREFIX_OPENJPA)) {
                newKey = prefix + key.substring(PREFIX_OPENJPA.length());
                if (original.containsKey(newKey)) continue;
                result.put(key, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private void setMaster(Map original) {
        String key = this.masterPlugin.getProperty();
        Object masterSlice = original.get(key);
        Log log = this.getConfigurationLog();
        List<Slice> activeSlices = this.getSlices(null);
        if (masterSlice == null) {
            this._master = activeSlices.get(0);
            if (log.isWarnEnabled()) {
                log.warn(_loc.get("no-master-slice", key, this._master));
            }
            return;
        }
        for (Slice slice : activeSlices) {
            if (!slice.getName().equals(masterSlice)) continue;
            this._master = slice;
        }
        if (this._master == null) {
            this._master = activeSlices.get(0);
        }
    }

    @Override
    public Slice addSlice(String name, Map newProps) {
        String prefix = "openjpa.slice.." + name + DOT;
        for (Object key : newProps.keySet()) {
            if (String.class.isInstance(key) || !key.toString().startsWith(prefix)) continue;
            throw new UserException(_loc.get("slice-add-wrong-key", key));
        }
        Slice slice = this.getSlice(name);
        if (slice != null) {
            throw new UserException(_loc.get("slice-exists", name));
        }
        Map original = super.toProperties(true);
        original.putAll(newProps);
        slice = this.newSlice(name, original);
        this._slices.add(slice);
        try {
            this.virtualDataSource.addDataSource(this.createDataSource(slice));
        }
        catch (Exception ex) {
            this.handleBadConnection(false, slice, ex);
            return null;
        }
        return slice;
    }
}

