/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.BitSet;
import java.util.Collection;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.TransferFieldManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachManagerLite {
    public void detachAll(Collection<StateManagerImpl> states) {
        TransferFieldManager fm = new TransferFieldManager();
        for (StateManagerImpl sm : states) {
            PersistenceCapable pc;
            ClassMetaData cmd = sm.getMetaData();
            if (!sm.isPersistent() || !cmd.isDetachable() || (pc = sm.getPersistenceCapable()).pcIsDetached().booleanValue()) continue;
            BitSet loaded = sm.getLoaded();
            for (FieldMetaData fmd : cmd.getProxyFields()) {
                if (!loaded.get(fmd.getIndex())) continue;
                this.detachProxyField(fmd, pc, sm, fm);
            }
            pc.pcReplaceStateManager(null);
        }
    }

    private void detachProxyField(FieldMetaData fmd, PersistenceCapable pc, StateManagerImpl sm, TransferFieldManager fm) {
        int fieldIndex = fmd.getIndex();
        if (fmd.isLRS()) {
            this.nullField(fieldIndex, pc, sm, fm);
        } else {
            Object o = sm.fetchObject(fieldIndex);
            if (o instanceof Proxy) {
                Proxy proxy2 = (Proxy)o;
                Object unproxied = proxy2.copy(proxy2);
                fm.storeObjectField(fieldIndex, unproxied);
                sm.replaceField(pc, fm, fieldIndex);
                fm.clear();
                proxy2.setOwner(null, -1);
                if (proxy2.getChangeTracker() != null) {
                    proxy2.getChangeTracker().stopTracking();
                }
            }
        }
    }

    private void nullField(int fieldIndex, PersistenceCapable pc, StateManagerImpl sm, TransferFieldManager fm) {
        fm.storeObjectField(fieldIndex, null);
        sm.replaceField(pc, fm, fieldIndex);
        fm.clear();
    }
}

