/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.CacheDistributionPolicy;
import org.apache.openjpa.datacache.ClearableScheduler;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCacheMode;
import org.apache.openjpa.datacache.DataCachePCDataGenerator;
import org.apache.openjpa.datacache.DefaultCacheDistributionPolicy;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.ImplHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCacheManagerImpl
implements Closeable,
DataCacheManager {
    private OpenJPAConfiguration _conf;
    private DataCache _cache = null;
    private QueryCache _queryCache = null;
    private DataCachePCDataGenerator _pcGenerator = null;
    private ClearableScheduler _scheduler = null;
    private CacheDistributionPolicy _policy = new DefaultCacheDistributionPolicy();
    private Map<ClassMetaData, Boolean> _cacheable = new HashMap<ClassMetaData, Boolean>();
    private Set<String> _includedTypes;
    private Set<String> _excludedTypes;

    @Override
    public void initialize(OpenJPAConfiguration conf, ObjectValue dataCache, ObjectValue queryCache) {
        this._conf = conf;
        this._cache = (DataCache)dataCache.instantiate(DataCache.class, conf);
        if (this._cache == null) {
            return;
        }
        if (conf.getDynamicDataStructs()) {
            this._pcGenerator = new DataCachePCDataGenerator(conf);
        }
        this._scheduler = new ClearableScheduler(conf);
        this._policy = conf.getCacheDistributionPolicyInstance();
        this._cache.initialize(this);
        this._queryCache = (QueryCache)queryCache.instantiate(QueryCache.class, conf);
        if (this._queryCache != null) {
            this._queryCache.initialize(this);
        }
    }

    @Override
    public DataCache getSystemDataCache() {
        return this.getDataCache(null, false);
    }

    @Override
    public DataCache getDataCache(String name) {
        return this.getDataCache(name, false);
    }

    @Override
    public DataCache getDataCache(String name, boolean create) {
        if (name == null || this._cache != null && name.equals(this._cache.getName())) {
            return this._cache;
        }
        if (this._cache != null) {
            return this._cache.getPartition(name, create);
        }
        return null;
    }

    @Override
    public QueryCache getSystemQueryCache() {
        return this._queryCache;
    }

    @Override
    public DataCachePCDataGenerator getPCDataGenerator() {
        return this._pcGenerator;
    }

    @Override
    public ClearableScheduler getClearableScheduler() {
        return this._scheduler;
    }

    @Override
    public void close() {
        ImplHelper.close(this._cache);
        ImplHelper.close(this._queryCache);
        if (this._scheduler != null) {
            this._scheduler.stop();
        }
    }

    @Override
    public DataCache selectCache(OpenJPAStateManager sm) {
        if (sm == null || !this.isCachable(sm.getMetaData())) {
            return null;
        }
        String name = this._policy.selectCache(sm, null);
        return name == null ? null : this.getDataCache(name);
    }

    @Override
    public CacheDistributionPolicy getDistributionPolicy() {
        return this._policy;
    }

    public boolean isCachable(ClassMetaData meta) {
        Boolean res = this._cacheable.get(meta);
        if (res != null) {
            return res;
        }
        Boolean isCachable = this.isCacheableByMode(meta);
        if (isCachable == null) {
            isCachable = this.isCacheableByType(meta);
        }
        this._cacheable.put(meta, isCachable);
        return isCachable;
    }

    public void setTypes(Set<String> includedTypes, Set<String> excludedTypes) {
        this._includedTypes = includedTypes;
        this._excludedTypes = excludedTypes;
    }

    private Boolean isCacheableByMode(ClassMetaData meta) {
        String mode = this._conf.getDataCacheMode();
        if (DataCacheMode.ALL.toString().equalsIgnoreCase(mode)) {
            return true;
        }
        if (DataCacheMode.NONE.toString().equalsIgnoreCase(mode)) {
            return false;
        }
        if (DataCacheMode.ENABLE_SELECTIVE.toString().equalsIgnoreCase(mode)) {
            return Boolean.TRUE.equals(meta.getCacheEnabled());
        }
        if (DataCacheMode.DISABLE_SELECTIVE.toString().equalsIgnoreCase(mode)) {
            return !Boolean.FALSE.equals(meta.getCacheEnabled());
        }
        return null;
    }

    private Boolean isCacheableByType(ClassMetaData meta) {
        if (this._includedTypes != null && this._includedTypes.size() > 0) {
            return this._includedTypes.contains(meta.getDescribedType().getName());
        }
        if (this._excludedTypes != null && this._excludedTypes.size() > 0) {
            if (this._excludedTypes.contains(meta.getDescribedType().getName())) {
                return false;
            }
            return true;
        }
        return meta.getDataCacheName() != null;
    }
}

