/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.BitSet;
import java.util.Collection;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingStoreManager
implements StoreManager {
    private final StoreManager _store;
    private final DelegatingStoreManager _del;

    public DelegatingStoreManager(StoreManager store) {
        this._store = store;
        this._del = store instanceof DelegatingStoreManager ? (DelegatingStoreManager)this._store : null;
    }

    public StoreManager getDelegate() {
        return this._store;
    }

    public StoreManager getInnermostDelegate() {
        return this._del == null ? this._store : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingStoreManager) {
            other = ((DelegatingStoreManager)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    @Override
    public void setContext(StoreContext ctx) {
        this._store.setContext(ctx);
    }

    @Override
    public void beginOptimistic() {
        this._store.beginOptimistic();
    }

    @Override
    public void rollbackOptimistic() {
        this._store.rollbackOptimistic();
    }

    @Override
    public void begin() {
        this._store.begin();
    }

    @Override
    public void commit() {
        this._store.commit();
    }

    @Override
    public void rollback() {
        this._store.rollback();
    }

    @Override
    public boolean exists(OpenJPAStateManager sm, Object context) {
        return this._store.exists(sm, context);
    }

    @Override
    public boolean syncVersion(OpenJPAStateManager sm, Object context) {
        return this._store.syncVersion(sm, context);
    }

    @Override
    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context) {
        return this._store.initialize(sm, state, fetch, context);
    }

    @Override
    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) {
        return this._store.load(sm, fields, fetch, lockLevel, context);
    }

    @Override
    public Collection<Object> loadAll(Collection<OpenJPAStateManager> sms, PCState state, int load, FetchConfiguration fetch, Object context) {
        return this._store.loadAll(sms, state, load, fetch, context);
    }

    @Override
    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
        this._store.beforeStateChange(sm, fromState, toState);
    }

    @Override
    public Collection<Exception> flush(Collection<OpenJPAStateManager> sms) {
        return this._store.flush(sms);
    }

    @Override
    public boolean assignObjectId(OpenJPAStateManager sm, boolean preFlush) {
        return this._store.assignObjectId(sm, preFlush);
    }

    @Override
    public boolean assignField(OpenJPAStateManager sm, int field, boolean preFlush) {
        return this._store.assignField(sm, field, preFlush);
    }

    @Override
    public Class<?> getManagedType(Object oid) {
        return this._store.getManagedType(oid);
    }

    @Override
    public Class<?> getDataStoreIdType(ClassMetaData meta) {
        return this._store.getDataStoreIdType(meta);
    }

    @Override
    public Object copyDataStoreId(Object oid, ClassMetaData meta) {
        return this._store.copyDataStoreId(oid, meta);
    }

    @Override
    public Object newDataStoreId(Object oidVal, ClassMetaData meta) {
        return this._store.newDataStoreId(oidVal, meta);
    }

    @Override
    public Object getClientConnection() {
        return this._store.getClientConnection();
    }

    @Override
    public void retainConnection() {
        this._store.retainConnection();
    }

    @Override
    public void releaseConnection() {
        this._store.releaseConnection();
    }

    @Override
    public ResultObjectProvider executeExtent(ClassMetaData meta, boolean subclasses, FetchConfiguration fetch) {
        return this._store.executeExtent(meta, subclasses, fetch);
    }

    @Override
    public StoreQuery newQuery(String language) {
        return this._store.newQuery(language);
    }

    @Override
    public FetchConfiguration newFetchConfiguration() {
        return this._store.newFetchConfiguration();
    }

    @Override
    public void close() {
        this._store.close();
    }

    @Override
    public int compareVersion(OpenJPAStateManager state, Object v1, Object v2) {
        return this._store.compareVersion(state, v1, v2);
    }

    @Override
    public Seq getDataStoreIdSequence(ClassMetaData forClass) {
        return this._store.getDataStoreIdSequence(forClass);
    }

    @Override
    public Seq getValueSequence(FieldMetaData fmd) {
        return this._store.getValueSequence(fmd);
    }

    @Override
    public boolean cancelAll() {
        return this._store.cancelAll();
    }
}

