/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.event.TransactionEventManager;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.AttachManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.DetachManager;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.ExtentImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.kernel.InverseManager;
import org.apache.openjpa.kernel.LocalManagedRuntime;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.ManagedCache;
import org.apache.openjpa.kernel.MethodStoreQuery;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPASavepoint;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.SavepointFieldManager;
import org.apache.openjpa.kernel.SavepointManager;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.UUIDHexSeq;
import org.apache.openjpa.kernel.UUIDStringSeq;
import org.apache.openjpa.kernel.UUIDType4HexSeq;
import org.apache.openjpa.kernel.UUIDType4StringSeq;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ReferenceHashMap;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.CallbackException;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.NoTransactionException;
import org.apache.openjpa.util.ObjectExistsException;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import org.apache.openjpa.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerImpl
implements Broker,
FindCallbacks,
Cloneable,
Serializable {
    protected static final int FLUSH_INC = 0;
    protected static final int FLUSH_COMMIT = 1;
    protected static final int FLUSH_ROLLBACK = 2;
    protected static final int FLUSH_LOGICAL = 3;
    static final int STATUS_INIT = 0;
    static final int STATUS_TRANSIENT = 1;
    static final int STATUS_OID_ASSIGN = 2;
    static final int STATUS_COMMIT_NEW = 3;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STORE_ACTIVE = 4;
    private static final int FLAG_CLOSE_INVOKED = 8;
    private static final int FLAG_PRESTORING = 16;
    private static final int FLAG_DEREFDELETING = 32;
    private static final int FLAG_FLUSHING = 64;
    private static final int FLAG_STORE_FLUSHING = 128;
    private static final int FLAG_FLUSHED = 256;
    private static final int FLAG_FLUSH_REQUIRED = 512;
    private static final int FLAG_REMOTE_LISTENER = 1024;
    private static final int FLAG_RETAINED_CONN = 2048;
    private static final int FLAG_TRANS_ENDING = 4096;
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final Localizer _loc = Localizer.forPackage(BrokerImpl.class);
    private transient DelegatingStoreManager _store = null;
    private FetchConfiguration _fc = null;
    private String _user = null;
    private String _pass = null;
    private transient Log _log = null;
    private transient Compatibility _compat = null;
    private transient ManagedRuntime _runtime = null;
    private transient LockManager _lm = null;
    private transient InverseManager _im = null;
    private transient ReentrantLock _lock = null;
    private transient OpCallbacks _call = null;
    private transient RuntimeExceptionTranslator _extrans = null;
    private transient AbstractBrokerFactory _factory = null;
    private transient OpenJPAConfiguration _conf = null;
    private transient ClassLoader _loader = null;
    private Synchronization _sync = null;
    private Map<Object, Object> _userObjects = null;
    private ManagedCache _cache = null;
    private TransactionalCache _transCache = null;
    private Set<StateManagerImpl> _transAdditions = null;
    private Set<StateManagerImpl> _derefCache = null;
    private Set<StateManagerImpl> _derefAdditions = null;
    private transient Map<Object, StateManagerImpl> _loading = null;
    private transient Set<Object> _operating = null;
    private Set<Class<?>> _persistedClss = null;
    private Set<Class<?>> _updatedClss = null;
    private Set<Class<?>> _deletedClss = null;
    private Set<StateManagerImpl> _pending = null;
    private int findAllDepth = 0;
    private Set<StateManagerImpl> _savepointCache = null;
    private LinkedMap _savepoints = null;
    private transient SavepointManager _spm = null;
    private transient ReferenceHashSet _queries = null;
    private transient ReferenceHashSet _extents = null;
    private transient int _operationCount = 0;
    private boolean _nontransRead = false;
    private boolean _nontransWrite = false;
    private boolean _retainState = false;
    private int _autoClear = 0;
    private int _restoreState = 1;
    private boolean _optimistic = false;
    private boolean _ignoreChanges = false;
    private boolean _multithreaded = false;
    private boolean _managed = false;
    private boolean _syncManaged = false;
    private int _connRetainMode = 0;
    private boolean _evictDataCache = false;
    private boolean _populateDataCache = true;
    private boolean _largeTransaction = false;
    private int _autoDetach = 0;
    private int _detachState = 1;
    private boolean _detachedNew = true;
    private boolean _orderDirty = false;
    private boolean _cachePreparedQuery = true;
    private boolean _cacheFinderQuery = true;
    private boolean _suppressBatchOLELogging = false;
    private int _flags = 0;
    private transient boolean _isSerializing = false;
    private transient boolean _closed = false;
    private transient RuntimeException _closedException = null;
    private TransactionEventManager _transEventManager = null;
    private int _transCallbackMode = 0;
    private LifecycleEventManager _lifeEventManager = null;
    private int _lifeCallbackMode = 0;
    private transient boolean _initializeWasInvoked = false;
    private transient boolean _fromWriteBehindCallback = false;
    private LinkedList<FetchConfiguration> _fcs;
    private static Set<String> _supportedPropertyNames = new HashSet<String>();

    public void setAuthentication(String user, String pass) {
        this._user = user;
        this._pass = pass;
    }

    public void initialize(AbstractBrokerFactory factory, DelegatingStoreManager sm, boolean managed, int connMode, boolean fromDeserialization) {
        this.initialize(factory, sm, managed, connMode, fromDeserialization, false);
    }

    public void initialize(AbstractBrokerFactory factory, DelegatingStoreManager sm, boolean managed, int connMode, boolean fromDeserialization, boolean fromWriteBehindCallback) {
        this._fromWriteBehindCallback = fromWriteBehindCallback;
        this._initializeWasInvoked = true;
        this._loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        if (!fromDeserialization) {
            this._conf = factory.getConfiguration();
        }
        this._compat = this._conf.getCompatibilityInstance();
        this._factory = factory;
        this._log = this._conf.getLog("openjpa.Runtime");
        if (!fromDeserialization) {
            this._cache = new ManagedCache(this);
        }
        this.initializeOperatingSet();
        this._connRetainMode = connMode;
        this._managed = managed;
        this._runtime = managed ? this._conf.getManagedRuntimeInstance() : new LocalManagedRuntime(this);
        if (!fromDeserialization) {
            this._lifeEventManager = this._conf.getLifecycleEventManagerInstance();
            this._transEventManager = new TransactionEventManager();
            int cmode = this._conf.getMetaDataRepositoryInstance().getMetaDataFactory().getDefaults().getCallbackMode();
            this.setLifecycleListenerCallbackMode(cmode);
            this.setTransactionListenerCallbackMode(cmode);
            this._factory.configureBroker(this);
        }
        this._store = sm;
        this._lm = this._conf.newLockManagerInstance();
        this._im = this._conf.newInverseManagerInstance();
        this._spm = this._conf.getSavepointManagerInstance();
        this._store.setContext(this);
        this._lm.setContext(this);
        if (this._connRetainMode == 2) {
            this.retainConnection();
        }
        if (!fromDeserialization) {
            this._fc = this._store.newFetchConfiguration();
            this._fc.setContext(this);
        }
        if (this._factory.syncWithManagedTransaction(this, false)) {
            this.beginInternal();
        }
    }

    private void initializeOperatingSet() {
        this._operating = MapBackedSet.decorate(new IdentityMap());
    }

    protected Set<Object> getOperatingSet() {
        return Collections.unmodifiableSet(this._operating);
    }

    public Object clone() throws CloneNotSupportedException {
        if (this._initializeWasInvoked) {
            throw new CloneNotSupportedException();
        }
        return super.clone();
    }

    protected Map<?, ?> newManagedObjectCache() {
        return new ReferenceHashMap(0, 2);
    }

    @Override
    public Broker getBroker() {
        return this;
    }

    @Override
    public void setImplicitBehavior(OpCallbacks call, RuntimeExceptionTranslator ex) {
        if (this._call == null) {
            this._call = call;
        }
        if (this._extrans == null) {
            this._extrans = ex;
        }
    }

    RuntimeExceptionTranslator getInstanceExceptionTranslator() {
        return this._operationCount == 0 ? this._extrans : null;
    }

    @Override
    public BrokerFactory getBrokerFactory() {
        return this._factory;
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    @Override
    public FetchConfiguration pushFetchConfiguration() {
        if (this._fcs == null) {
            this._fcs = new LinkedList();
        }
        this._fcs.add(this._fc);
        this._fc = (FetchConfiguration)this._fc.clone();
        return this._fc;
    }

    @Override
    public void popFetchConfiguration() {
        if (this._fcs == null || this._fcs.isEmpty()) {
            throw new UserException(_loc.get("fetch-configuration-stack-empty"));
        }
        this._fc = this._fcs.removeLast();
    }

    @Override
    public int getConnectionRetainMode() {
        return this._connRetainMode;
    }

    @Override
    public boolean isManaged() {
        return this._managed;
    }

    @Override
    public ManagedRuntime getManagedRuntime() {
        return this._runtime;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    @Override
    public DelegatingStoreManager getStoreManager() {
        return this._store;
    }

    @Override
    public LockManager getLockManager() {
        return this._lm;
    }

    @Override
    public InverseManager getInverseManager() {
        return this._im;
    }

    @Override
    public String getConnectionUserName() {
        return this._user;
    }

    @Override
    public String getConnectionPassword() {
        return this._pass;
    }

    @Override
    public boolean getMultithreaded() {
        return this._multithreaded;
    }

    @Override
    public void setMultithreaded(boolean multithreaded) {
        this.assertOpen();
        this._multithreaded = multithreaded;
        if (multithreaded && this._lock == null) {
            this._lock = new ReentrantLock();
        } else if (!multithreaded) {
            this._lock = null;
        }
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._ignoreChanges;
    }

    @Override
    public void setIgnoreChanges(boolean val) {
        this.assertOpen();
        this._ignoreChanges = val;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this._nontransRead;
    }

    @Override
    public void setNontransactionalRead(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        if (val && !this._conf.supportedOptions().contains("openjpa.option.NontransactionalRead")) {
            throw new UnsupportedException(_loc.get("nontrans-read-not-supported"));
        }
        this._nontransRead = val;
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this._nontransWrite;
    }

    @Override
    public void setNontransactionalWrite(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        this._nontransWrite = val;
    }

    @Override
    public boolean getOptimistic() {
        return this._optimistic;
    }

    @Override
    public void setOptimistic(boolean val) {
        this.assertOpen();
        if ((this._flags & 2) != 0) {
            throw new InvalidStateException(_loc.get("trans-active", "Optimistic"));
        }
        if (val && !this._conf.supportedOptions().contains("openjpa.option.Optimistic")) {
            throw new UnsupportedException(_loc.get("optimistic-not-supported"));
        }
        this._optimistic = val;
    }

    @Override
    public int getRestoreState() {
        return this._restoreState;
    }

    @Override
    public void setRestoreState(int val) {
        this.assertOpen();
        if ((this._flags & 2) != 0) {
            throw new InvalidStateException(_loc.get("trans-active", "Restore"));
        }
        this._restoreState = val;
    }

    @Override
    public boolean getRetainState() {
        return this._retainState;
    }

    @Override
    public void setRetainState(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        this._retainState = val;
    }

    @Override
    public int getAutoClear() {
        return this._autoClear;
    }

    @Override
    public void setAutoClear(int val) {
        this.assertOpen();
        this._autoClear = val;
    }

    @Override
    public int getAutoDetach() {
        return this._autoDetach;
    }

    @Override
    public void setAutoDetach(int detachFlags) {
        this.assertOpen();
        this._autoDetach = detachFlags;
    }

    @Override
    public void setAutoDetach(int detachFlag, boolean on) {
        this.assertOpen();
        this._autoDetach = on ? (this._autoDetach |= detachFlag) : (this._autoDetach &= ~detachFlag);
    }

    @Override
    public int getDetachState() {
        return this._detachState;
    }

    @Override
    public void setDetachState(int mode) {
        this.assertOpen();
        this._detachState = mode;
    }

    @Override
    public boolean isDetachedNew() {
        return this._detachedNew;
    }

    @Override
    public void setDetachedNew(boolean isNew) {
        this.assertOpen();
        this._detachedNew = isNew;
    }

    @Override
    public boolean getSyncWithManagedTransactions() {
        return this._syncManaged;
    }

    @Override
    public void setSyncWithManagedTransactions(boolean sync) {
        this.assertOpen();
        this._syncManaged = sync;
    }

    @Override
    public boolean getEvictFromDataCache() {
        return this._evictDataCache;
    }

    @Override
    public void setEvictFromDataCache(boolean evict) {
        this.assertOpen();
        this._evictDataCache = evict;
    }

    @Override
    public boolean getPopulateDataCache() {
        return this._populateDataCache;
    }

    @Override
    public void setPopulateDataCache(boolean cache) {
        this.assertOpen();
        this._populateDataCache = cache;
    }

    @Override
    public boolean isTrackChangesByType() {
        return this._largeTransaction;
    }

    @Override
    public void setTrackChangesByType(boolean largeTransaction) {
        this.assertOpen();
        this._largeTransaction = largeTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserObject(Object key) {
        this.beginOperation(false);
        try {
            Object object = this._userObjects == null ? null : this._userObjects.get(key);
            return object;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putUserObject(Object key, Object val) {
        this.beginOperation(false);
        try {
            if (val == null) {
                Object object = this._userObjects == null ? null : this._userObjects.remove(key);
                return object;
            }
            if (this._userObjects == null) {
                this._userObjects = new HashMap<Object, Object>();
            }
            Object object = this._userObjects.put(key, val);
            return object;
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> props = this._conf.toProperties(true);
        for (String s : _supportedPropertyNames) {
            props.put("openjpa." + s, Reflection.getValue(this, s, true));
        }
        return props;
    }

    @Override
    public Set<String> getSupportedProperties() {
        Set<String> keys = this._conf.getPropertyKeys();
        for (String s : _supportedPropertyNames) {
            keys.add("openjpa." + s);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(Object listener, Class[] classes) {
        this.beginOperation(false);
        try {
            this._lifeEventManager.addListener(listener, classes);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(Object listener) {
        this.beginOperation(false);
        try {
            this._lifeEventManager.removeListener(listener);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public int getLifecycleListenerCallbackMode() {
        return this._lifeCallbackMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLifecycleListenerCallbackMode(int mode) {
        this.beginOperation(false);
        try {
            this._lifeCallbackMode = mode;
            this._lifeEventManager.setFailFast((mode & 2) != 0);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public LifecycleEventManager getLifecycleEventManager() {
        return this._lifeEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fireLifecycleEvent(Object src, Object related, ClassMetaData meta, int eventType) {
        Exception[] exs;
        if (this._lifeEventManager == null) {
            return false;
        }
        this.lock();
        try {
            exs = this._lifeEventManager.fireEvent(src, related, meta, eventType);
        }
        finally {
            this.unlock();
        }
        this.handleCallbackExceptions(exs, this._lifeCallbackMode);
        return true;
    }

    private void handleCallbackExceptions(Exception[] exceps, int mode) {
        OpenJPAException ce;
        if (exceps.length == 0 || (mode & 4) != 0) {
            return;
        }
        if (exceps.length == 1) {
            if (exceps[0] instanceof WrappedException) {
                throw (WrappedException)exceps[0];
            }
            ce = new CallbackException(exceps[0]);
        } else {
            ce = new CallbackException(_loc.get("callback-err")).setNestedThrowables(exceps);
        }
        if ((mode & 0x20) != 0 && (this._flags & 2) != 0) {
            ce.setFatal(true);
            this.setRollbackOnlyInternal(ce);
        }
        if ((mode & 8) != 0 && this._log.isWarnEnabled()) {
            this._log.warn(ce);
        }
        if ((mode & 0x10) != 0) {
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionListener(Object tl) {
        this.beginOperation(false);
        try {
            this._transEventManager.addListener(tl);
            if (tl instanceof RemoteCommitEventManager) {
                this._flags |= 0x400;
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionListener(Object tl) {
        this.beginOperation(false);
        try {
            if (this._transEventManager.removeListener(tl) && tl instanceof RemoteCommitEventManager) {
                this._flags &= 0xFFFFFBFF;
            }
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Collection<Object> getTransactionListeners() {
        return this._transEventManager.getListeners();
    }

    @Override
    public int getTransactionListenerCallbackMode() {
        return this._transCallbackMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionListenerCallbackMode(int mode) {
        this.beginOperation(false);
        try {
            this._transCallbackMode = mode;
            this._transEventManager.setFailFast((mode & 2) != 0);
        }
        finally {
            this.endOperation();
        }
    }

    private void fireTransactionEvent(TransactionEvent trans) {
        if (this._transEventManager != null) {
            this.handleCallbackExceptions(this._transEventManager.fireEvent(trans), this._transCallbackMode);
        }
    }

    public void setSuppressBatchOLELogging(boolean b) {
        this._suppressBatchOLELogging = b;
    }

    public boolean getSuppressBatchOLELogging() {
        return this._suppressBatchOLELogging;
    }

    @Override
    public Object find(Object oid, boolean validate, FindCallbacks call) {
        int flags = 28;
        if (!validate) {
            flags |= 2;
        }
        return this.find(oid, this._fc, null, null, flags, call);
    }

    @Override
    public Object find(Object oid, FetchConfiguration fetch, BitSet exclude, Object edata, int flags) {
        return this.find(oid, fetch, exclude, edata, flags, null);
    }

    protected Object find(Object oid, FetchConfiguration fetch, BitSet exclude, Object edata, int flags, FindCallbacks call) {
        if (call == null) {
            call = this;
        }
        if ((oid = call.processArgument(oid)) == null) {
            if ((flags & 2) == 0) {
                throw new ObjectNotFoundException(_loc.get("null-oid"));
            }
            return call.processReturn(oid, null);
        }
        if (fetch == null) {
            fetch = this._fc;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            StateManagerImpl sm = this.getStateManagerImplById(oid, (flags & 0x10) != 0 || this.hasFlushed());
            if (sm != null) {
                if (!this.requiresLoad(sm, true, fetch, edata, flags)) {
                    Object object = call.processReturn(oid, sm);
                    return object;
                }
                if (!sm.isLoading()) {
                    boolean loaded;
                    if (!sm.isTransactional() && this.useTransactionalState(fetch)) {
                        sm.transactional();
                    }
                    try {
                        loaded = sm.load(fetch, 0, exclude, edata, false);
                    }
                    catch (ObjectNotFoundException onfe) {
                        if ((flags & 4) != 0 || (flags & 2) != 0) {
                            throw onfe;
                        }
                        Object object = call.processReturn(oid, null);
                        this.endOperation();
                        return object;
                    }
                    if (!loaded && (flags & 2) == 0 && this._compat.getValidateTrueChecksStore() && !sm.isTransactional() && !this._store.exists(sm, edata)) {
                        if ((flags & 4) == 0) {
                            Object onfe = call.processReturn(oid, null);
                            return onfe;
                        }
                        throw new ObjectNotFoundException(_loc.get("del-instance", sm.getManagedInstance(), oid)).setFailedObject(sm.getManagedInstance());
                    }
                }
                if ((this._flags & 2) != 0) {
                    int level = fetch.getReadLockLevel();
                    this._lm.lock(sm, level, fetch.getLockTimeout(), edata);
                    sm.readLocked(level, fetch.getWriteLockLevel());
                }
                Object level = call.processReturn(oid, sm);
                return level;
            }
            if (oid instanceof StateManagerId) {
                Object level = call.processReturn(oid, null);
                return level;
            }
            sm = this.newStateManagerImpl(oid, (flags & 8) != 0);
            boolean load = this.requiresLoad(sm, false, fetch, edata, flags);
            if ((sm = this.initialize(sm, load, fetch, edata)) == null) {
                if ((flags & 2) != 0) {
                    throw new ObjectNotFoundException(oid);
                }
                Object onfe = call.processReturn(oid, null);
                return onfe;
            }
            if (load) {
                try {
                    sm.load(fetch, 0, exclude, edata, false);
                }
                catch (ObjectNotFoundException onfe) {
                    if ((flags & 4) != 0 || (flags & 2) != 0) {
                        throw onfe;
                    }
                    Object object = call.processReturn(oid, null);
                    this.endOperation();
                    return object;
                }
            }
            Object object = call.processReturn(oid, sm);
            return object;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateManagerImpl initialize(StateManagerImpl sm, boolean load, FetchConfiguration fetch, Object edata) {
        if (!load) {
            sm.initialize(sm.getMetaData().getDescribedType(), PCState.HOLLOW);
        } else {
            PCState state = this.useTransactionalState(fetch) ? PCState.PCLEAN : PCState.PNONTRANS;
            sm.setLoading(true);
            try {
                if (!this._store.initialize(sm, state, fetch, edata)) {
                    StateManagerImpl stateManagerImpl = null;
                    return stateManagerImpl;
                }
            }
            finally {
                sm.setLoading(false);
            }
        }
        return sm;
    }

    public Object[] findAll(Collection oids, boolean validate, FindCallbacks call) {
        int flags = 28;
        if (!validate) {
            flags |= 2;
        }
        return this.findAll(oids, this._fc, null, null, flags, call);
    }

    public Object[] findAll(Collection oids, FetchConfiguration fetch, BitSet exclude, Object edata, int flags) {
        return this.findAll(oids, fetch, exclude, edata, flags, null);
    }

    protected Object[] findAll(Collection oids, FetchConfiguration fetch, BitSet exclude, Object edata, int flags, FindCallbacks call) {
        ++this.findAllDepth;
        if (oids == null) {
            throw new NullPointerException("oids == null");
        }
        if ((flags & 2) != 0 && oids.contains(null)) {
            throw new UserException(_loc.get("null-oids"));
        }
        if (this._loading == null) {
            this._loading = new HashMap<Object, StateManagerImpl>((int)((double)oids.size() * 1.33 + 1.0));
        }
        if (call == null) {
            call = this;
        }
        if (fetch == null) {
            fetch = this._fc;
        }
        this.beginOperation(true);
        try {
            PCState state;
            Collection<Object> failed;
            StateManagerImpl sm;
            this.assertNontransactionalRead();
            ArrayList<StateManagerImpl> load = null;
            boolean transState = this.useTransactionalState(fetch);
            int idx = 0;
            for (Object obj : oids) {
                Object oid = call.processArgument(obj);
                if (oid != null && !this._loading.containsKey(obj)) {
                    boolean initialized;
                    sm = this.getStateManagerImplById(oid, (flags & 0x10) != 0 || this.hasFlushed());
                    boolean bl = initialized = sm != null;
                    if (!initialized) {
                        sm = this.newStateManagerImpl(oid, (flags & 8) != 0);
                    }
                    this._loading.put(obj, sm);
                    if (this.requiresLoad(sm, initialized, fetch, edata, flags)) {
                        boolean bl2 = transState = transState || this.useTransactionalState(fetch);
                        if (initialized && !sm.isTransactional() && transState) {
                            sm.transactional();
                        }
                        if (load == null) {
                            load = new ArrayList<StateManagerImpl>(oids.size() - idx);
                        }
                        load.add(sm);
                    } else if (!initialized) {
                        sm.initialize(sm.getMetaData().getDescribedType(), PCState.HOLLOW);
                    }
                }
                ++idx;
            }
            if (load != null && (failed = this._store.loadAll(load, state = transState ? PCState.PCLEAN : PCState.PNONTRANS, 0, fetch, edata)) != null && !failed.isEmpty()) {
                if ((flags & 2) != 0) {
                    throw BrokerImpl.newObjectNotFoundException(failed);
                }
                Iterator<Object> itr = failed.iterator();
                while (itr.hasNext()) {
                    this._loading.put(itr.next(), null);
                }
            }
            Object[] results = new Object[oids.size()];
            boolean active = (this._flags & 2) != 0;
            int level = fetch.getReadLockLevel();
            idx = 0;
            for (Object oid : oids) {
                sm = this._loading.get(oid);
                if (sm != null && this.requiresLoad(sm, true, fetch, edata, flags)) {
                    try {
                        sm.load(fetch, 0, exclude, edata, false);
                        if (active) {
                            this._lm.lock(sm, level, fetch.getLockTimeout(), edata);
                            sm.readLocked(level, fetch.getWriteLockLevel());
                        }
                    }
                    catch (ObjectNotFoundException onfe) {
                        if ((flags & 4) != 0 || (flags & 2) != 0) {
                            throw onfe;
                        }
                        sm = null;
                    }
                }
                results[idx] = call.processReturn(oid, sm);
                ++idx;
            }
            Object[] objectArray = results;
            return objectArray;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            --this.findAllDepth;
            if (this.findAllDepth == 0) {
                this._loading = null;
            }
            this.endOperation();
        }
    }

    private boolean hasFlushed() {
        return (this._flags & 0x100) != 0;
    }

    private boolean requiresLoad(OpenJPAStateManager sm, boolean initialized, FetchConfiguration fetch, Object edata, int flags) {
        if (!fetch.requiresLoad()) {
            return false;
        }
        if ((flags & 2) == 0) {
            return true;
        }
        if (edata != null) {
            return true;
        }
        if (initialized && sm.getPCState() != PCState.HOLLOW) {
            return false;
        }
        if (!initialized && sm.getMetaData().getPCSubclasses().length > 0) {
            return true;
        }
        return !this._compat.getValidateFalseReturnsHollow();
    }

    private boolean useTransactionalState(FetchConfiguration fetch) {
        return (this._flags & 2) != 0 && (!this._optimistic || this._autoClear == 1 || fetch.getReadLockLevel() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findCached(Object oid, FindCallbacks call) {
        if (call == null) {
            call = this;
        }
        if ((oid = call.processArgument(oid)) == null) {
            return call.processReturn(oid, null);
        }
        this.beginOperation(true);
        try {
            StateManagerImpl sm = this.getStateManagerImplById(oid, true);
            Object object = call.processReturn(oid, sm);
            return object;
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Class<?> getObjectIdType(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        this.beginOperation(false);
        try {
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this._loader, false);
            if (meta == null || meta.getIdentityType() == 0) {
                Class<?> clazz = null;
                return clazz;
            }
            if (meta.getIdentityType() == 2) {
                Class<?> clazz = meta.getObjectIdType();
                return clazz;
            }
            Class<?> clazz = this._store.getDataStoreIdType(meta);
            return clazz;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Object newObjectId(Class<?> cls, Object val) {
        if (val == null) {
            return null;
        }
        this.beginOperation(false);
        try {
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this._loader, true);
            switch (meta.getIdentityType()) {
                case 1: {
                    if (val instanceof String && ((String)val).startsWith("openjpasm:")) {
                        StateManagerId stateManagerId = new StateManagerId((String)val);
                        return stateManagerId;
                    }
                    Object object = this._store.newDataStoreId(val, meta);
                    return object;
                }
                case 2: {
                    Object[] objectArray;
                    if (ImplHelper.isAssignable(meta.getObjectIdType(), val.getClass())) {
                        if (!meta.isOpenJPAIdentity() && meta.isObjectIdTypeShared()) {
                            ObjectId objectId = new ObjectId(cls, val);
                            return objectId;
                        }
                        Object object = val;
                        return object;
                    }
                    if (val instanceof String && !this._conf.getCompatibilityInstance().getStrictIdentityValues() && !Modifier.isAbstract(cls.getModifiers())) {
                        Object object = PCRegistry.newObjectId(cls, (String)val);
                        return object;
                    }
                    if (val instanceof Object[]) {
                        objectArray = (Object[])val;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = val;
                    }
                    Object[] arr = objectArray;
                    Object object = ApplicationIds.fromPKValues(arr, meta);
                    return object;
                }
            }
            try {
                throw new UserException(_loc.get("meta-unknownid", cls));
            }
            catch (IllegalArgumentException iae) {
                throw new UserException(_loc.get("bad-id-value", val, val.getClass().getName(), cls)).setCause(iae);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (ClassCastException cce) {
                throw new UserException(_loc.get("bad-id-value", val, val.getClass().getName(), cls)).setCause(cce);
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
        }
        finally {
            this.endOperation();
        }
    }

    private StateManagerImpl newStateManagerImpl(Object oid, boolean copy) {
        StateManagerImpl sm;
        if (this._loading != null && (sm = this._loading.get(oid)) != null && sm.getPersistenceCapable() == null) {
            return sm;
        }
        Class<?> pcType = this._store.getManagedType(oid);
        MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
        ClassMetaData meta = pcType != null ? repos.getMetaData(pcType, this._loader, true) : repos.getMetaData(oid, this._loader, true);
        if (copy && this._compat.getCopyObjectIds()) {
            if (meta.getIdentityType() == 2) {
                oid = ApplicationIds.copy(oid, meta);
            } else {
                if (meta.getIdentityType() == 0) {
                    throw new UserException(_loc.get("meta-unknownid", meta));
                }
                oid = this._store.copyDataStoreId(oid, meta);
            }
        }
        sm = this.newStateManagerImpl(oid, meta);
        sm.setObjectId(oid);
        return sm;
    }

    protected StateManagerImpl newStateManagerImpl(Object oid, ClassMetaData meta) {
        return new StateManagerImpl(oid, meta, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) != 0) {
                throw new InvalidStateException(_loc.get("active"));
            }
            this._factory.syncWithManagedTransaction(this, true);
            this.beginInternal();
        }
        finally {
            this.endOperation();
        }
    }

    private void beginInternal() {
        try {
            this.beginStoreManagerTransaction(this._optimistic);
            this._flags |= 2;
            if (!this._optimistic) {
                this._fc.setReadLockLevel(this._conf.getReadLockLevelConstant());
                this._fc.setWriteLockLevel(this._conf.getWriteLockLevelConstant());
                this._fc.setLockTimeout(this._conf.getLockTimeout());
            }
            this._lm.beginTransaction();
            if (this._transEventManager.hasBeginListeners()) {
                this.fireTransactionEvent(new TransactionEvent(this, 0, null, null, null, null));
            }
        }
        catch (OpenJPAException ke) {
            if ((this._flags & 2) != 0) {
                this.setRollbackOnlyInternal(ke);
            }
            throw ke.setFatal(true);
        }
        catch (RuntimeException re) {
            if ((this._flags & 2) != 0) {
                this.setRollbackOnlyInternal(re);
            }
            throw new StoreException(re).setFatal(true);
        }
        if (this._pending != null) {
            for (StateManagerImpl sm : this._pending) {
                sm.transactional();
                if (!sm.isDirty()) continue;
                this.setDirty(sm, true);
            }
            this._pending = null;
        }
    }

    @Override
    public void beginStore() {
        this.beginOperation(true);
        try {
            this.assertTransactionOperation();
            if ((this._flags & 4) == 0) {
                this.beginStoreManagerTransaction(false);
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new StoreException(re);
        }
        finally {
            this.endOperation();
        }
    }

    private void beginStoreManagerTransaction(boolean optimistic) {
        if (!optimistic) {
            this.retainConnection();
            this._store.begin();
            this._flags |= 4;
        } else {
            if (this._connRetainMode == 1) {
                this.retainConnection();
            }
            this._store.beginOptimistic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException endStoreManagerTransaction(boolean rollback) {
        RuntimeException err;
        boolean forcedRollback;
        block17: {
            forcedRollback = false;
            boolean releaseConn = false;
            err = null;
            try {
                if ((this._flags & 4) != 0) {
                    boolean bl = releaseConn = this._connRetainMode != 2;
                    if (rollback) {
                        this._store.rollback();
                    } else {
                        this._store.commit();
                    }
                } else {
                    releaseConn = this._connRetainMode == 1;
                    this._store.rollbackOptimistic();
                }
            }
            catch (RuntimeException re) {
                if (!rollback) {
                    forcedRollback = true;
                    try {
                        this._store.rollback();
                    }
                    catch (RuntimeException re2) {
                        // empty catch block
                    }
                }
                err = re;
            }
            finally {
                this._flags &= 0xFFFFFFFB;
            }
            if (releaseConn) {
                try {
                    this.releaseConnection();
                }
                catch (RuntimeException re) {
                    if (err != null) break block17;
                    err = re;
                }
            }
        }
        if (forcedRollback) {
            throw err;
        }
        return err;
    }

    @Override
    public void commit() {
        this.beginOperation(false);
        try {
            this.assertTransactionOperation();
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                throw new InvalidStateException(_loc.get("null-trans"));
            }
            trans.commit();
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), ke);
            }
            throw ke;
        }
        catch (Exception e) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), e);
            }
            throw new StoreException(e);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void rollback() {
        this.beginOperation(false);
        try {
            this.assertTransactionOperation();
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans != null) {
                trans.rollback();
            }
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), ke);
            }
            throw ke;
        }
        catch (Exception e) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), e);
            }
            throw new StoreException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncWithManagedTransaction() {
        this.assertOpen();
        this.lock();
        try {
            if ((this._flags & 2) != 0) {
                boolean bl = true;
                return bl;
            }
            if (!this._managed) {
                throw new InvalidStateException(_loc.get("trans-not-managed"));
            }
            if (this._factory.syncWithManagedTransaction(this, false)) {
                this.beginInternal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void commitAndResume() {
        this.endAndResume(true);
    }

    @Override
    public void rollbackAndResume() {
        this.endAndResume(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endAndResume(boolean commit) {
        this.beginOperation(false);
        try {
            if (commit) {
                this.commit();
            } else {
                this.rollback();
            }
            this.begin();
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public boolean getRollbackOnly() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                boolean bl = false;
                return bl;
            }
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = trans.getStatus() == 1;
            return bl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Throwable getRollbackCause() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                Throwable throwable = null;
                return throwable;
            }
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                Throwable throwable = null;
                return throwable;
            }
            if (trans.getStatus() == 1) {
                Throwable throwable = this._runtime.getRollbackCause();
                return throwable;
            }
            Throwable throwable = null;
            return throwable;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void setRollbackOnly() {
        this.setRollbackOnly(new UserException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly(Throwable cause) {
        this.beginOperation(true);
        try {
            this.assertTransactionOperation();
            this.setRollbackOnlyInternal(cause);
        }
        finally {
            this.endOperation();
        }
    }

    private void setRollbackOnlyInternal(Throwable cause) {
        try {
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                throw new InvalidStateException(_loc.get("null-trans"));
            }
            int tranStatus = trans.getStatus();
            if (tranStatus != 6 && tranStatus != 4 && tranStatus != 3) {
                this._runtime.setRollbackOnly(cause);
            } else if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("invalid-tran-status", new Integer(tranStatus), "setRollbackOnly"));
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public void setSavepoint(String name) {
        this.beginOperation(true);
        try {
            this.assertActiveTransaction();
            if (this._savepoints != null && this._savepoints.containsKey(name)) {
                throw new UserException(_loc.get("savepoint-exists", name));
            }
            if (this.hasFlushed() && !this._spm.supportsIncrementalFlush()) {
                throw new UnsupportedException(_loc.get("savepoint-flush-not-supported"));
            }
            OpenJPASavepoint save = this._spm.newSavepoint(name, this);
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                save.save(this.getTransactionalStates());
                this._savepoints = new LinkedMap();
            } else if (this._savepointCache == null) {
                save.save(Collections.EMPTY_SET);
            } else {
                save.save(this._savepointCache);
                this._savepointCache.clear();
            }
            this._savepoints.put(name, save);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint() {
        this.beginOperation(false);
        try {
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                throw new UserException(_loc.get("no-lastsavepoint"));
            }
            this.releaseSavepoint((String)this._savepoints.get(this._savepoints.size() - 1));
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void releaseSavepoint(String savepoint) {
        this.beginOperation(false);
        try {
            OpenJPASavepoint save;
            int index;
            this.assertActiveTransaction();
            int n = index = this._savepoints == null ? -1 : this._savepoints.indexOf(savepoint);
            if (index < 0) {
                throw new UserException(_loc.get("no-savepoint", savepoint));
            }
            while (this._savepoints.size() > index + 1) {
                save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
                save.release(false);
            }
            save = (OpenJPASavepoint)this._savepoints.remove(index);
            save.release(true);
            if (this._savepointCache != null) {
                this._savepointCache.clear();
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackToSavepoint() {
        this.beginOperation(false);
        try {
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                throw new UserException(_loc.get("no-lastsavepoint"));
            }
            this.rollbackToSavepoint((String)this._savepoints.get(this._savepoints.size() - 1));
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public void rollbackToSavepoint(String savepoint) {
        this.beginOperation(false);
        try {
            OpenJPASavepoint save;
            int index;
            this.assertActiveTransaction();
            int n = index = this._savepoints == null ? -1 : this._savepoints.indexOf(savepoint);
            if (index < 0) {
                throw new UserException(_loc.get("no-savepoint", savepoint));
            }
            while (this._savepoints.size() > index + 1) {
                save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
                save.release(false);
            }
            save = (OpenJPASavepoint)this._savepoints.remove(index);
            Collection saved = save.rollback(this._savepoints.values());
            if (this._savepointCache != null) {
                this._savepointCache.clear();
            }
            if (this.hasTransactionalObjects()) {
                TransactionalCache oldTransCache = this._transCache;
                TransactionalCache newTransCache = new TransactionalCache(this._orderDirty);
                this._transCache = null;
                for (SavepointFieldManager fm : saved) {
                    StateManagerImpl sm = fm.getStateManager();
                    sm.rollbackToSavepoint(fm);
                    oldTransCache.remove(sm);
                    if (sm.isDirty()) {
                        newTransCache.addDirty(sm);
                        continue;
                    }
                    newTransCache.addClean(sm);
                }
                for (StateManagerImpl sm : oldTransCache) {
                    sm.rollback();
                    this.removeFromTransaction(sm);
                }
                this._transCache = newTransCache;
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0 || (this._flags & 0x80) != 0) {
                return;
            }
            if (!this._conf.supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                throw new UnsupportedException(_loc.get("incremental-flush-not-supported"));
            }
            if (this._savepoints != null && !this._savepoints.isEmpty() && !this._spm.supportsIncrementalFlush()) {
                throw new UnsupportedException(_loc.get("savepoint-flush-not-supported"));
            }
            try {
                this.flushSafe(0);
                this._flags |= 0x100;
            }
            catch (OpenJPAException ke) {
                this.setRollbackOnly(ke);
                throw ke.setFatal(true);
            }
            catch (RuntimeException re) {
                this.setRollbackOnly(re);
                throw new StoreException(re).setFatal(true);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preFlush() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) != 0) {
                this.flushSafe(3);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateChanges() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                return;
            }
            if ((this._flags & 4) != 0) {
                this.flush();
                return;
            }
            if (!this._conf.supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                throw new UnsupportedException(_loc.get("incremental-flush-not-supported"));
            }
            try {
                this.flushSafe(2);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new StoreException(re);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        this.beginOperation(true);
        try {
            boolean bl = (this._flags & 2) != 0;
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStoreActive() {
        this.beginOperation(true);
        try {
            boolean bl = (this._flags & 4) != 0;
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    boolean isTransactionEnding() {
        return (this._flags & 0x1000) != 0;
    }

    @Override
    public boolean beginOperation(boolean syncTrans) {
        this.lock();
        try {
            this.assertOpen();
            if (syncTrans && this._operationCount == 0 && this._syncManaged && (this._flags & 2) == 0) {
                this.syncWithManagedTransaction();
            }
            return this._operationCount++ == 1;
        }
        catch (OpenJPAException ke) {
            this.unlock();
            throw ke;
        }
        catch (RuntimeException re) {
            this.unlock();
            throw new GeneralException(re);
        }
    }

    @Override
    public boolean endOperation() {
        try {
            if (this._operationCount == 1 && (this._autoDetach & 8) != 0 && (this._flags & 2) == 0) {
                this.detachAllInternal(null);
            }
            if (this._operationCount < 1) {
                throw new InternalException(_loc.get("multi-threaded-access"));
            }
            boolean bl = this._operationCount == 1;
            return bl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            --this._operationCount;
            if (this._operationCount == 0) {
                this.initializeOperatingSet();
            }
            this.unlock();
        }
    }

    public Synchronization getSynchronization() {
        return this._sync;
    }

    public void setSynchronization(Synchronization sync) {
        this.assertOpen();
        this._sync = sync;
    }

    @Override
    public void beforeCompletion() {
        this.beginOperation(false);
        try {
            if (this._sync != null) {
                this._sync.beforeCompletion();
            }
            this.flushSafe(1);
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), ke);
            }
            throw this.translateManagedCompletionException(ke);
        }
        catch (RuntimeException re) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("end-trans-error"), re);
            }
            throw this.translateManagedCompletionException(new StoreException(re));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void afterCompletion(int status) {
        block12: {
            this.beginOperation(false);
            try {
                this.assertActiveTransaction();
                this._flags |= 0x1000;
                this.endTransaction(status);
                if (this._sync != null) {
                    this._sync.afterCompletion(status);
                }
                if ((this._autoDetach & 4) != 0) {
                    this.detachAllInternal(null);
                } else if (status == 4 && (this._autoDetach & 0x10) != 0) {
                    this.detachAllInternal(null);
                }
                if ((this._flags & 8) != 0 && this._compat.getCloseOnManagedCommit()) {
                    this.free();
                }
                this._flags &= 0xFFFFFFFD;
                this._flags &= 0xFFFFFEFF;
                this._flags &= 0xFFFFEFFF;
                if (this._transEventManager == null) break block12;
            }
            catch (OpenJPAException ke) {
                try {
                    if (!this._log.isTraceEnabled()) throw this.translateManagedCompletionException(ke);
                    this._log.trace(_loc.get("end-trans-error"), ke);
                    throw this.translateManagedCompletionException(ke);
                    catch (RuntimeException re) {
                        if (!this._log.isTraceEnabled()) throw this.translateManagedCompletionException(new StoreException(re));
                        this._log.trace(_loc.get("end-trans-error"), re);
                        throw this.translateManagedCompletionException(new StoreException(re));
                    }
                }
                catch (Throwable throwable) {
                    this._flags &= 0xFFFFFFFD;
                    this._flags &= 0xFFFFFEFF;
                    this._flags &= 0xFFFFEFFF;
                    if (this._transEventManager != null && this._transEventManager.hasEndListeners()) {
                        this.fireTransactionEvent(new TransactionEvent(this, status == 3 ? 7 : 8, null, null, null, null));
                    }
                    this.endOperation();
                    throw throwable;
                }
            }
            if (this._transEventManager.hasEndListeners()) {
                this.fireTransactionEvent(new TransactionEvent(this, status == 3 ? 7 : 8, null, null, null, null));
            }
        }
        this.endOperation();
    }

    private RuntimeException translateManagedCompletionException(RuntimeException re) {
        return !this._managed || this._extrans == null ? re : this._extrans.translate(re);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSafe(int reason) {
        if ((this._flags & 0x40) != 0) {
            throw new InvalidStateException(_loc.get("reentrant-flush"));
        }
        this._flags |= 0x40;
        try {
            this.flush(reason);
        }
        finally {
            this._flags &= 0xFFFFFFBF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(int reason) {
        List<Exception> exceps;
        ManagedObjectCollection mobjs;
        boolean flush;
        block31: {
            boolean listeners;
            Collection<OpenJPAStateManager> transactional = this.getTransactionalStates();
            flush = (this._flags & 0x200) != 0;
            boolean bl = listeners = !(!this._transEventManager.hasFlushListeners() && !this._transEventManager.hasEndListeners() || (this._flags & 0x400) != 0 && this._transEventManager.getListeners().size() <= 1);
            if (!(flush || reason == 1 && listeners)) {
                return;
            }
            mobjs = null;
            this._flags |= 0x10;
            try {
                Iterator<StateManagerImpl> itr;
                if (flush) {
                    itr = transactional.iterator();
                    while (itr.hasNext()) {
                        itr.next().beforeFlush(reason, this._call);
                    }
                    this.flushAdditions(transactional, reason);
                }
                this._flags |= 0x20;
                if (flush && this._derefCache != null && !this._derefCache.isEmpty()) {
                    itr = this._derefCache.iterator();
                    while (itr.hasNext()) {
                        this.deleteDeref(itr.next());
                    }
                    this.flushAdditions(transactional, reason);
                }
                if (reason != 3) {
                    if ((this._flags & 4) == 0) {
                        this.beginStoreManagerTransaction(false);
                    }
                    if ((this._transEventManager.hasFlushListeners() || this._transEventManager.hasEndListeners()) && (flush || reason == 1)) {
                        mobjs = new ManagedObjectCollection(transactional);
                        if (reason == 1 && this._transEventManager.hasEndListeners()) {
                            this.fireTransactionEvent(new TransactionEvent(this, 3, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
                            this.flushAdditions(transactional, reason);
                            boolean bl2 = flush = (this._flags & 0x200) != 0;
                        }
                        if (flush && this._transEventManager.hasFlushListeners()) {
                            this.fireTransactionEvent(new TransactionEvent(this, 1, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
                            this.flushAdditions(transactional, reason);
                        }
                    }
                }
            }
            finally {
                this._flags &= 0xFFFFFFEF;
                this._flags &= 0xFFFFFFDF;
                this._transAdditions = null;
                this._derefAdditions = null;
                if (this._derefCache != null) {
                    this._derefCache = null;
                }
            }
            exceps = null;
            try {
                if (flush && reason != 3) {
                    this._flags |= 0x80;
                    exceps = this.add(exceps, this.newFlushException(this._store.flush(transactional)));
                }
                Object var9_8 = null;
                this._flags &= 0xFFFFFF7F;
                if (reason == 2) {
                    exceps = this.add(exceps, this.endStoreManagerTransaction(true));
                } else if (reason != 3) {
                    this._flags &= 0xFFFFFDFF;
                }
                if (!flush) break block31;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this._flags &= 0xFFFFFF7F;
                if (reason == 2) {
                    exceps = this.add(exceps, this.endStoreManagerTransaction(true));
                } else if (reason != 3) {
                    this._flags &= 0xFFFFFDFF;
                }
                if (flush) {
                    for (StateManagerImpl stateManagerImpl : transactional) {
                        try {
                            if (stateManagerImpl.getPCState() == PCState.TRANSIENT) continue;
                            stateManagerImpl.afterFlush(reason);
                            if (reason != 0) continue;
                            stateManagerImpl.proxyFields(true, false);
                            this._transCache.flushed(stateManagerImpl);
                        }
                        catch (Exception e) {
                            exceps = this.add(exceps, e);
                        }
                    }
                }
                throw throwable;
            }
            for (StateManagerImpl stateManagerImpl : transactional) {
                try {
                    if (stateManagerImpl.getPCState() == PCState.TRANSIENT) continue;
                    stateManagerImpl.afterFlush(reason);
                    if (reason != 0) continue;
                    stateManagerImpl.proxyFields(true, false);
                    this._transCache.flushed(stateManagerImpl);
                }
                catch (Exception e) {
                    exceps = this.add(exceps, e);
                }
            }
        }
        this.throwNestedExceptions(exceps, true);
        if (flush && reason != 2 && reason != 3 && this._transEventManager.hasFlushListeners()) {
            this.fireTransactionEvent(new TransactionEvent(this, 2, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
        }
    }

    private void flushAdditions(Collection transactional, int reason) {
        boolean loop;
        while (loop = this.flushTransAdditions(transactional, reason) | this.deleteDerefAdditions(this._derefCache)) {
        }
    }

    private boolean flushTransAdditions(Collection transactional, int reason) {
        if (this._transAdditions == null || this._transAdditions.isEmpty()) {
            return false;
        }
        transactional.addAll(this._transAdditions);
        StateManagerImpl[] states = this._transAdditions.toArray(new StateManagerImpl[this._transAdditions.size()]);
        this._transAdditions = null;
        for (int i = 0; i < states.length; ++i) {
            states[i].beforeFlush(reason, this._call);
        }
        return true;
    }

    private boolean deleteDerefAdditions(Collection derefs) {
        if (this._derefAdditions == null || this._derefAdditions.isEmpty()) {
            return false;
        }
        derefs.addAll(this._derefAdditions);
        StateManagerImpl[] states = this._derefAdditions.toArray(new StateManagerImpl[this._derefAdditions.size()]);
        this._derefAdditions = null;
        for (int i = 0; i < states.length; ++i) {
            this.deleteDeref(states[i]);
        }
        return true;
    }

    private void deleteDeref(StateManagerImpl sm) {
        int action = this.processArgument(1, sm.getManagedInstance(), sm, null);
        if ((action & 4) != 0) {
            sm.delete();
        }
        if ((action & 2) != 0) {
            sm.cascadeDelete(this._call);
        }
    }

    private int processArgument(int op, Object obj, OpenJPAStateManager sm, OpCallbacks call) {
        if (call != null) {
            return call.processArgument(op, obj, sm);
        }
        if (this._call != null) {
            return this._call.processArgument(op, obj, sm);
        }
        return 6;
    }

    private OpenJPAException newFlushException(Collection<Exception> exceps) {
        if (exceps == null || exceps.isEmpty()) {
            return null;
        }
        Throwable[] t = exceps.toArray(new Throwable[exceps.size()]);
        ArrayList<Object> failed = new ArrayList<Object>(t.length);
        boolean opt = true;
        for (int i = 0; opt && i < t.length; ++i) {
            Object f;
            opt = t[i] instanceof OptimisticException;
            if (!opt || (f = ((OptimisticException)t[i]).getFailedObject()) == null) continue;
            failed.add(f);
        }
        if (opt && !failed.isEmpty()) {
            if (this._suppressBatchOLELogging) {
                return new OptimisticException(_loc.get("broker-suppressing-exceptions", t.length));
            }
            return new OptimisticException(failed, t);
        }
        if (opt) {
            return new OptimisticException(t);
        }
        return new StoreException(_loc.get("rolled-back")).setNestedThrowables(t).setFatal(true);
    }

    protected void endTransaction(int status) {
        boolean rollback = status != 3;
        List<Exception> exceps = null;
        try {
            exceps = this.add(exceps, this.endStoreManagerTransaction(rollback));
        }
        catch (RuntimeException re) {
            rollback = true;
            exceps = this.add(exceps, re);
        }
        this._fc.setReadLockLevel(0);
        this._fc.setWriteLockLevel(0);
        this._fc.setLockTimeout(-1);
        Set transStates = this.hasTransactionalObjects() ? this._transCache : Collections.EMPTY_SET;
        ManagedObjectCollection mobjs = null;
        if (this._transEventManager.hasEndListeners()) {
            mobjs = new ManagedObjectCollection(transStates);
            int eventType = rollback ? 5 : 4;
            this.fireTransactionEvent(new TransactionEvent(this, eventType, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
        }
        this._transCache = null;
        if (this._persistedClss != null) {
            this._persistedClss = null;
        }
        if (this._updatedClss != null) {
            this._updatedClss = null;
        }
        if (this._deletedClss != null) {
            this._deletedClss = null;
        }
        this._cache.clearNew();
        if (this._derefCache != null && !this._derefCache.isEmpty()) {
            Iterator<StateManagerImpl> itr = this._derefCache.iterator();
            while (itr.hasNext()) {
                itr.next().setDereferencedDependent(false, false);
            }
            this._derefCache = null;
        }
        for (StateManagerImpl sm : transStates) {
            try {
                if (rollback) {
                    sm.setDereferencedDependent(false, false);
                    sm.rollback();
                    continue;
                }
                if (sm.getPCState() == PCState.PNEWDELETED || sm.getPCState() == PCState.PDELETED) {
                    this.fireLifecycleEvent(sm.getPersistenceCapable(), null, sm.getMetaData(), 19);
                }
                sm.commit();
            }
            catch (RuntimeException re) {
                exceps = this.add(exceps, re);
            }
        }
        this._lm.endTransaction();
        while (this._savepoints != null && this._savepoints.size() > 0) {
            OpenJPASavepoint save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
            save.release(false);
        }
        this._savepoints = null;
        this._savepointCache = null;
        if (this._transEventManager.hasEndListeners()) {
            this.fireTransactionEvent(new TransactionEvent(this, 6, mobjs, null, null, null));
        }
        if (transStates != Collections.EMPTY_SET) {
            this._transCache = (TransactionalCache)transStates;
            this._transCache.clear();
        }
        this.throwNestedExceptions(exceps, true);
    }

    @Override
    public void persist(Object obj, OpCallbacks call) {
        this.persist(obj, null, true, call);
    }

    @Override
    public OpenJPAStateManager persist(Object obj, Object id, OpCallbacks call) {
        return this.persist(obj, id, true, call);
    }

    @Override
    public void persistAll(Collection objs, OpCallbacks call) {
        this.persistAll(objs, true, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAll(Collection objs, boolean explicit, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        List<Exception> exceps = null;
        try {
            this.assertWriteOperation();
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.persist(itr.next(), explicit, call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            Object var8_7 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endOperation();
            throw throwable;
        }
        this.throwNestedExceptions(exceps, false);
    }

    private List<Exception> add(List<Exception> l, Exception o) {
        if (o == null) {
            return l;
        }
        if (l == null) {
            l = new LinkedList<Exception>();
        }
        l.add(o);
        return l;
    }

    private void throwNestedExceptions(List<Exception> exceps, boolean datastore) {
        if (exceps == null || exceps.isEmpty()) {
            return;
        }
        if (datastore && exceps.size() == 1) {
            throw (RuntimeException)exceps.get(0);
        }
        boolean fatal = false;
        Throwable[] t = exceps.toArray(new Throwable[exceps.size()]);
        for (int i = 0; i < t.length; ++i) {
            if (!(t[i] instanceof OpenJPAException) || !((OpenJPAException)t[i]).isFatal()) continue;
            fatal = true;
        }
        OpenJPAException err = datastore ? new StoreException(_loc.get("nested-exceps")) : new UserException(_loc.get("nested-exceps"));
        throw err.setNestedThrowables(t).setFatal(fatal);
    }

    public void persist(Object obj, boolean explicit, OpCallbacks call) {
        this.persist(obj, null, explicit, call);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenJPAStateManager persist(Object obj, Object id, boolean explicit, OpCallbacks call) {
        StateManagerImpl stateManagerImpl;
        block33: {
            StateManagerImpl stateManagerImpl2;
            block31: {
                StateManagerImpl stateManagerImpl3;
                block30: {
                    StateManagerImpl stateManagerImpl4;
                    block29: {
                        if (obj == null) {
                            return null;
                        }
                        this.beginOperation(true);
                        try {
                            StateManagerImpl stateManagerImpl5;
                            block28: {
                                try {
                                    PersistenceCapable pc;
                                    this.assertWriteOperation();
                                    StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                                    if (!this._operating.add(obj)) {
                                        stateManagerImpl5 = sm;
                                        Object var11_10 = null;
                                        break block28;
                                    }
                                    int action = this.processArgument(0, obj, sm, call);
                                    if (action == 0) {
                                        stateManagerImpl4 = sm;
                                        break block29;
                                    }
                                    if ((action & 4) == 0) {
                                        if (sm != null) {
                                            sm.cascadePersist(call);
                                        } else {
                                            this.cascadeTransient(0, obj, call, "persist");
                                        }
                                        stateManagerImpl3 = sm;
                                        break block30;
                                    }
                                    if (sm != null) {
                                        if (sm.isDetached()) {
                                            throw new ObjectExistsException(_loc.get("persist-detached", Exceptions.toString(obj))).setFailedObject(obj);
                                        }
                                        if (!sm.isEmbedded()) {
                                            sm.persist();
                                            this._cache.persist(sm);
                                            if ((action & 2) != 0) {
                                                sm.cascadePersist(call);
                                            }
                                            stateManagerImpl2 = sm;
                                            break block31;
                                        }
                                        sm.getOwner().dirty(sm.getOwnerIndex());
                                        this._cache.persist(sm);
                                        pc = sm.getPersistenceCapable();
                                    } else {
                                        pc = this.assertPersistenceCapable(obj);
                                        if (pc.pcIsDetached() == Boolean.TRUE) {
                                            throw new ObjectExistsException(_loc.get("persist-detached", Exceptions.toString(obj))).setFailedObject(obj);
                                        }
                                    }
                                    ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
                                    this.fireLifecycleEvent(obj, null, meta, 0);
                                    if (id == null) {
                                        int idType = meta.getIdentityType();
                                        if (idType == 2) {
                                            id = ApplicationIds.create(pc, meta);
                                        } else {
                                            if (idType == 0) {
                                                throw new UserException(_loc.get("meta-unknownid", meta));
                                            }
                                            id = StateManagerId.newInstance(this);
                                        }
                                    }
                                    this.checkForDuplicateId(id, obj);
                                    if (sm != null) {
                                        pc.pcReplaceStateManager(null);
                                    }
                                    sm = new StateManagerImpl(id, meta, this);
                                    if ((this._flags & 2) != 0) {
                                        if (explicit) {
                                            sm.initialize(pc, PCState.PNEW);
                                        } else {
                                            sm.initialize(pc, PCState.PNEWPROVISIONAL);
                                        }
                                    } else {
                                        sm.initialize(pc, PCState.PNONTRANSNEW);
                                    }
                                    if ((action & 2) != 0) {
                                        sm.cascadePersist(call);
                                    }
                                    stateManagerImpl = sm;
                                    break block33;
                                }
                                catch (OpenJPAException ke) {
                                    throw ke;
                                }
                                catch (RuntimeException re) {
                                    throw new GeneralException(re);
                                }
                            }
                            this.endOperation();
                            return stateManagerImpl5;
                        }
                        catch (Throwable throwable) {
                            Object var11_15 = null;
                            this.endOperation();
                            throw throwable;
                        }
                    }
                    Object var11_11 = null;
                    this.endOperation();
                    return stateManagerImpl4;
                }
                Object var11_12 = null;
                this.endOperation();
                return stateManagerImpl3;
            }
            Object var11_13 = null;
            this.endOperation();
            return stateManagerImpl2;
        }
        Object var11_14 = null;
        this.endOperation();
        return stateManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeTransient(int op, Object obj, OpCallbacks call, String errOp) {
        PersistenceCapable pc = this.assertPersistenceCapable(obj);
        if (pc.pcGetStateManager() != null) {
            throw this.newDetachedException(obj, errOp);
        }
        ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
        StateManagerImpl sm = new StateManagerImpl(StateManagerId.newInstance(this), meta, this);
        sm.initialize(pc, PCState.TLOADED);
        try {
            switch (op) {
                case 0: {
                    sm.cascadePersist(call);
                    break;
                }
                case 1: {
                    sm.cascadeDelete(call);
                    break;
                }
                case 2: {
                    sm.gatherCascadeRefresh(call);
                    break;
                }
                default: {
                    throw new InternalException(String.valueOf(op));
                }
            }
            Object var9_8 = null;
            sm.release(true);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            sm.release(true);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll(Collection objs, OpCallbacks call) {
        this.beginOperation(true);
        try {
            this.assertWriteOperation();
            List<Exception> exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    Object obj = itr.next();
                    if (obj == null) continue;
                    this.delete(obj, this.getStateManagerImpl(obj, true), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
            Object var8_7 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endOperation();
            throw throwable;
        }
    }

    @Override
    public void delete(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            try {
                this.assertWriteOperation();
                this.delete(obj, this.getStateManagerImpl(obj, true), call);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var5_3 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.endOperation();
            throw throwable;
        }
    }

    void delete(Object obj, StateManagerImpl sm, OpCallbacks call) {
        if (!this._operating.add(obj)) {
            return;
        }
        int action = this.processArgument(1, obj, sm, call);
        if (action == 0) {
            return;
        }
        if ((action & 4) == 0) {
            if (sm != null) {
                if (!sm.isEmbedded() || !sm.getDereferencedEmbedDependent()) {
                    sm.cascadeDelete(call);
                }
            } else {
                this.cascadeTransient(1, obj, call, "delete");
            }
            return;
        }
        if (sm != null) {
            if (sm.isDetached()) {
                throw this.newDetachedException(obj, "delete");
            }
            if (!((action & 2) == 0 || sm.isEmbedded() && sm.getDereferencedEmbedDependent())) {
                sm.cascadeDelete(call);
            }
            sm.delete();
        } else if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
            throw this.newDetachedException(obj, "delete");
        }
    }

    private OpenJPAException newDetachedException(Object obj, String operation) {
        throw new UserException(_loc.get("bad-detached-op", operation, Exceptions.toString(obj))).setFailedObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAll(Collection objs, OpCallbacks call) {
        this.beginOperation(false);
        try {
            List<Exception> exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.release(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
            Object var7_6 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release(Object obj, OpCallbacks call) {
        block10: {
            if (obj == null) {
                return;
            }
            this.beginOperation(false);
            try {
                block9: {
                    try {
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        int action = this.processArgument(4, obj, sm, call);
                        if (sm == null) {
                            Object var7_7 = null;
                            break block9;
                        }
                        if ((action & 4) == 0 || !sm.isPersistent()) break block10;
                        boolean pending = sm.isPendingTransactional();
                        sm.release(true);
                        if (pending) {
                            this.removeFromPendingTransaction(sm);
                        }
                        break block10;
                    }
                    catch (OpenJPAException ke) {
                        throw ke;
                    }
                    catch (RuntimeException re) {
                        throw new GeneralException(re);
                    }
                }
                this.endOperation();
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.endOperation();
                throw throwable;
            }
        }
        Object var7_8 = null;
        this.endOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenJPAStateManager embed(Object obj, Object id, OpenJPAStateManager owner, ValueMetaData ownerMeta) {
        block18: {
            this.beginOperation(true);
            try {
                block17: {
                    try {
                        orig = this.getStateManagerImpl(obj, true);
                        if (orig != null) {
                            if (orig.getOwner() == owner && orig.getMetaData().getEmbeddingMetaData() == ownerMeta) {
                                var6_8 = orig;
                                var18_10 = null;
                                break block17;
                            }
                            orig.load(this._fc, 1, null, null, false);
                        }
                        if ((meta = ownerMeta.getEmbeddedMetaData()) == null) {
                            throw new InternalException(BrokerImpl._loc.get("bad-embed", ownerMeta));
                        }
                        if (id == null) {
                            id = StateManagerId.newInstance(this);
                        }
                        sm = new StateManagerImpl(id, meta, this);
                        sm.setOwner((StateManagerImpl)owner, ownerMeta);
                        type = meta.getDescribedType();
                        if (obj != null) {
                            if (orig == null) {
                                copySM = sm;
                                pc = this.assertPersistenceCapable(obj);
                                pc.pcReplaceStateManager(sm);
                            } else {
                                copySM = orig;
                                pc = orig.getPersistenceCapable();
                            }
                            try {
                                copy = PCRegistry.newInstance(type, copySM, false);
                                fields = new int[meta.getFields().length];
                                for (i = 0; i < fields.length; ++i) {
                                    fields[i] = i;
                                }
                                copy.pcCopyFields(pc, fields);
                                state = PCState.ECOPY;
                                copy.pcReplaceStateManager(null);
                                var16_21 = null;
                                if (orig != null) ** GOTO lbl51
                                pc.pcReplaceStateManager(null);
                            }
                            catch (Throwable var15_23) {
                                var16_22 = null;
                                if (orig != null) throw var15_23;
                                pc.pcReplaceStateManager(null);
                                throw var15_23;
                            }
                        } else {
                            copy = PCRegistry.newInstance(type, sm, false);
                            state = (this._flags & 2) != 0 && this._optimistic == false ? PCState.ECLEAN : PCState.ENONTRANS;
                        }
lbl51:
                        // 3 sources

                        sm.initialize(copy, state);
                        var11_15 = sm;
                        break block18;
                    }
                    catch (OpenJPAException ke) {
                        throw ke;
                    }
                    catch (RuntimeException re) {
                        throw new GeneralException(re);
                    }
                }
                this.endOperation();
                return var6_8;
            }
            catch (Throwable var17_24) {
                var18_12 = null;
                this.endOperation();
                throw var17_24;
            }
        }
        var18_11 = null;
        this.endOperation();
        return var11_15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenJPAStateManager copy(OpenJPAStateManager copy, PCState state) {
        StateManagerImpl stateManagerImpl;
        this.beginOperation(true);
        try {
            this.assertOpen();
            Object oid = copy.fetchObjectId();
            Class<?> type = copy.getManagedInstance().getClass();
            if (oid == null) {
                throw new InternalException();
            }
            StateManagerImpl sm = null;
            if (!copy.isEmbedded()) {
                sm = this.getStateManagerImplById(oid, true);
            }
            if (sm == null) {
                MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
                ClassMetaData meta = repos.getMetaData(type, this._loader, true);
                sm = new StateManagerImpl(oid, meta, this);
                sm.setObjectId(oid);
                sm.initialize(sm.getMetaData().getDescribedType(), state);
            }
            stateManagerImpl = sm;
            Object var9_8 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endOperation();
            throw throwable;
        }
        return stateManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refreshAll(Collection objs, OpCallbacks call) {
        if (objs == null) return;
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                this.gatherCascadeRefresh(itr.next(), call);
            }
            if (this._operating.isEmpty()) {
                Object var5_4 = null;
                this.endOperation();
                return;
            }
            if (this._operating.size() == 1) {
                this.refreshInternal(this._operating.iterator().next(), call);
            } else {
                this.refreshInternal(this._operating, call);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.endOperation();
            throw throwable;
        }
        Object var5_5 = null;
        this.endOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refresh(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            this.gatherCascadeRefresh(obj, call);
            if (this._operating.isEmpty()) {
                Object var4_3 = null;
                this.endOperation();
                return;
            }
            if (this._operating.size() == 1) {
                this.refreshInternal(this._operating.iterator().next(), call);
            } else {
                this.refreshInternal(this._operating, call);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endOperation();
            throw throwable;
        }
        Object var4_4 = null;
        this.endOperation();
    }

    void gatherCascadeRefresh(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        if (!this._operating.add(obj)) {
            return;
        }
        StateManagerImpl sm = this.getStateManagerImpl(obj, false);
        int action = this.processArgument(2, obj, sm, call);
        if ((action & 2) == 0) {
            return;
        }
        if (sm != null) {
            sm.gatherCascadeRefresh(call);
        } else {
            this.cascadeTransient(2, obj, call, "refresh");
        }
    }

    protected void refreshInternal(Collection objs, OpCallbacks call) {
        if (objs == null || objs.isEmpty()) {
            return;
        }
        List<Exception> exceps = null;
        try {
            StateManagerImpl sm2;
            ArrayList<StateManagerImpl> load = null;
            for (Object obj : objs) {
                if (obj == null) continue;
                try {
                    sm2 = this.getStateManagerImpl(obj, true);
                    if ((this.processArgument(2, obj, sm2, call) & 4) == 0) continue;
                    if (sm2 != null) {
                        if (sm2.isDetached()) {
                            throw this.newDetachedException(obj, "refresh");
                        }
                        if (sm2.beforeRefresh(true)) {
                            if (load == null) {
                                load = new ArrayList<StateManagerImpl>(objs.size());
                            }
                            load.add(sm2);
                        }
                        int level = this._fc.getReadLockLevel();
                        int timeout = this._fc.getLockTimeout();
                        this._lm.lock(sm2, level, timeout, null, false);
                        sm2.readLocked(level, level);
                        continue;
                    }
                    if (this.assertPersistenceCapable(obj).pcIsDetached() != Boolean.TRUE) continue;
                    throw this.newDetachedException(obj, "refresh");
                }
                catch (OpenJPAException ke) {
                    exceps = this.add(exceps, ke);
                }
            }
            if (load != null) {
                Collection<Object> failed = this._store.loadAll(load, null, 3, this._fc, null);
                if (failed != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
                for (StateManagerImpl sm2 : load) {
                    if (failed != null && failed.contains(sm2.getId())) continue;
                    try {
                        sm2.afterRefresh();
                        sm2.load(this._fc, 0, null, null, false);
                    }
                    catch (OpenJPAException ke) {
                        exceps = this.add(exceps, ke);
                    }
                }
            }
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    sm2 = this.getStateManagerImpl(itr.next(), true);
                    if (sm2 == null || sm2.isDetached()) continue;
                    this.fireLifecycleEvent(sm2.getManagedInstance(), null, sm2.getMetaData(), 17);
                }
                catch (OpenJPAException ke) {
                    exceps = this.add(exceps, ke);
                }
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        this.throwNestedExceptions(exceps, false);
    }

    protected void refreshInternal(Object obj, OpCallbacks call) {
        try {
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(2, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm != null) {
                if (sm.isDetached()) {
                    throw this.newDetachedException(obj, "refresh");
                }
                if (sm.beforeRefresh(false)) {
                    sm.load(this._fc, 0, null, null, false);
                    sm.afterRefresh();
                }
                int level = this._fc.getReadLockLevel();
                int timeout = this._fc.getLockTimeout();
                this._lm.lock(sm, level, timeout, null, false);
                sm.readLocked(level, level);
                this.fireLifecycleEvent(sm.getManagedInstance(), null, sm.getMetaData(), 17);
            } else if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
                throw this.newDetachedException(obj, "refresh");
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    public void retrieveAll(Collection objs, boolean dfgOnly, OpCallbacks call) {
        if (objs == null || objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.retrieve(objs.iterator().next(), dfgOnly, call);
            return;
        }
        List<Exception> exceps = null;
        this.beginOperation(true);
        try {
            try {
                int mode;
                this.assertOpen();
                this.assertNontransactionalRead();
                ArrayList<StateManagerImpl> load = null;
                ArrayList<StateManagerImpl> sms = new ArrayList<StateManagerImpl>(objs.size());
                for (Object obj : objs) {
                    if (obj == null) continue;
                    try {
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        if ((this.processArgument(3, obj, sm, call) & 4) == 0) continue;
                        if (sm != null) {
                            if (sm.isDetached()) {
                                throw this.newDetachedException(obj, "retrieve");
                            }
                            if (!sm.isPersistent()) continue;
                            sms.add(sm);
                            if (sm.getPCState() != PCState.HOLLOW) continue;
                            if (load == null) {
                                load = new ArrayList<StateManagerImpl>();
                            }
                            load.add(sm);
                            continue;
                        }
                        if (this.assertPersistenceCapable(obj).pcIsDetached() != Boolean.TRUE) continue;
                        throw this.newDetachedException(obj, "retrieve");
                    }
                    catch (UserException ue) {
                        exceps = this.add(exceps, ue);
                    }
                }
                Collection<Object> failed = null;
                if (load != null && (failed = this._store.loadAll(load, null, mode = dfgOnly ? 1 : 2, this._fc, null)) != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
                for (StateManagerImpl sm : sms) {
                    if (failed != null && failed.contains(sm.getId())) continue;
                    int mode2 = dfgOnly ? 0 : 1;
                    try {
                        sm.beforeRead(-1);
                        sm.load(this._fc, mode2, null, null, false);
                    }
                    catch (OpenJPAException ke) {
                        exceps = this.add(exceps, ke);
                    }
                }
                Object var14_17 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.endOperation();
            throw throwable;
        }
        this.throwNestedExceptions(exceps, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void retrieve(Object obj, boolean dfgOnly, OpCallbacks call) {
        block13: {
            if (obj == null) {
                return;
            }
            this.beginOperation(true);
            try {
                block12: {
                    try {
                        this.assertOpen();
                        this.assertNontransactionalRead();
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        if ((this.processArgument(3, obj, sm, call) & 4) == 0) {
                            Object var7_7 = null;
                            break block12;
                        }
                        if (sm != null) {
                            if (sm.isDetached()) {
                                throw this.newDetachedException(obj, "retrieve");
                            }
                            if (sm.isPersistent()) {
                                int mode = dfgOnly ? 0 : 1;
                                sm.beforeRead(-1);
                                sm.load(this._fc, mode, null, null, false);
                            }
                            break block13;
                        }
                        if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
                            throw this.newDetachedException(obj, "retrieve");
                        }
                        break block13;
                    }
                    catch (OpenJPAException ke) {
                        throw ke;
                    }
                    catch (RuntimeException re) {
                        throw new GeneralException(re);
                    }
                }
                this.endOperation();
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.endOperation();
                throw throwable;
            }
        }
        Object var7_8 = null;
        this.endOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll(OpCallbacks call) {
        this.beginOperation(false);
        try {
            Collection c = this.getManagedStates();
            for (StateManagerImpl sm : c) {
                if (!sm.isPersistent() || sm.isDirty()) continue;
                this.evict(sm.getManagedInstance(), call);
            }
            Object var6_5 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll(Collection objs, OpCallbacks call) {
        List<Exception> exceps = null;
        this.beginOperation(false);
        try {
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.evict(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            Object var7_6 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endOperation();
            throw throwable;
        }
        this.throwNestedExceptions(exceps, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll(Extent extent, OpCallbacks call) {
        if (extent == null) {
            return;
        }
        this.beginOperation(false);
        try {
            Collection c = this.getManagedStates();
            for (StateManagerImpl sm : c) {
                Class<?> cls;
                if (!sm.isPersistent() || sm.isDirty() || (cls = sm.getMetaData().getDescribedType()) != extent.getElementType() && (!extent.hasSubclasses() || !extent.getElementType().isAssignableFrom(cls))) continue;
                this.evict(sm.getManagedInstance(), call);
            }
            Object var8_7 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void evict(Object obj, OpCallbacks call) {
        block12: {
            block11: {
                if (obj == null) {
                    return;
                }
                this.beginOperation(false);
                try {
                    block10: {
                        try {
                            DataCache cache;
                            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                            if ((this.processArgument(5, obj, sm, call) & 4) == 0) {
                                Object var6_6 = null;
                                break block10;
                            }
                            if (sm == null) {
                                break block11;
                            }
                            sm.evict();
                            if (this._evictDataCache && sm.getObjectId() != null && (cache = this._conf.getDataCacheManagerInstance().selectCache(sm)) != null) {
                                cache.remove(sm.getObjectId());
                            }
                            break block12;
                        }
                        catch (OpenJPAException ke) {
                            throw ke;
                        }
                        catch (RuntimeException re) {
                            throw new GeneralException(re);
                        }
                    }
                    this.endOperation();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.endOperation();
                    throw throwable;
                }
            }
            Object var6_7 = null;
            this.endOperation();
            return;
        }
        Object var6_8 = null;
        this.endOperation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object detach(Object obj, OpCallbacks call) {
        if (obj == null) {
            return null;
        }
        if (call == null) {
            call = this._call;
        }
        this.beginOperation(true);
        try {
            Object object;
            try {
                object = new DetachManager(this, false, call).detach(obj);
                Object var5_6 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] detachAll(Collection objs, OpCallbacks call) {
        if (objs == null) {
            return null;
        }
        if (objs.isEmpty()) {
            return EMPTY_OBJECTS;
        }
        if (call == null) {
            call = this._call;
        }
        this.beginOperation(true);
        try {
            Object[] objectArray;
            try {
                objectArray = new DetachManager(this, false, call).detachAll(objs);
                Object var5_6 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.endOperation();
            throw throwable;
        }
    }

    @Override
    public void detachAll(OpCallbacks call) {
        this.detachAll(call, true);
    }

    @Override
    public void detachAll(OpCallbacks call, boolean flush) {
        this.beginOperation(true);
        try {
            try {
                if (flush && (this._flags & 0x200) != 0) {
                    this.flush();
                }
                this.detachAllInternal(call);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var5_3 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachAllInternal(OpCallbacks call) {
        Collection states = this.getManagedStates();
        Iterator itr = states.iterator();
        while (itr.hasNext()) {
            StateManagerImpl sm = (StateManagerImpl)itr.next();
            if (!sm.isPersistent()) {
                itr.remove();
                continue;
            }
            if (sm.getMetaData().isDetachable()) continue;
            sm.release(true);
            itr.remove();
        }
        if (states.isEmpty()) {
            return;
        }
        if (call == null) {
            call = this._call;
        }
        boolean origCascade = this._compat.getCascadeWithDetach();
        this._compat.setCascadeWithDetach(true);
        try {
            new DetachManager(this, true, call).detachAll(new ManagedObjectCollection(states));
            Object var6_6 = null;
            this._compat.setCascadeWithDetach(origCascade);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._compat.setCascadeWithDetach(origCascade);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object attach(Object obj, boolean copyNew, OpCallbacks call) {
        if (obj == null) {
            return null;
        }
        this.beginOperation(true);
        try {
            Object object;
            this.assertWriteOperation();
            try {
                object = new AttachManager(this, copyNew, call).attach(obj);
            }
            catch (OptimisticException oe) {
                this.setRollbackOnly(oe);
                throw oe.setFatal(true);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var6_8 = null;
            this.endOperation();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] attachAll(Collection objs, boolean copyNew, OpCallbacks call) {
        if (objs == null) {
            return null;
        }
        if (objs.isEmpty()) {
            return EMPTY_OBJECTS;
        }
        this.beginOperation(true);
        try {
            Object[] objectArray;
            this.assertWriteOperation();
            try {
                objectArray = new AttachManager(this, copyNew, call).attachAll(objs);
            }
            catch (OptimisticException oe) {
                this.setRollbackOnly(oe);
                throw oe.setFatal(true);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var6_8 = null;
            this.endOperation();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nontransactionalAll(Collection objs, OpCallbacks call) {
        this.beginOperation(true);
        try {
            List<Exception> exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.nontransactional(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
            Object var7_6 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void nontransactional(Object obj, OpCallbacks call) {
        block10: {
            if (obj == null) {
                return;
            }
            this.beginOperation(true);
            try {
                block9: {
                    try {
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        if ((this.processArgument(8, obj, sm, call) & 4) == 0) {
                            Object var5_6 = null;
                            break block9;
                        }
                        if (sm != null) {
                            sm.nontransactional();
                        }
                        break block10;
                    }
                    catch (OpenJPAException ke) {
                        throw ke;
                    }
                    catch (RuntimeException re) {
                        throw new GeneralException(re);
                    }
                }
                this.endOperation();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.endOperation();
                throw throwable;
            }
        }
        Object var5_7 = null;
        this.endOperation();
    }

    public void transactionalAll(Collection objs, boolean updateVersion, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.transactional(objs.iterator().next(), updateVersion, call);
            return;
        }
        this.beginOperation(true);
        try {
            try {
                ArrayList<StateManagerImpl> load = null;
                LinkedHashSet<StateManagerImpl> sms = new LinkedHashSet<StateManagerImpl>(objs.size());
                List<Exception> exceps = null;
                for (Object obj : objs) {
                    if (obj == null) continue;
                    try {
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        if ((this.processArgument(9, obj, sm, call) & 4) == 0) continue;
                        if (sm == null) {
                            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
                            sm = new StateManagerImpl(StateManagerId.newInstance(this), meta, this);
                            sm.initialize(this.assertPersistenceCapable(obj), PCState.TCLEAN);
                            continue;
                        }
                        if (!sm.isPersistent()) continue;
                        this.assertActiveTransaction();
                        sms.add(sm);
                        if (sm.getPCState() == PCState.HOLLOW) {
                            if (load == null) {
                                load = new ArrayList<StateManagerImpl>();
                            }
                            load.add(sm);
                        }
                        sm.setCheckVersion(true);
                        if (updateVersion) {
                            sm.setUpdateVersion(true);
                        }
                        this._flags |= 0x200;
                    }
                    catch (UserException ue) {
                        exceps = this.add(exceps, ue);
                    }
                }
                Collection<Object> failed = null;
                if (load != null && (failed = this._store.loadAll(load, null, 0, this._fc, null)) != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
                this.transactionalStatesAll(sms, failed, exceps);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var13_14 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transactional(Object obj, boolean updateVersion, OpCallbacks call) {
        block12: {
            if (obj == null) {
                return;
            }
            this.beginOperation(true);
            try {
                block11: {
                    try {
                        StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                        if ((this.processArgument(9, obj, sm, call) & 4) == 0) {
                            Object var8_7 = null;
                            break block11;
                        }
                        if (sm != null && sm.isPersistent()) {
                            this.assertActiveTransaction();
                            sm.transactional();
                            sm.load(this._fc, 0, null, null, false);
                            sm.setCheckVersion(true);
                            if (updateVersion) {
                                sm.setUpdateVersion(true);
                            }
                            this._flags |= 0x200;
                            break block12;
                        }
                        if (sm == null) {
                            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
                            StateManagerId id = StateManagerId.newInstance(this);
                            sm = new StateManagerImpl(id, meta, this);
                            sm.initialize(this.assertPersistenceCapable(obj), PCState.TCLEAN);
                        }
                        break block12;
                    }
                    catch (OpenJPAException ke) {
                        throw ke;
                    }
                    catch (RuntimeException re) {
                        throw new GeneralException(re);
                    }
                }
                this.endOperation();
                return;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.endOperation();
                throw throwable;
            }
        }
        Object var8_8 = null;
        this.endOperation();
    }

    private void transactionalStatesAll(Collection sms, Collection failed, List<Exception> exceps) {
        for (StateManagerImpl sm : sms) {
            if (failed != null && failed.contains(sm.getId())) continue;
            try {
                sm.transactional();
                sm.load(this._fc, 0, null, null, false);
            }
            catch (OpenJPAException ke) {
                exceps = this.add(exceps, ke);
            }
        }
        this.throwNestedExceptions(exceps, false);
    }

    @Override
    public Extent newExtent(Class type, boolean subclasses) {
        return this.newExtent(type, subclasses, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Extent newExtent(Class type, boolean subclasses, FetchConfiguration fetch) {
        this.beginOperation(true);
        try {
            ExtentImpl extentImpl;
            try {
                ExtentImpl extent = new ExtentImpl(this, type, subclasses, fetch);
                if (this._extents == null) {
                    this._extents = new ReferenceHashSet(2);
                }
                this._extents.add(extent);
                extentImpl = extent;
                Object var7_8 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
            return extentImpl;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.endOperation();
            throw throwable;
        }
    }

    public Iterator extentIterator(Class type, boolean subclasses, FetchConfiguration fetch, boolean ignoreChanges) {
        Extent extent = this.newExtent(type, subclasses, fetch);
        extent.setIgnoreChanges(ignoreChanges);
        return extent.iterator();
    }

    @Override
    public Query newQuery(String lang, Class cls, Object query) {
        Query q = this.newQuery(lang, query);
        q.setCandidateType(cls, true);
        return q;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Query newQuery(String lang, Object query) {
        if (query instanceof Extent) throw new UserException(_loc.get("bad-new-query"));
        if (query instanceof Class) {
            throw new UserException(_loc.get("bad-new-query"));
        }
        this.beginOperation(false);
        try {
            QueryImpl queryImpl;
            try {
                StoreQuery sq = this._store.newQuery(lang);
                if (sq == null) {
                    ExpressionParser ep = QueryLanguages.parserForLanguage(lang);
                    if (ep != null) {
                        sq = new ExpressionStoreQuery(ep);
                    } else {
                        if (!"openjpa.MethodQL".equals(lang)) throw new UnsupportedException(lang);
                        sq = new MethodStoreQuery();
                    }
                }
                QueryImpl q = this.newQueryImpl(lang, sq);
                q.setIgnoreChanges(this._ignoreChanges);
                if (query != null) {
                    q.setQuery(query);
                }
                if (this._queries == null) {
                    this._queries = new ReferenceHashSet(2);
                }
                this._queries.add(q);
                queryImpl = q;
                Object var7_8 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
            return queryImpl;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.endOperation();
            throw throwable;
        }
    }

    protected QueryImpl newQueryImpl(String lang, StoreQuery sq) {
        return new QueryImpl(this, lang, sq);
    }

    @Override
    public Seq getIdentitySequence(ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        return this.getSequence(meta, null);
    }

    @Override
    public Seq getValueSequence(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        return this.getSequence(fmd.getDefiningMetaData(), fmd);
    }

    private Seq getSequence(ClassMetaData meta, FieldMetaData fmd) {
        int strategy = fmd == null ? meta.getIdentityStrategy() : fmd.getValueStrategy();
        switch (strategy) {
            case 6: {
                return UUIDHexSeq.getInstance();
            }
            case 5: {
                return UUIDStringSeq.getInstance();
            }
            case 8: {
                return UUIDType4HexSeq.getInstance();
            }
            case 7: {
                return UUIDType4StringSeq.getInstance();
            }
            case 2: {
                SequenceMetaData smd = fmd == null ? meta.getIdentitySequenceMetaData() : fmd.getValueSequenceMetaData();
                return smd.getInstance(this._loader);
            }
        }
        if (fmd == null) {
            FieldMetaData[] pks = meta.getPrimaryKeyFields();
            SequenceMetaData smd = pks != null && pks.length == 1 ? pks[0].getValueSequenceMetaData() : meta.getIdentitySequenceMetaData();
            if (smd != null) {
                return smd.getInstance(this._loader);
            }
            return this._store.getDataStoreIdSequence(meta);
        }
        return this._store.getValueSequence(fmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.lock(obj, this._fc.getWriteLockLevel(), this._fc.getLockTimeout(), call);
            Object var4_3 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endOperation();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void lock(Object obj, int level, int timeout, OpCallbacks call) {
        block11: {
            block10: {
                if (obj == null) {
                    return;
                }
                this.beginOperation(true);
                try {
                    block9: {
                        try {
                            this.assertActiveTransaction();
                            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                            if ((this.processArgument(10, obj, sm, call) & 4) == 0) {
                                Object var7_8 = null;
                                break block9;
                            }
                            if (sm == null) break block10;
                            if (!sm.isPersistent()) {
                                break block10;
                            }
                            this._lm.lock(sm, level, timeout, null);
                            sm.readLocked(level, level);
                            break block11;
                        }
                        catch (OpenJPAException ke) {
                            throw ke;
                        }
                        catch (RuntimeException re) {
                            throw new GeneralException(re);
                        }
                    }
                    this.endOperation();
                    return;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.endOperation();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            this.endOperation();
            return;
        }
        Object var7_10 = null;
        this.endOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAll(Collection objs, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        try {
            this.lockAll(objs, this._fc.getWriteLockLevel(), this._fc.getLockTimeout(), call);
            Object var4_3 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endOperation();
            throw throwable;
        }
    }

    @Override
    public void lockAll(Collection objs, int level, int timeout, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.lock(objs.iterator().next(), level, timeout, call);
            return;
        }
        this.beginOperation(true);
        try {
            try {
                this.assertActiveTransaction();
                LinkedHashSet<StateManagerImpl> sms = new LinkedHashSet<StateManagerImpl>(objs.size());
                for (Object obj : objs) {
                    StateManagerImpl sm;
                    if (obj == null || (this.processArgument(10, obj, sm = this.getStateManagerImpl(obj, true), call) & 4) == 0 || sm == null || !sm.isPersistent()) continue;
                    sms.add(sm);
                }
                this._lm.lockAll(sms, level, timeout, null);
                Iterator itr = sms.iterator();
                while (itr.hasNext()) {
                    ((StateManagerImpl)itr.next()).readLocked(level, level);
                }
                Object var10_11 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endOperation();
            throw throwable;
        }
    }

    @Override
    public boolean cancelAll() {
        this.assertOpen();
        try {
            if ((this._flags & 0x80) != 0) {
                this.setRollbackOnlyInternal(new UserException());
            }
            return this._store.cancelAll();
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new StoreException(re);
        }
    }

    @Override
    public Object getConnection() {
        this.assertOpen();
        if (!this._conf.supportedOptions().contains("openjpa.option.DataStoreConnection")) {
            throw new UnsupportedException(_loc.get("conn-not-supported"));
        }
        return this._store.getClientConnection();
    }

    @Override
    public boolean hasConnection() {
        this.assertOpen();
        return (this._flags & 0x800) != 0;
    }

    private void retainConnection() {
        if ((this._flags & 0x800) == 0) {
            this._store.retainConnection();
            this._flags |= 0x800;
        }
    }

    private void releaseConnection() {
        if ((this._flags & 0x800) != 0) {
            this._store.releaseConnection();
            this._flags &= 0xFFFFF7FF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getManagedObjects() {
        ManagedObjectCollection managedObjectCollection;
        this.beginOperation(false);
        try {
            managedObjectCollection = new ManagedObjectCollection(this.getManagedStates());
            Object var3_2 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endOperation();
            throw throwable;
        }
        return managedObjectCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTransactionalObjects() {
        ManagedObjectCollection managedObjectCollection;
        this.beginOperation(false);
        try {
            managedObjectCollection = new ManagedObjectCollection(this.getTransactionalStates());
            Object var3_2 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endOperation();
            throw throwable;
        }
        return managedObjectCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPendingTransactionalObjects() {
        ManagedObjectCollection managedObjectCollection;
        this.beginOperation(false);
        try {
            managedObjectCollection = new ManagedObjectCollection(this.getPendingTransactionalStates());
            Object var3_2 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endOperation();
            throw throwable;
        }
        return managedObjectCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDirtyObjects() {
        ManagedObjectCollection managedObjectCollection;
        this.beginOperation(false);
        try {
            managedObjectCollection = new ManagedObjectCollection(this.getDirtyStates());
            Object var3_2 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endOperation();
            throw throwable;
        }
        return managedObjectCollection;
    }

    @Override
    public boolean getOrderDirtyObjects() {
        return this._orderDirty;
    }

    @Override
    public void setOrderDirtyObjects(boolean order) {
        this._orderDirty = order;
    }

    protected Collection getManagedStates() {
        return this._cache.copy();
    }

    protected Collection<StateManagerImpl> getTransactionalStates() {
        if (!this.hasTransactionalObjects()) {
            return Collections.EMPTY_SET;
        }
        return this._transCache.copy();
    }

    private boolean hasTransactionalObjects() {
        this._cache.dirtyCheck();
        return this._transCache != null;
    }

    protected Collection getDirtyStates() {
        if (!this.hasTransactionalObjects()) {
            return Collections.EMPTY_SET;
        }
        return this._transCache.copyDirty();
    }

    protected Collection getPendingTransactionalStates() {
        if (this._pending == null) {
            return Collections.EMPTY_SET;
        }
        return new LinkedHashSet<StateManagerImpl>(this._pending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateManager(Object id, StateManagerImpl sm, int status) {
        this.lock();
        try {
            switch (status) {
                case 0: {
                    this._cache.add(sm);
                    break;
                }
                case 1: {
                    this._cache.remove(id, sm);
                    break;
                }
                case 2: {
                    this.assignObjectId(this._cache, id, sm);
                    break;
                }
                case 3: {
                    this._cache.commitNew(id, sm);
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
            Object var5_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTransaction(StateManagerImpl sm) {
        if (sm.isDirty()) {
            return;
        }
        this.lock();
        try {
            if (!this.hasTransactionalObjects()) {
                this._transCache = new TransactionalCache(this._orderDirty);
            }
            this._transCache.addClean(sm);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._transCache != null) {
                this._transCache.remove(sm);
            }
            if (this._derefCache != null && !sm.isPersistent()) {
                this._derefCache.remove(sm);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDirty(StateManagerImpl sm, boolean firstDirty) {
        if (sm.isPersistent()) {
            this._flags |= 0x200;
        }
        if (this._savepoints != null && !this._savepoints.isEmpty()) {
            if (this._savepointCache == null) {
                this._savepointCache = new HashSet<StateManagerImpl>();
            }
            this._savepointCache.add(sm);
        }
        if (firstDirty && sm.isTransactional()) {
            this.lock();
            try {
                if (!this.hasTransactionalObjects()) {
                    this._transCache = new TransactionalCache(this._orderDirty);
                }
                this._transCache.addDirty(sm);
                if (sm.isNew()) {
                    if (this._persistedClss == null) {
                        this._persistedClss = new HashSet();
                    }
                    this._persistedClss.add(sm.getMetaData().getDescribedType());
                } else if (sm.isDeleted()) {
                    if (this._deletedClss == null) {
                        this._deletedClss = new HashSet();
                    }
                    this._deletedClss.add(sm.getMetaData().getDescribedType());
                } else {
                    if (this._updatedClss == null) {
                        this._updatedClss = new HashSet();
                    }
                    this._updatedClss.add(sm.getMetaData().getDescribedType());
                }
                if ((this._flags & 0x10) != 0) {
                    if (this._transAdditions == null) {
                        this._transAdditions = new HashSet<StateManagerImpl>();
                    }
                    this._transAdditions.add(sm);
                }
                Object var4_3 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPendingTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._pending == null) {
                this._pending = new HashSet<StateManagerImpl>();
            }
            this._pending.add(sm);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromPendingTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._pending != null) {
                this._pending.remove(sm);
            }
            if (this._derefCache != null && !sm.isPersistent()) {
                this._derefCache.remove(sm);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDereferencedDependent(StateManagerImpl sm) {
        this.lock();
        try {
            if ((this._flags & 0x20) != 0) {
                if (this._derefAdditions == null) {
                    this._derefAdditions = new HashSet<StateManagerImpl>();
                }
                this._derefAdditions.add(sm);
            } else {
                if (this._derefCache == null) {
                    this._derefCache = new HashSet<StateManagerImpl>();
                }
                this._derefCache.add(sm);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDereferencedDependent(StateManagerImpl sm) {
        this.lock();
        try {
            boolean removed = false;
            if (this._derefAdditions != null) {
                removed = this._derefAdditions.remove(sm);
            }
            if (!(removed || this._derefCache != null && this._derefCache.remove(sm))) {
                throw new InvalidStateException(_loc.get("not-derefed", Exceptions.toString(sm.getManagedInstance()))).setFailedObject(sm.getManagedInstance()).setFatal(true);
            }
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirtyType(Class cls) {
        if (cls == null) {
            return;
        }
        this.beginOperation(false);
        try {
            if (this._updatedClss == null) {
                this._updatedClss = new HashSet();
            }
            this._updatedClss.add(cls);
            Object var3_2 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endOperation();
            throw throwable;
        }
    }

    public Collection getPersistedTypes() {
        if (this._persistedClss == null || this._persistedClss.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this._persistedClss);
    }

    public Collection getUpdatedTypes() {
        if (this._updatedClss == null || this._updatedClss.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this._updatedClss);
    }

    public Collection getDeletedTypes() {
        if (this._deletedClss == null || this._deletedClss.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this._deletedClss);
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public boolean isCloseInvoked() {
        return this._closed || (this._flags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.beginOperation(false);
        try {
            if (!this._managed && (this._flags & 2) != 0) {
                throw new InvalidStateException(_loc.get("active"));
            }
            this._flags |= 8;
            if ((this._flags & 2) == 0) {
                this.free();
            }
            Object var2_1 = null;
            this.endOperation();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endOperation();
            throw throwable;
        }
    }

    protected void free() {
        RuntimeException err = null;
        if ((this._autoDetach & 2) != 0) {
            try {
                this.detachAllInternal(this._call);
            }
            catch (RuntimeException re) {
                err = re;
            }
        }
        this._sync = null;
        this._userObjects = null;
        this._cache.clear();
        this._transCache = null;
        this._persistedClss = null;
        this._updatedClss = null;
        this._deletedClss = null;
        this._derefCache = null;
        this._pending = null;
        this._loader = null;
        this._transEventManager = null;
        this._lifeEventManager = null;
        while (this._savepoints != null && !this._savepoints.isEmpty()) {
            OpenJPASavepoint save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
            save.release(false);
        }
        this._savepoints = null;
        this._savepointCache = null;
        if (this._queries != null) {
            Iterator itr = this._queries.iterator();
            while (itr.hasNext()) {
                try {
                    ((Query)itr.next()).closeResources();
                }
                catch (RuntimeException re) {}
            }
            this._queries = null;
        }
        if (this._extents != null) {
            for (Extent e : this._extents) {
                try {
                    e.closeAll();
                }
                catch (RuntimeException re) {}
            }
            this._extents = null;
        }
        try {
            this.releaseConnection();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this._lm.close();
        this._store.close();
        this._flags = 0;
        this._closed = true;
        if (this._log.isTraceEnabled()) {
            this._closedException = new IllegalStateException();
        }
        this._factory.releaseBroker(this);
        if (err != null) {
            throw err;
        }
    }

    @Override
    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    @Override
    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    @Override
    public Object newInstance(Class cls) {
        this.assertOpen();
        if (!cls.isInterface() && Modifier.isAbstract(cls.getModifiers())) {
            throw new UnsupportedOperationException(_loc.get("new-abstract", cls).getMessage());
        }
        if (!PCRegistry.isRegistered(cls)) {
            try {
                Class.forName(cls.getName(), true, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls)));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this.getClassLoader(), false) == null) {
            throw new IllegalArgumentException(_loc.get("no-interface-metadata", cls.getName()).getMessage());
        }
        try {
            return PCRegistry.newInstance(cls, null, false);
        }
        catch (IllegalStateException ise) {
            IllegalArgumentException iae = new IllegalArgumentException(ise.getMessage());
            iae.setStackTrace(ise.getStackTrace());
            throw iae;
        }
    }

    @Override
    public Object getObjectId(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcFetchObjectId();
        }
        return null;
    }

    @Override
    public int getLockLevel(Object o) {
        this.assertOpen();
        if (o == null) {
            return 0;
        }
        OpenJPAStateManager sm = this.getStateManager(o);
        if (sm == null) {
            return 0;
        }
        return this.getLockManager().getLockLevel(sm);
    }

    @Override
    public Object getVersion(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcGetVersion();
        }
        return null;
    }

    @Override
    public boolean isDirty(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
            return pc.pcIsDirty();
        }
        return false;
    }

    @Override
    public boolean isTransactional(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsTransactional();
        }
        return false;
    }

    @Override
    public boolean isPersistent(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsPersistent();
        }
        return false;
    }

    @Override
    public boolean isNew(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsNew();
        }
        return false;
    }

    @Override
    public boolean isDeleted(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsDeleted();
        }
        return false;
    }

    @Override
    public boolean isDetached(Object obj) {
        if (!ImplHelper.isManageable(obj)) {
            return false;
        }
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
        Boolean detached = pc.pcIsDetached();
        if (detached != null) {
            return detached;
        }
        ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(ImplHelper.getManagedInstance(pc).getClass(), this._loader, true);
        Object oid = ApplicationIds.create(pc, meta);
        if (oid == null) {
            return false;
        }
        return this.find(oid, null, EXCLUDE_ALL, null, 0) != null;
    }

    @Override
    public OpenJPAStateManager getStateManager(Object obj) {
        this.assertOpen();
        return this.getStateManagerImpl(obj, false);
    }

    protected StateManagerImpl getStateManagerImpl(Object obj, boolean assertThisContext) {
        if (ImplHelper.isManageable(obj)) {
            PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
            BrokerImpl pcBroker = (BrokerImpl)pc.pcGetGenericContext();
            if (pcBroker == this || this.isFromWriteBehindCallback()) {
                return (StateManagerImpl)pc.pcGetStateManager();
            }
            if (assertThisContext && pcBroker != null) {
                throw new UserException(_loc.get("not-managed", Exceptions.toString(obj))).setFailedObject(obj);
            }
        }
        return null;
    }

    protected StateManagerImpl getStateManagerImplById(Object oid, boolean allowNew) {
        return this._cache.getById(oid, allowNew);
    }

    protected PersistenceCapable assertPersistenceCapable(Object obj) {
        if (obj == null) {
            return null;
        }
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf);
        }
        Class<?>[] intfs = obj.getClass().getInterfaces();
        for (int i = 0; intfs != null && i < intfs.length; ++i) {
            if (!intfs[i].getName().equals(PersistenceCapable.class.getName())) continue;
            throw new UserException(_loc.get("pc-loader-different", Exceptions.toString(obj), AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(PersistenceCapable.class)), AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(intfs[i])))).setFailedObject(obj);
        }
        throw new UserException(_loc.get("pc-cast", Exceptions.toString(obj))).setFailedObject(obj);
    }

    @Override
    public void assertOpen() {
        if (this._closed) {
            if (this._closedException == null) {
                throw new InvalidStateException(_loc.get("closed-notrace")).setFatal(true);
            }
            OpenJPAException e = new InvalidStateException(_loc.get("closed"), (Object)this._closedException).setFatal(true);
            e.setCause(this._closedException);
            throw e;
        }
    }

    @Override
    public void assertActiveTransaction() {
        if ((this._flags & 2) == 0) {
            throw new NoTransactionException(_loc.get("not-active"));
        }
    }

    private void assertTransactionOperation() {
        if ((this._flags & 2) == 0) {
            throw new InvalidStateException(_loc.get("not-active"));
        }
    }

    @Override
    public void assertNontransactionalRead() {
        if ((this._flags & 2) == 0 && !this._nontransRead) {
            throw new InvalidStateException(_loc.get("non-trans-read"));
        }
    }

    @Override
    public void assertWriteOperation() {
        if (!((this._flags & 2) != 0 || this._nontransWrite && (this._autoDetach & 8) == 0)) {
            throw new NoTransactionException(_loc.get("write-operation"));
        }
    }

    private static ObjectNotFoundException newObjectNotFoundException(Collection failed) {
        Throwable[] t = new Throwable[failed.size()];
        int idx = 0;
        Iterator itr = failed.iterator();
        while (itr.hasNext()) {
            t[idx] = new ObjectNotFoundException(itr.next());
            ++idx;
        }
        return new ObjectNotFoundException(failed, t);
    }

    @Override
    public Object processArgument(Object oid) {
        return oid;
    }

    @Override
    public Object processReturn(Object oid, OpenJPAStateManager sm) {
        return sm == null ? null : sm.getManagedInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        this.assertOpen();
        this.lock();
        try {
            if (this.isActive()) {
                if (!this.getOptimistic()) {
                    throw new InvalidStateException(_loc.get("cant-serialize-pessimistic-broker"));
                }
                if (this.hasFlushed()) {
                    throw new InvalidStateException(_loc.get("cant-serialize-flushed-broker"));
                }
                if (this.hasConnection()) {
                    throw new InvalidStateException(_loc.get("cant-serialize-connected-broker"));
                }
            }
            try {
                this._isSerializing = true;
                out.writeObject(this._factory.getPoolKey());
                out.defaultWriteObject();
                Object var3_2 = null;
                this._isSerializing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._isSerializing = false;
                throw throwable;
            }
            Object var5_5 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Object factoryKey = in.readObject();
        AbstractBrokerFactory factory = AbstractBrokerFactory.getPooledFactoryForKey(factoryKey);
        this._conf = factory.getConfiguration();
        in.defaultReadObject();
        factory.initializeBroker(this._managed, this._connRetainMode, this, true);
        this.setMultithreaded(this._multithreaded);
        if (this.isActive() && this._runtime instanceof LocalManagedRuntime) {
            ((LocalManagedRuntime)this._runtime).begin();
        }
    }

    boolean isSerializing() {
        return this._isSerializing;
    }

    protected void assignObjectId(Object cache, Object id, StateManagerImpl sm) {
        ((ManagedCache)cache).assignObjectId(id, sm);
    }

    protected void checkForDuplicateId(Object id, Object obj) {
        StateManagerImpl other = this.getStateManagerImplById(id, false);
        if (other != null && !other.isDeleted() && !other.isNew()) {
            throw new ObjectExistsException(_loc.get("cache-exists", obj.getClass().getName(), id)).setFailedObject(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCachePreparedQuery() {
        this.lock();
        try {
            boolean bl = this._cachePreparedQuery && this._conf.getQuerySQLCacheInstance() != null;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCachePreparedQuery(boolean flag) {
        this.lock();
        try {
            this._cachePreparedQuery = flag;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCacheFinderQuery() {
        this.lock();
        try {
            boolean bl = this._cacheFinderQuery && this._conf.getFinderCacheInstance() != null;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheFinderQuery(boolean flag) {
        this.lock();
        try {
            this._cachePreparedQuery = flag;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean isFromWriteBehindCallback() {
        return this._fromWriteBehindCallback;
    }

    static {
        _supportedPropertyNames.addAll(Arrays.asList("AutoClear", "AutoDetach", "CacheFinderQuery", "CachePreparedQuery", "DetachedNew", "DetachState", "EvictFromDataCache", "IgnoreChanges", "LifecycleListenerCallbackMode", "Multithreaded", "NontransactionalRead", "NontransactionalWrite", "Optimistic", "PopulateDataCache", "RestoreState", "RetainState"));
    }

    private static class ManagedObjectCollection
    extends AbstractCollection {
        private final Collection _states;

        public ManagedObjectCollection(Collection states) {
            this._states = states;
        }

        public Collection getStateManagers() {
            return this._states;
        }

        public int size() {
            return this._states.size();
        }

        public Iterator iterator() {
            return new Iterator(){
                private final Iterator _itr;
                {
                    this._itr = ManagedObjectCollection.this._states.iterator();
                }

                public boolean hasNext() {
                    return this._itr.hasNext();
                }

                public Object next() {
                    return ((OpenJPAStateManager)this._itr.next()).getManagedInstance();
                }

                public void remove() {
                    throw new UnsupportedException();
                }
            };
        }
    }

    private static class StateManagerId
    implements Serializable {
        public static final String STRING_PREFIX = "openjpasm:";
        private static long _generator = 0L;
        private final int _bhash;
        private final long _id;

        public static StateManagerId newInstance(Broker b) {
            return new StateManagerId(System.identityHashCode(b), _generator++);
        }

        private StateManagerId(int bhash, long id) {
            this._bhash = bhash;
            this._id = id;
        }

        public StateManagerId(String str) {
            str = str.substring(STRING_PREFIX.length());
            int idx = str.indexOf(58);
            this._bhash = Integer.parseInt(str.substring(0, idx));
            this._id = Long.parseLong(str.substring(idx + 1));
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof StateManagerId)) {
                return false;
            }
            StateManagerId sid = (StateManagerId)other;
            return this._bhash == sid._bhash && this._id == sid._id;
        }

        public int hashCode() {
            return (int)(this._id ^ this._id >>> 32);
        }

        public String toString() {
            return STRING_PREFIX + this._bhash + ":" + this._id;
        }
    }

    static class TransactionalCache
    implements Set,
    Serializable {
        private final boolean _orderDirty;
        private Set<StateManagerImpl> _dirty = null;
        private Set<StateManagerImpl> _clean = null;

        public TransactionalCache(boolean orderDirty) {
            this._orderDirty = orderDirty;
        }

        public Collection copy() {
            Iterator<StateManagerImpl> itr;
            if (this.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet<StateManagerImpl> copy = new LinkedHashSet<StateManagerImpl>(this.size());
            if (this._dirty != null) {
                itr = this._dirty.iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            if (this._clean != null) {
                itr = this._clean.iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            return copy;
        }

        public Collection copyDirty() {
            if (this._dirty == null || this._dirty.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            return new LinkedHashSet<StateManagerImpl>(this._dirty);
        }

        public void flushed(StateManagerImpl sm) {
            if (sm.isDirty() && this._dirty != null && this._dirty.remove(sm)) {
                this.addCleanInternal(sm);
            }
        }

        public void addClean(StateManagerImpl sm) {
            if (this.addCleanInternal(sm) && this._dirty != null) {
                this._dirty.remove(sm);
            }
        }

        private boolean addCleanInternal(StateManagerImpl sm) {
            if (this._clean == null) {
                this._clean = new ReferenceHashSet(1);
            }
            return this._clean.add(sm);
        }

        public void addDirty(StateManagerImpl sm) {
            if (this._dirty == null) {
                this._dirty = this._orderDirty ? MapBackedSet.decorate(new LinkedMap()) : new HashSet<StateManagerImpl>();
            }
            if (this._dirty.add(sm)) {
                this.removeCleanInternal(sm);
            }
        }

        public boolean remove(StateManagerImpl sm) {
            return this.removeCleanInternal(sm) || this._dirty != null && this._dirty.remove(sm);
        }

        private boolean removeCleanInternal(StateManagerImpl sm) {
            return this._clean != null && this._clean.remove(sm);
        }

        public Iterator iterator() {
            IteratorChain chain = new IteratorChain();
            if (this._dirty != null && !this._dirty.isEmpty()) {
                chain.addIterator(this._dirty.iterator());
            }
            if (this._clean != null && !this._clean.isEmpty()) {
                chain.addIterator(this._clean.iterator());
            }
            return chain;
        }

        public boolean contains(Object obj) {
            return this._dirty != null && this._dirty.contains(obj) || this._clean != null && this._clean.contains(obj);
        }

        public boolean containsAll(Collection coll) {
            Iterator itr = coll.iterator();
            while (itr.hasNext()) {
                if (this.contains(itr.next())) continue;
                return false;
            }
            return true;
        }

        public void clear() {
            if (this._dirty != null) {
                this._dirty = null;
            }
            if (this._clean != null) {
                this._clean = null;
            }
        }

        public boolean isEmpty() {
            return !(this._dirty != null && !this._dirty.isEmpty() || this._clean != null && !this._clean.isEmpty());
        }

        public int size() {
            int size = 0;
            if (this._dirty != null) {
                size += this._dirty.size();
            }
            if (this._clean != null) {
                size += this._clean.size();
            }
            return size;
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray(Object[] arr) {
            throw new UnsupportedOperationException();
        }
    }
}

