/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.kernel.ObjectFactory;
import org.apache.openjpa.persistence.TupleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleFactory
implements ObjectFactory<Tuple> {
    private final List<TupleElement<?>> elements;

    public TupleFactory(List<TupleElement<?>> elems) {
        this.elements = Collections.unmodifiableList(elems);
    }

    public TupleFactory(TupleElement<?> ... elems) {
        this(Arrays.asList(elems));
    }

    public TupleFactory(Selection<?> ... elems) {
        ArrayList list = new ArrayList();
        for (Selection<?> s : elems) {
            list.add(s);
        }
        this.elements = Collections.unmodifiableList(list);
    }

    public List<TupleElement<?>> getElements() {
        return this.elements;
    }

    @Override
    public TupleImpl newInstance() {
        TupleImpl impl = new TupleImpl(this);
        return impl;
    }

    public int getIndex(TupleElement<?> e) {
        int i = this.elements.indexOf(e);
        if (i == -1) {
            throw new IllegalArgumentException("Index " + i + " does not exist");
        }
        return i;
    }

    public int getIndex(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias");
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            TupleElement<?> e = this.elements.get(i);
            if (!alias.equals(e.getAlias())) continue;
            return i;
        }
        throw new IllegalArgumentException(alias + " not found");
    }
}

