/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class JavaVersions {
    public static final int VERSION;
    private static final Class[] EMPTY_CLASSES;
    private static Class PARAM_TYPE;
    private static Class ENUM_TYPE;
    private static Class ANNO_TYPE;
    private static Method GET_STACK;
    private static Method SET_STACK;
    private static Method GET_CAUSE;
    private static Method INIT_CAUSE;

    public static Class getVersionSpecificClass(Class base) {
        try {
            return JavaVersions.getVersionSpecificClass(base.getName());
        }
        catch (ClassNotFoundException e) {
            return base;
        }
    }

    public static Class getVersionSpecificClass(String base) throws ClassNotFoundException {
        for (int i = VERSION; i >= 1; --i) {
            try {
                return Class.forName(base + i);
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return Class.forName(base);
    }

    public static boolean isAnnotation(Class cls) {
        return ANNO_TYPE != null && ANNO_TYPE.isAssignableFrom(cls);
    }

    public static boolean isEnumeration(Class cls) {
        return ENUM_TYPE != null && ENUM_TYPE.isAssignableFrom(cls);
    }

    public static Class[] getParameterizedTypes(Field f) {
        if (f == null) {
            return null;
        }
        if (VERSION < 5) {
            return EMPTY_CLASSES;
        }
        try {
            Object type = Field.class.getMethod("getGenericType", null).invoke((Object)f, (Object[])null);
            return JavaVersions.collectParameterizedTypes(type);
        }
        catch (Exception e) {
            return EMPTY_CLASSES;
        }
    }

    public static Class[] getParameterizedTypes(Method meth) {
        if (meth == null) {
            return null;
        }
        if (VERSION < 5) {
            return EMPTY_CLASSES;
        }
        try {
            Object type = Method.class.getMethod("getGenericReturnType", null).invoke((Object)meth, (Object[])null);
            return JavaVersions.collectParameterizedTypes(type);
        }
        catch (Exception e) {
            return EMPTY_CLASSES;
        }
    }

    private static Class[] collectParameterizedTypes(Object type) throws Exception {
        if (PARAM_TYPE == null || !PARAM_TYPE.isInstance(type)) {
            return EMPTY_CLASSES;
        }
        Object[] args = (Object[])PARAM_TYPE.getMethod("getActualTypeArguments", null).invoke(type, (Object[])null);
        if (args.length == 0) {
            return EMPTY_CLASSES;
        }
        Class[] clss = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Class)) {
                return EMPTY_CLASSES;
            }
            clss[i] = (Class)args[i];
        }
        return clss;
    }

    public static boolean transferStackTrace(Throwable from, Throwable to) {
        if (GET_STACK == null || SET_STACK == null || from == null || to == null) {
            return false;
        }
        try {
            Object stack = GET_STACK.invoke((Object)from, (Object[])null);
            SET_STACK.invoke((Object)to, stack);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Throwable getCause(Throwable ex) {
        if (GET_CAUSE == null || ex == null) {
            return null;
        }
        try {
            return (Throwable)GET_CAUSE.invoke((Object)ex, (Object[])null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Throwable initCause(Throwable ex, Throwable cause) {
        if (INIT_CAUSE == null || ex == null || cause == null) {
            return ex;
        }
        try {
            return (Throwable)INIT_CAUSE.invoke((Object)ex, cause);
        }
        catch (Throwable t) {
            return ex;
        }
    }

    public static void main(String[] args) {
        System.out.println("Java version is: " + VERSION);
    }

    static {
        EMPTY_CLASSES = new Class[0];
        PARAM_TYPE = null;
        ENUM_TYPE = null;
        ANNO_TYPE = null;
        GET_STACK = null;
        SET_STACK = null;
        GET_CAUSE = null;
        INIT_CAUSE = null;
        String specVersion = AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("java.specification.version"));
        VERSION = "1.2".equals(specVersion) ? 2 : ("1.3".equals(specVersion) ? 3 : ("1.4".equals(specVersion) ? 4 : ("1.5".equals(specVersion) ? 5 : ("1.6".equals(specVersion) ? 6 : 7))));
        if (VERSION >= 5) {
            try {
                PARAM_TYPE = Class.forName("java.lang.reflect.ParameterizedType");
                ENUM_TYPE = Class.forName("java.lang.Enum");
                ANNO_TYPE = Class.forName("java.lang.annotation.Annotation");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (VERSION >= 4) {
            try {
                Class<?> stack = Class.forName("[Ljava.lang.StackTraceElement;");
                GET_STACK = Throwable.class.getMethod("getStackTrace", null);
                SET_STACK = Throwable.class.getMethod("setStackTrace", stack);
                GET_CAUSE = Throwable.class.getMethod("getCause", null);
                INIT_CAUSE = Throwable.class.getMethod("initCause", Throwable.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

