/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.openjpa.lib.rop.AbstractNonSequentialResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;

public class WindowResultList
extends AbstractNonSequentialResultList {
    private static final int OPEN = 0;
    private static final int FREED = 1;
    private static final int CLOSED = 2;
    private final Object[] _window;
    private int _pos = -1;
    private ResultObjectProvider _rop = null;
    private boolean _random = false;
    private int _state = 0;
    private int _size = -1;

    public WindowResultList(ResultObjectProvider rop) {
        this(rop, 10);
    }

    public WindowResultList(ResultObjectProvider rop, int windowSize) {
        this._rop = rop;
        if (windowSize <= 0) {
            windowSize = 10;
        }
        this._window = new Object[windowSize];
        try {
            this._rop.open();
            this._random = this._rop.supportsRandomAccess();
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
        }
    }

    public boolean isProviderOpen() {
        return this._state == 0;
    }

    public boolean isClosed() {
        return this._state == 2;
    }

    public void close() {
        if (this._state != 2) {
            this.free();
            this._state = 2;
        }
    }

    public int size() {
        this.assertOpen();
        if (this._size != -1) {
            return this._size;
        }
        try {
            this._size = this._rop.size();
            return this._size;
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return -1;
        }
    }

    public Object getInternal(int index) {
        if (index < 0 || this._size != -1 && index >= this._size) {
            return PAST_END;
        }
        try {
            if (index < this._pos) {
                if (!this._random || index == 0) {
                    this._rop.reset();
                }
                this._pos = -1;
            }
            if (this._pos == -1 || index >= this._pos + this._window.length) {
                int i;
                if (this._random && index != 0) {
                    if (!this._rop.absolute(index - 1)) {
                        return PAST_END;
                    }
                } else {
                    int begin;
                    for (i = begin = this._pos == -1 ? 0 : this._pos + this._window.length; i < index; ++i) {
                        if (this._rop.next()) continue;
                        return PAST_END;
                    }
                }
                int end = -1;
                for (i = 0; i < this._window.length; ++i) {
                    if (end == -1 && !this._rop.next()) {
                        end = i;
                    }
                    this._window[i] = end == -1 ? this._rop.getResultObject() : PAST_END;
                }
                this._pos = index;
                if (end != -1 && this._pos == 0) {
                    this._size = end;
                    this.free();
                }
            }
            return this._window[index - this._pos];
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return null;
        }
    }

    private void free() {
        if (this._state == 0) {
            try {
                this._rop.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._state = 1;
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this._state != 0) {
            return this;
        }
        ArrayList list = new ArrayList();
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }
}

