/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingBrokerFactory
implements BrokerFactory {
    private final BrokerFactory _factory;
    private final DelegatingBrokerFactory _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingBrokerFactory(BrokerFactory factory) {
        this(factory, null);
    }

    public DelegatingBrokerFactory(BrokerFactory factory, RuntimeExceptionTranslator trans) {
        this._factory = factory;
        this._del = factory instanceof DelegatingBrokerFactory ? (DelegatingBrokerFactory)factory : null;
        this._trans = trans;
    }

    public BrokerFactory getDelegate() {
        return this._factory;
    }

    public BrokerFactory getInnermostDelegate() {
        return this._del == null ? this._factory : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingBrokerFactory) {
            other = ((DelegatingBrokerFactory)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        try {
            return this._factory.getConfiguration();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            return this._factory.getProperties();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Set<String> getSupportedProperties() {
        try {
            return this._factory.getSupportedProperties();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Object putUserObject(Object key, Object val) {
        try {
            return this._factory.putUserObject(key, val);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Object getUserObject(Object key) {
        try {
            return this._factory.getUserObject(key);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Broker newBroker() {
        try {
            return this._factory.newBroker();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode, boolean findExisting) {
        try {
            return this._factory.newBroker(user, pass, managed, connRetainMode, findExisting);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void addLifecycleListener(Object listener, Class[] classes) {
        try {
            this._factory.addLifecycleListener(listener, classes);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void removeLifecycleListener(Object listener) {
        try {
            this._factory.removeLifecycleListener(listener);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void addTransactionListener(Object listener) {
        try {
            this._factory.addTransactionListener(listener);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void removeTransactionListener(Object listener) {
        try {
            this._factory.removeTransactionListener(listener);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void close() {
        try {
            this._factory.close();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this._factory.isClosed();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void lock() {
        try {
            this._factory.lock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void unlock() {
        try {
            this._factory.unlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

