/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UnsupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdDictionary
extends DBDictionary {
    public int firebirdVersion = 0;
    public int indexedVarcharMaxSizeFB15 = 252;
    public String rangeSyntax = null;
    protected long maxRowNumberInRange = 16000000000L;
    protected String alterSequenceSQLFB15 = "SET GENERATOR {0} TO {1}";
    protected String alterSequenceSQLFB20 = "ALTER SEQUENCE {0} RESTART WITH {1}";
    protected String createSequenceSQLFB15 = "CREATE GENERATOR {0}";
    protected String createSequenceSQLFB20 = "CREATE SEQUENCE {0}";
    protected String dropSequenceSQLFB15 = "DROP GENERATOR ";
    protected String nextSequenceQueryFB15 = "SELECT GEN_ID({0}, 1) FROM RDB$DATABASE";
    protected String nextSequenceQueryFB20 = "SELECT NEXT VALUE FOR {0} FROM RDB$DATABASE";
    protected String alterSequenceSQL = this.alterSequenceSQLFB20;
    protected String createSequenceSQL = this.createSequenceSQLFB20;
    public static final int FB_VERSION_15 = 15;
    public static final int FB_VERSION_20 = 20;
    public static final int FB_VERSION_21 = 21;
    public static final String RANGE_SYNTAX_FIRST_SKIP = "firstskip";
    public static final String RANGE_SYNTAX_ROWS = "rows";
    private static final Localizer _loc = Localizer.forPackage(FirebirdDictionary.class);

    public FirebirdDictionary() {
        this.platform = "Firebird";
        this.validationSQL = "SELECT 1 FROM RDB$DATABASE";
        this.supportsDeferredConstraints = false;
        this.useGetStringForClobs = true;
        this.useSetStringForClobs = true;
        this.useGetBytesForBlobs = true;
        this.useSetBytesForBlobs = true;
        this.maxTableNameLength = 31;
        this.maxColumnNameLength = 31;
        this.maxConstraintNameLength = 31;
        this.maxIndexNameLength = 31;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.supportsMultipleNontransactionalResultSets = false;
        this.nextSequenceQuery = this.nextSequenceQueryFB20;
        this.sequenceSQL = "SELECT NULL AS SEQUENCE_SCHEMA, RDB$GENERATOR_NAME AS SEQUENCE_NAME FROM RDB$GENERATORS WHERE (RDB$SYSTEM_FLAG IS NULL OR RDB$SYSTEM_FLAG = 0) ";
        this.sequenceNameSQL = "AND RDB$GENERATOR_NAME = ?";
        this.reservedWordSet.addAll(Arrays.asList("ACTIVE", "ADMIN", "AFTER", "ASCENDING", "AUTO", "AUTODDL", "BASED", "BASENAME", "BASE_NAME", "BEFORE", "BIGINT", "BLOB", "BLOBEDIT", "BUFFER", "CACHE", "CHECK_POINT_LEN", "CHECK_POINT_LENGTH", "COMPILETIME", "COMPUTED", "CLOSE", "CONDITIONAL", "CONTAINING", "CSTRING", "CURRENT_CONNECTION", "CURRENT_ROLE", "CURRENT_TRANSACTION", "DATABASE", "DB_KEY", "DEBUG", "DESCENDING", "DO", "ECHO", "EDIT", "ENTRY_POINT", "EVENT", "EXIT", "EXTERN", "FILE", "FILTER", "FREE_IT", "FUNCTION", "GDSCODE", "GENERATOR", "GEN_ID", "GLOBAL", "GOTO", "GROUP_COMMIT_WAIT", "GROUP_COMMIT_WAIT_TIME", "HELP", "IF", "INACTIVE", "INDEX", "INIT", "INPUT_TYPE", "ISQL", "LC_MESSAGES", "LC_TYPE", "LEV", "LOGFILE", "LOG_BUFFER_SIZE", "LOG_BUF_SIZE", "LONG", "MANUAL", "MAXIMUM", "MAXIMUM_SEGMENT", "MAX_SEGMENT", "MERGE", "MESSAGE", "MINUTE", "MODULE_NAME", "NOAUTO", "NUM_LOG_BUFS", "NUM_LOG_BUFFERS", "OUTPUT_TYPE", "OVERFLOW", "PAGE", "PAGELENGTH", "PAGES", "PAGE_SIZE", "PARAMETER", "PASSWORD", "PLAN", "POST_EVENT", "PROCEDURE", "PROTECTED", "QUIT", "RAW_PARTITIONS", "RDB$DB_KEY", "RECORD_VERSION", "RECREATE", "RELEASE", "RESERV", "RESERVING", "RETAIN", "RETURN", "RETURNING_VALUES", "RETURNS", "ROLE", "RUNTIME", "SAVEPOINT", "SEGMENT", "SHADOW", "SHARED", "SHELL", "SHOW", "SINGULAR", "SNAPSHOT", "SORT", "SQLWARNING", "STABILITY", "START", "STARTING", "STARTS", "STATEMENT", "STATIC", "STATISTICS", "SUB_TYPE", "SUSPEND", "TERMINATOR", "TRIGGER", "VARIABLE", "VERSION", "WAIT", "WEEKDAY", "WHILE"));
        this.binaryTypeName = "BLOB";
        this.bitTypeName = "SMALLINT";
        this.charTypeName = "CHAR(1)";
        this.clobTypeName = "BLOB SUB_TYPE 1";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.floatTypeName = "DOUBLE PRECISION";
        this.longVarbinaryTypeName = "BLOB";
        this.longVarcharTypeName = "BLOB SUB_TYPE 1";
        this.realTypeName = "FLOAT";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "SMALLINT";
        this.varbinaryTypeName = "BLOB";
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithOuterJoin = false;
        this.supportsLockingWithInnerJoin = false;
        this.forUpdateClause = "FOR UPDATE WITH LOCK";
        this.supportsQueryTimeout = false;
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        this.firebirdVersion = this.determineFirebirdVersion(conn);
        this.determineRangeSyntax();
        if (this.firebirdVersion == 21) {
            this.selectWordSet.add("WITH");
        }
        if (this.firebirdVersion != 21) {
            this.crossJoinClause = "JOIN";
            this.requiresConditionForCrossJoin = true;
        }
        if (this.firebirdVersion == 15) {
            this.stringLengthFunction = "STRLEN({0})";
            this.trimLeadingFunction = "LTRIM({0})";
            this.trimTrailingFunction = "RTRIM({0})";
            this.trimBothFunction = "LTRIM(RTRIM({0}))";
            this.alterSequenceSQL = this.alterSequenceSQLFB15;
            this.createSequenceSQL = this.createSequenceSQLFB15;
            this.nextSequenceQuery = this.nextSequenceQueryFB15;
        }
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (RANGE_SYNTAX_FIRST_SKIP.equals(this.rangeSyntax)) {
            if (end != Long.MAX_VALUE) {
                buf.append(" FIRST ").appendValue(end - start);
            }
            if (start != 0L) {
                buf.append(" SKIP ").appendValue(start);
            }
            return;
        }
        buf.append(" ROWS ");
        if (start == 0L) {
            buf.appendValue(end);
            return;
        }
        buf.appendValue(start + 1L).append(" TO ");
        if (end == Long.MAX_VALUE) {
            buf.appendValue(this.maxRowNumberInRange);
        } else {
            buf.appendValue(end);
        }
    }

    protected int determineFirebirdVersion(Connection con) throws SQLException {
        int min;
        int maj;
        block7: {
            if (this.firebirdVersion != 0) {
                return this.firebirdVersion;
            }
            DatabaseMetaData metaData = con.getMetaData();
            maj = 0;
            min = 0;
            if (this.isJDBC3) {
                maj = metaData.getDatabaseMajorVersion();
                min = metaData.getDatabaseMinorVersion();
            } else {
                try {
                    String productVersion = metaData.getDatabaseProductVersion();
                    Pattern p = Pattern.compile(".*-V(\\d)\\.(\\d)\\..*", 2);
                    Matcher m = p.matcher(productVersion);
                    m.matches();
                    String majString = m.group(1);
                    String minString = m.group(2);
                    maj = Integer.parseInt(majString);
                    min = Integer.parseInt(minString);
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block7;
                    this.log.warn(e.toString(), e);
                }
            }
        }
        if (maj < 2) {
            return 15;
        }
        if (maj == 2 && min == 0) {
            return 20;
        }
        return 21;
    }

    protected void determineRangeSyntax() {
        if (this.rangeSyntax == null) {
            this.rangeSyntax = this.firebirdVersion == 15 ? RANGE_SYNTAX_FIRST_SKIP : RANGE_SYNTAX_ROWS;
        }
        this.rangePosition = RANGE_SYNTAX_FIRST_SKIP.equals(this.rangeSyntax) ? 1 : 0;
    }

    @Override
    public String getPlaceholderValueString(Column col) {
        return super.getPlaceholderValueString(col) + " AS " + this.getTypeName(col);
    }

    @Override
    protected String getTableNameForMetadata(String tableName) {
        return tableName == null ? "%" : this.getTableNameForMetadata(DBIdentifier.newTable(tableName));
    }

    @Override
    protected String getTableNameForMetadata(DBIdentifier tableName) {
        if (DBIdentifier.isNull(tableName)) {
            return "%";
        }
        return super.getTableNameForMetadata(tableName);
    }

    @Override
    protected String getColumnNameForMetadata(String columnName) {
        return columnName == null ? "%" : super.getColumnNameForMetadata(columnName);
    }

    @Override
    public String[] getDropColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " DROP " + this.getColumnDBName(column)};
    }

    @Override
    public String[] getCreateSequenceSQL(Sequence seq) {
        String seqName = this.checkNameLength(this.getFullName(seq), this.maxTableNameLength, "long-seq-name");
        String createSeq = MessageFormat.format(this.createSequenceSQL, seqName);
        if (seq.getInitialValue() == 0) {
            return new String[]{createSeq};
        }
        String alterSeq = MessageFormat.format(this.alterSequenceSQL, seqName, String.valueOf(seq.getInitialValue()));
        return new String[]{createSeq, alterSeq};
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder(this.sequenceSQL);
        if (sequenceName != null) {
            buf.append(this.sequenceNameSQL);
        }
        return buf.toString();
    }

    @Override
    protected Sequence newSequence(ResultSet sequenceMeta) throws SQLException {
        Sequence seq = super.newSequence(sequenceMeta);
        seq.setIdentifier(DBIdentifier.trim(seq.getIdentifier()));
        return seq;
    }

    @Override
    public String[] getDropSequenceSQL(Sequence seq) {
        if (this.firebirdVersion == 15) {
            return new String[]{this.dropSequenceSQLFB15 + this.getFullName(seq)};
        }
        return super.getDropSequenceSQL(seq);
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        throw new UnsupportedException(_loc.get("function-not-supported", this.getClass(), "LOCATE"));
    }

    @Override
    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        buf.append(this.substringFunctionName).append("(");
        str.appendTo(buf);
        buf.append(" FROM ");
        if (!(start.getValue() instanceof Number)) {
            throw new UnsupportedException(_loc.get("function-not-supported", this.getClass(), this.substringFunctionName + " with non-constants"));
        }
        long startLong = this.toLong(start);
        buf.append(Long.toString(startLong + 1L));
        if (end != null) {
            buf.append(" FOR ");
            if (start.getValue() instanceof Number && end.getValue() instanceof Number) {
                startLong = this.toLong(start);
                long endLong = this.toLong(end);
                buf.append(Long.toString(endLong - startLong));
            } else {
                throw new UnsupportedException(_loc.get("function-not-supported", this.getClass(), this.substringFunctionName + " with non-constants"));
            }
        }
        buf.append(")");
    }

    @Override
    protected String appendSize(Column col, String typeName) {
        if (this.firebirdVersion != 15) {
            return super.appendSize(col, typeName);
        }
        if (col.getType() == 12 && col.getSize() > this.indexedVarcharMaxSizeFB15 && col.getTable() != null) {
            ForeignKey[] foreignKeys;
            Unique[] uniques;
            Index[] indexes;
            if (col.isPrimaryKey()) {
                col.setSize(this.indexedVarcharMaxSizeFB15);
                return super.appendSize(col, typeName);
            }
            for (Index index : indexes = col.getTable().getIndexes()) {
                if (!index.containsColumn(col)) continue;
                col.setSize(this.indexedVarcharMaxSizeFB15);
                return super.appendSize(col, typeName);
            }
            for (Unique unique : uniques = col.getTable().getUniques()) {
                if (!unique.containsColumn(col)) continue;
                col.setSize(this.indexedVarcharMaxSizeFB15);
                return super.appendSize(col, typeName);
            }
            for (ForeignKey foreignKey : foreignKeys = col.getTable().getForeignKeys()) {
                if (!foreignKey.containsColumn(col)) continue;
                col.setSize(this.indexedVarcharMaxSizeFB15);
                return super.appendSize(col, typeName);
            }
        }
        return super.appendSize(col, typeName);
    }

    @Override
    protected Boolean matchErrorState(int subtype, Set<String> errorStates, SQLException ex) {
        int errorCode = ex.getErrorCode();
        return errorStates.contains(String.valueOf(errorCode)) ? Boolean.FALSE : null;
    }
}

