/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericResultObjectProvider
implements ResultObjectProvider {
    private final ClassMapping _mapping;
    private final JDBCStore _store;
    private final JDBCFetchConfiguration _fetch;
    private final Result _res;

    public GenericResultObjectProvider(Class<?> pcClass, JDBCStore store, JDBCFetchConfiguration fetch, Result res) {
        this(store.getConfiguration().getMappingRepositoryInstance().getMapping(pcClass, store.getContext().getClassLoader(), true), store, fetch, res);
    }

    public GenericResultObjectProvider(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch, Result res) {
        this._mapping = mapping;
        this._store = store;
        this._fetch = fetch == null ? store.getFetchConfiguration() : fetch;
        this._res = res;
    }

    @Override
    public boolean supportsRandomAccess() {
        try {
            return this._res.supportsRandomAccess();
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void open() {
    }

    @Override
    public Object getResultObject() throws SQLException {
        return ((JDBCStoreManager)this._store).load(this._mapping, this._fetch, StoreContext.EXCLUDE_ALL, this._res);
    }

    @Override
    public boolean next() throws SQLException {
        return this._res.next();
    }

    @Override
    public boolean absolute(int pos) throws SQLException {
        return this._res.absolute(pos);
    }

    @Override
    public int size() throws SQLException {
        if (this._fetch.getLRSSize() == 0 || !this.supportsRandomAccess()) {
            return Integer.MAX_VALUE;
        }
        return this._res.size();
    }

    @Override
    public void reset() {
        throw new UnsupportedException();
    }

    @Override
    public void close() {
        this._res.close();
    }

    @Override
    public void handleCheckedException(Exception e) {
        if (e instanceof SQLException) {
            throw SQLExceptions.getStore((SQLException)e, this._store.getDBDictionary(), this._fetch.getReadLockLevel());
        }
        throw new StoreException(e);
    }
}

