/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.writebehind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.writebehind.WriteBehindCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteBehindStoreManager
extends DelegatingStoreManager {
    protected Set<Class<?>> includedTypes;
    protected Set<Class<?>> excludedTypes;
    protected boolean _cacheInserts = true;
    protected boolean _cacheUpdates = true;
    protected boolean _cacheDeletes = true;
    public static final int OP_INSERT = 1;
    public static final int OP_DELETE = 2;
    public static final int OP_UPDATE = 3;
    WriteBehindCache _cache;
    Collection<OpenJPAStateManager> inFlightSMs = new ArrayList<OpenJPAStateManager>();

    public WriteBehindStoreManager(StoreManager store) {
        this(store, null);
    }

    public WriteBehindStoreManager(StoreManager store, WriteBehindCache wbCache) {
        super(store);
        this._cache = wbCache;
    }

    @Override
    public Collection<Exception> flush(Collection<OpenJPAStateManager> sms) {
        LinkedHashSet<OpenJPAStateManager> passingThrough = null;
        for (OpenJPAStateManager sm : sms) {
            if (this.cacheAble(sm)) {
                PCState newState = sm.getPCState();
                if (newState == PCState.PDELETEDFLUSHED) {
                    newState = PCState.PDELETED;
                }
                this.inFlightSMs.add(new StateManagerImpl((StateManagerImpl)sm, newState));
                continue;
            }
            if (passingThrough == null) {
                passingThrough = new LinkedHashSet<OpenJPAStateManager>();
            }
            passingThrough.add(sm);
        }
        Collection<Object> rval = passingThrough != null ? this.getDelegate().flush(passingThrough) : new ArrayList();
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            super.commit();
            this._cache.add(this.inFlightSMs);
            Object var2_1 = null;
            this.inFlightSMs.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.inFlightSMs.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            super.rollback();
            Object var2_1 = null;
            this.inFlightSMs.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.inFlightSMs.clear();
            throw throwable;
        }
    }

    public Collection<Exception> flushBehind(Collection<OpenJPAStateManager> sms) {
        return super.flush(sms);
    }

    public boolean cacheAble(OpenJPAStateManager sm) {
        boolean rval = false;
        switch (this.getOperation(sm)) {
            case 1: {
                if (!this._cacheInserts) break;
                rval = true;
                break;
            }
            case 2: {
                if (!this._cacheDeletes) break;
                rval = true;
                break;
            }
            case 3: {
                if (!this._cacheUpdates) break;
                rval = true;
                break;
            }
            default: {
                rval = false;
            }
        }
        return rval;
    }

    protected int getOperation(OpenJPAStateManager sm) {
        int rval = -1;
        if (sm.isDirty()) {
            rval = sm.isNew() ? 1 : (sm.isDeleted() ? 2 : 3);
        }
        return rval;
    }
}

