/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import javax.persistence.LockModeType;

public class MixedLockLevelsHelper {
    public static int toLockLevel(LockModeType mode) {
        if (mode == null || mode == LockModeType.NONE) {
            return 0;
        }
        if (mode == LockModeType.READ) {
            return 10;
        }
        if (mode == LockModeType.OPTIMISTIC) {
            return 15;
        }
        if (mode == LockModeType.WRITE) {
            return 20;
        }
        if (mode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
            return 25;
        }
        if (mode == LockModeType.PESSIMISTIC_READ) {
            return 30;
        }
        if (mode == LockModeType.PESSIMISTIC_WRITE) {
            return 40;
        }
        return 50;
    }

    public static LockModeType fromLockLevel(int level) {
        if (level < 10) {
            return LockModeType.NONE;
        }
        if (level < 15) {
            return LockModeType.READ;
        }
        if (level < 20) {
            return LockModeType.OPTIMISTIC;
        }
        if (level < 25) {
            return LockModeType.WRITE;
        }
        if (level < 30) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (level < 40) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (level < 50) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        return LockModeType.PESSIMISTIC_FORCE_INCREMENT;
    }
}

