/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.TemporaryClassLoader;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.BCField;
import serp.bytecode.Code;
import serp.bytecode.FieldInstruction;
import serp.bytecode.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J2DoPrivHelper {
    private static String lineSeparator = null;
    private static String pathSeparator = null;

    public static final String getLineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        return lineSeparator;
    }

    public static final String getPathSeparator() {
        if (pathSeparator == null) {
            pathSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("path.separator");
                }
            });
        }
        return pathSeparator;
    }

    public static final PrivilegedAction<Object> setAccessibleAction(final AccessibleObject aObj, final boolean flag) {
        return new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                aObj.setAccessible(flag);
                return null;
            }
        };
    }

    public static final PrivilegedExceptionAction<Class<?>> getForNameAction(final String className, final boolean initializeBoolean, final ClassLoader classLoader) {
        return new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws ClassNotFoundException {
                return Class.forName(className, initializeBoolean, classLoader);
            }
        };
    }

    public static final PrivilegedAction<ClassLoader> getClassLoaderAction(final Class<?> clazz) {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        };
    }

    public static final PrivilegedExceptionAction<Field> getDeclaredFieldAction(final Class<?> clazz, final String name) {
        return new PrivilegedExceptionAction<Field>(){

            @Override
            public Field run() throws NoSuchFieldException {
                return clazz.getDeclaredField(name);
            }
        };
    }

    public static final PrivilegedAction<Field[]> getDeclaredFieldsAction(final Class<?> clazz) {
        return new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        };
    }

    public static final PrivilegedExceptionAction<Method> getDeclaredMethodAction(final Class<?> clazz, final String name, final Class<?>[] parameterTypes) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
        };
    }

    public static final PrivilegedAction<Method[]> getDeclaredMethodsAction(final Class<?> clazz) {
        return new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
    }

    public static final PrivilegedAction<URL> getResourceAction(final Class<?> clazz, final String resource) {
        return new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return clazz.getResource(resource);
            }
        };
    }

    public static final <T> PrivilegedExceptionAction<T> newInstanceAction(final Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws IllegalAccessException, InstantiationException {
                if (!Modifier.isAbstract(clazz.getModifiers())) {
                    return clazz.newInstance();
                }
                try {
                    return clazz.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    throw new InstantiationException(t.toString());
                }
            }
        };
    }

    public static final PrivilegedAction<ClassLoader> getParentAction(final ClassLoader loader) {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return loader.getParent();
            }
        };
    }

    public static final PrivilegedAction<URL> getResourceAction(final ClassLoader loader, final String resource) {
        return new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return loader.getResource(resource);
            }
        };
    }

    public static final PrivilegedExceptionAction<Enumeration<URL>> getResourcesAction(final ClassLoader loader, final String resource) throws IOException {
        return new PrivilegedExceptionAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() throws IOException {
                return loader.getResources(resource);
            }
        };
    }

    public static final PrivilegedAction<ClassLoader> getSystemClassLoaderAction() {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        };
    }

    public static final PrivilegedAction<Boolean> deleteAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.delete() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final PrivilegedAction<Boolean> existsAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return f.exists() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (NullPointerException npe) {
                    return Boolean.FALSE;
                }
            }
        };
    }

    public static final PrivilegedAction<Boolean> deleteOnExitAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                f.deleteOnExit();
                return Boolean.TRUE;
            }
        };
    }

    public static final PrivilegedAction<File> getAbsoluteFileAction(final File f) {
        return new PrivilegedAction<File>(){

            @Override
            public File run() {
                return f.getAbsoluteFile();
            }
        };
    }

    public static final PrivilegedAction<String> getAbsolutePathAction(final File f) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return f.getAbsolutePath();
            }
        };
    }

    public static final PrivilegedExceptionAction<String> getCanonicalPathAction(final File f) throws IOException {
        return new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException {
                return f.getCanonicalPath();
            }
        };
    }

    public static final PrivilegedAction<Boolean> isDirectoryAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final PrivilegedAction<Boolean> isFileAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.isFile() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final PrivilegedAction<Long> lengthAction(final File f) {
        return new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new Long(f.length());
            }
        };
    }

    public static final PrivilegedAction<File[]> listFilesAction(final File f) {
        return new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return f.listFiles();
            }
        };
    }

    public static final PrivilegedAction<Boolean> mkdirsAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.mkdirs() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final PrivilegedAction<Boolean> renameToAction(final File from, final File to) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return from.renameTo(to) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final PrivilegedExceptionAction<URL> toURLAction(final File file) throws MalformedURLException {
        return new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws MalformedURLException {
                return file.toURL();
            }
        };
    }

    public static final PrivilegedExceptionAction<FileInputStream> newFileInputStreamAction(final File f) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws FileNotFoundException {
                return new FileInputStream(f);
            }
        };
    }

    public static final PrivilegedExceptionAction<FileOutputStream> newFileOutputStreamAction(final File f) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws FileNotFoundException {
                return new FileOutputStream(f);
            }
        };
    }

    public static final PrivilegedExceptionAction<FileOutputStream> newFileOutputStreamAction(final String f, final boolean append) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws FileNotFoundException {
                return new FileOutputStream(f, append);
            }
        };
    }

    public static final PrivilegedExceptionAction<InetAddress> getByNameAction(final String hostname) throws UnknownHostException {
        return new PrivilegedExceptionAction<InetAddress>(){

            @Override
            public InetAddress run() throws UnknownHostException {
                return InetAddress.getByName(hostname);
            }
        };
    }

    public static final PrivilegedExceptionAction<Socket> newSocketAction(final InetAddress host, final int port) throws IOException {
        return new PrivilegedExceptionAction<Socket>(){

            @Override
            public Socket run() throws IOException {
                return new Socket(host, port);
            }
        };
    }

    public static final PrivilegedExceptionAction<ServerSocket> newServerSocketAction(final int port) throws IOException {
        return new PrivilegedExceptionAction<ServerSocket>(){

            @Override
            public ServerSocket run() throws IOException {
                return new ServerSocket(port);
            }
        };
    }

    public static final PrivilegedExceptionAction<Socket> acceptAction(final ServerSocket ss) throws IOException {
        return new PrivilegedExceptionAction<Socket>(){

            @Override
            public Socket run() throws IOException {
                return ss.accept();
            }
        };
    }

    public static final PrivilegedAction<Properties> getPropertiesAction() {
        return new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
    }

    public static final PrivilegedAction<String> getPropertyAction(final String name) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
    }

    public static final PrivilegedAction<ClassLoader> getContextClassLoaderAction() {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
    }

    public static final PrivilegedAction<Boolean> setContextClassLoaderAction(final ClassLoader loader) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Thread.currentThread().setContextClassLoader(loader);
                return Boolean.TRUE;
            }
        };
    }

    public static final PrivilegedAction<Thread> newDaemonThreadAction(final Runnable target, final String name) {
        return new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(target, name);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static final PrivilegedExceptionAction<InputStream> openStreamAction(final URL url) throws IOException {
        return new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return url.openStream();
            }
        };
    }

    public static final PrivilegedExceptionAction<Object> getContentAction(final URLConnection con) throws IOException {
        return new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                return con.getContent();
            }
        };
    }

    public static final PrivilegedExceptionAction<ZipFile> newZipFileAction(final File f) throws IOException {
        return new PrivilegedExceptionAction<ZipFile>(){

            @Override
            public ZipFile run() throws IOException {
                return new ZipFile(f);
            }
        };
    }

    public static final PrivilegedAction<Code> newCodeAction() {
        return new PrivilegedAction<Code>(){

            @Override
            public Code run() {
                return new Code();
            }
        };
    }

    public static final PrivilegedAction<TemporaryClassLoader> newTemporaryClassLoaderAction(final ClassLoader parent) {
        return new PrivilegedAction<TemporaryClassLoader>(){

            @Override
            public TemporaryClassLoader run() {
                return new TemporaryClassLoader(parent);
            }
        };
    }

    public static final PrivilegedAction<MultiClassLoader> newMultiClassLoaderAction() {
        return new PrivilegedAction<MultiClassLoader>(){

            @Override
            public MultiClassLoader run() {
                return new MultiClassLoader();
            }
        };
    }

    public static final PrivilegedAction<BCClassLoader> newBCClassLoaderAction(final Project project, final ClassLoader parent) {
        return new PrivilegedAction<BCClassLoader>(){

            @Override
            public BCClassLoader run() {
                return new BCClassLoader(project, parent);
            }
        };
    }

    public static final PrivilegedAction<BCClassLoader> newBCClassLoaderAction(final Project project) {
        return new PrivilegedAction<BCClassLoader>(){

            @Override
            public BCClassLoader run() {
                return new BCClassLoader(project);
            }
        };
    }

    public static final PrivilegedExceptionAction<Object> bCClassWrite(final BCClass bc, final File f) throws IOException {
        return new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                bc.write(f);
                return null;
            }
        };
    }

    public static final PrivilegedAction<BCField[]> getBCClassFieldsAction(final BCClass bcClass, final String fieldName) {
        return new PrivilegedAction<BCField[]>(){

            @Override
            public BCField[] run() {
                return bcClass.getFields(fieldName);
            }
        };
    }

    public static final PrivilegedAction<BCField> getFieldInstructionFieldAction(final FieldInstruction instruction) {
        return new PrivilegedAction<BCField>(){

            @Override
            public BCField run() {
                return instruction.getField();
            }
        };
    }

    public static final PrivilegedAction<BCClass> loadProjectClassAction(final Project project, final Class<?> clazz) {
        return new PrivilegedAction<BCClass>(){

            @Override
            public BCClass run() {
                return project.loadClass(clazz);
            }
        };
    }

    public static final PrivilegedAction<BCClass> loadProjectClassAction(final Project project, final String clazzName) {
        return new PrivilegedAction<BCClass>(){

            @Override
            public BCClass run() {
                return project.loadClass(clazzName);
            }
        };
    }

    public static final PrivilegedAction<Annotation[]> getAnnotationsAction(final AnnotatedElement element) {
        return new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getAnnotations();
            }
        };
    }

    public static final PrivilegedAction<Annotation[]> getDeclaredAnnotationsAction(final AnnotatedElement element) {
        return new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getDeclaredAnnotations();
            }
        };
    }

    public static final PrivilegedAction<Boolean> isAnnotationPresentAction(final AnnotatedElement element, final Class<? extends Annotation> annotationClazz) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return element.isAnnotationPresent(annotationClazz) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static final <T extends Annotation> PrivilegedAction<T> getAnnotationAction(final AnnotatedElement element, final Class<T> annotationClazz) {
        return new PrivilegedAction<T>(){

            @Override
            public T run() {
                return element.getAnnotation(annotationClazz);
            }
        };
    }

    public static final <T> PrivilegedAction<Set<ConstraintViolation<T>>> validateAction(final Validator validator, final T arg0, final Class<?>[] groups) {
        return new PrivilegedAction<Set<ConstraintViolation<T>>>(){

            @Override
            public Set<ConstraintViolation<T>> run() {
                return validator.validate(arg0, groups);
            }
        };
    }

    public static final <T> PrivilegedAction<ValidatorFactory> buildDefaultValidatorFactoryAction() {
        return new PrivilegedAction<ValidatorFactory>(){

            @Override
            public ValidatorFactory run() {
                return Validation.buildDefaultValidatorFactory();
            }
        };
    }
}

