/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.OrderingMergedResultObjectProvider;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.ResultPacker;
import org.apache.openjpa.kernel.ResultShape;
import org.apache.openjpa.kernel.ResultShapePacker;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.Constant;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.ListResultList;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.NoResultException;
import org.apache.openjpa.util.NonUniqueResultException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class QueryImpl
implements Query {
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private final String _language;
    private final StoreQuery _storeQuery;
    private final transient BrokerImpl _broker;
    private final transient Log _log;
    private transient ClassLoader _loader = null;
    private ReentrantLock _lock;
    private Class<?> _class = null;
    private boolean _subclasses = true;
    private boolean _readOnly = false;
    private String _query = null;
    private String _params = null;
    private transient Compilation _compiled = null;
    private transient boolean _compiling = false;
    private transient ResultPacker _packer = null;
    private transient Collection<?> _collection = null;
    private transient Extent _extent = null;
    private Map<String, FilterListener> _filtListeners = null;
    private Map<String, AggregateListener> _aggListeners = null;
    private FetchConfiguration _fc = null;
    private boolean _ignoreChanges = false;
    private Class<?> _resultMappingScope = null;
    private String _resultMappingName = null;
    private Boolean _unique = null;
    private Class<?> _resultClass = null;
    private transient long _startIdx = 0L;
    private transient long _endIdx = Long.MAX_VALUE;
    private transient boolean _rangeSet = false;
    private final transient Collection<RemoveOnCloseResultList> _resultLists = new ReferenceHashSet(2);
    private boolean _printParameters = false;

    public QueryImpl(Broker broker, String language, StoreQuery storeQuery) {
        this._broker = (BrokerImpl)broker;
        this._language = language;
        this._storeQuery = storeQuery;
        this._fc = (FetchConfiguration)broker.getFetchConfiguration().clone();
        this._log = broker.getConfiguration().getLog("openjpa.Query");
        this._storeQuery.setContext(this);
        this._printParameters = this._broker.getPrintParameters();
        if (this._broker != null && this._broker.getMultithreaded()) {
            this._lock = new ReentrantLock();
        }
    }

    public StoreQuery getStoreQuery() {
        return this._storeQuery;
    }

    @Override
    public Broker getBroker() {
        return this._broker;
    }

    @Override
    public Query getQuery() {
        return this;
    }

    @Override
    public StoreContext getStoreContext() {
        return this._broker;
    }

    @Override
    public String getLanguage() {
        return this._language;
    }

    @Override
    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    @Override
    public String getQueryString() {
        return this._query;
    }

    @Override
    public boolean getIgnoreChanges() {
        this.assertOpen();
        return this._ignoreChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoreChanges(boolean flag) {
        this.lock();
        try {
            this.assertOpen();
            this._ignoreChanges = flag;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        this.assertOpen();
        return this._readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean flag) {
        this.lock();
        try {
            this.assertOpen();
            this._readOnly = flag;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterListener(FilterListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._filtListeners == null) {
                this._filtListeners = new HashMap<String, FilterListener>(5);
            }
            this._filtListeners.put(listener.getTag(), listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterListener(FilterListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._filtListeners != null) {
                this._filtListeners.remove(listener.getTag());
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Collection<FilterListener> getFilterListeners() {
        if (this._filtListeners == null) {
            return Collections.emptyList();
        }
        return this._filtListeners.values();
    }

    @Override
    public FilterListener getFilterListener(String tag) {
        FilterListener listen;
        if (this._filtListeners != null && (listen = this._filtListeners.get(tag)) != null) {
            return listen;
        }
        FilterListener[] confListeners = this._broker.getConfiguration().getFilterListenerInstances();
        for (int i = 0; i < confListeners.length; ++i) {
            if (!confListeners[i].getTag().equals(tag)) continue;
            return confListeners[i];
        }
        return this._storeQuery.getFilterListener(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAggregateListener(AggregateListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._aggListeners == null) {
                this._aggListeners = new HashMap<String, AggregateListener>(5);
            }
            this._aggListeners.put(listener.getTag(), listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAggregateListener(AggregateListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._aggListeners != null) {
                this._aggListeners.remove(listener.getTag());
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Collection<AggregateListener> getAggregateListeners() {
        if (this._aggListeners == null) {
            return Collections.emptyList();
        }
        return this._aggListeners.values();
    }

    @Override
    public AggregateListener getAggregateListener(String tag) {
        AggregateListener listen;
        if (this._aggListeners != null && (listen = this._aggListeners.get(tag)) != null) {
            return listen;
        }
        AggregateListener[] confListeners = this._broker.getConfiguration().getAggregateListenerInstances();
        for (int i = 0; i < confListeners.length; ++i) {
            if (!confListeners[i].getTag().equals(tag)) continue;
            return confListeners[i];
        }
        return this._storeQuery.getAggregateListener(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extent getCandidateExtent() {
        this.lock();
        try {
            Class cls = this.getCandidateType();
            if (this._extent == null && this._collection == null && this._broker != null && cls != null) {
                this._extent = this._broker.newExtent(cls, this._subclasses);
                this._extent.setIgnoreChanges(this._ignoreChanges);
            } else if (this._extent != null && this._extent.getIgnoreChanges() != this._ignoreChanges && cls != null) {
                this._extent = this._broker.newExtent(cls, this._extent.hasSubclasses());
                this._extent.setIgnoreChanges(this._ignoreChanges);
            }
            Extent extent = this._extent;
            return extent;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCandidateExtent(Extent candidateExtent) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (candidateExtent == this._extent) {
                return;
            }
            if (candidateExtent == null) {
                this._extent = null;
                return;
            }
            this._extent = candidateExtent;
            this._collection = null;
            boolean invalidate = false;
            if (this._extent.getElementType() != this._class) {
                this._class = this._extent.getElementType();
                this._loader = null;
                invalidate = true;
            }
            if (this._extent.hasSubclasses() != this._subclasses) {
                this._subclasses = this._extent.hasSubclasses();
                invalidate = true;
            }
            if (invalidate) {
                this.invalidateCompilation();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Collection<?> getCandidateCollection() {
        this.assertOpen();
        return this._collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCandidateCollection(Collection<?> candidateCollection) {
        if (!this._storeQuery.supportsInMemoryExecution()) {
            throw new UnsupportedException(_loc.get("query-nosupport", (Object)this._language));
        }
        this.lock();
        try {
            this.assertOpen();
            this._collection = candidateCollection;
            if (this._collection != null) {
                this._extent = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getCandidateType() {
        this.lock();
        try {
            this.assertOpen();
            if (this._class != null || this._compiled != null || this._query == null || this._broker == null) {
                Class<?> clazz = this._class;
                return clazz;
            }
            this.compileForCompilation();
            Class<?> clazz = this._class;
            return clazz;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCandidateType(Class candidateClass, boolean subs) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._class = candidateClass;
            this._subclasses = subs;
            this._loader = null;
            this.invalidateCompilation();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean hasSubclasses() {
        return this._subclasses;
    }

    @Override
    public String getResultMappingName() {
        this.assertOpen();
        return this._resultMappingName;
    }

    public Class getResultMappingScope() {
        this.assertOpen();
        return this._resultMappingScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResultMapping(Class<?> scope, String name) {
        this.lock();
        try {
            this.assertOpen();
            this._resultMappingScope = scope;
            this._resultMappingName = name;
            this._packer = null;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnique() {
        this.lock();
        try {
            StoreQuery.Executor ex;
            this.assertOpen();
            if (this._unique != null) {
                boolean bl = this._unique;
                return bl;
            }
            if (this._query == null && this._language.endsWith("JPQL") || this._compiling || this._broker == null) {
                boolean bl = false;
                return bl;
            }
            if (this._compiled == null) {
                this.compileForCompilation();
                if (this._unique != null) {
                    boolean bl = this._unique;
                    return bl;
                }
            }
            if (!(ex = this.compileForExecutor()).isAggregate(this._storeQuery)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !ex.hasGrouping(this._storeQuery);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isParsedQuery() {
        return this.getQueryString() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnique(boolean unique) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._unique = unique ? Boolean.TRUE : Boolean.FALSE;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getResultType() {
        this.lock();
        try {
            this.assertOpen();
            if (this._resultClass != null || this._compiled != null || this._query == null || this._broker == null) {
                Class<?> clazz = this._resultClass;
                return clazz;
            }
            this.compileForCompilation();
            Class<?> clazz = this._resultClass;
            return clazz;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultType(Class cls) {
        this.lock();
        try {
            this.assertOpen();
            this._resultClass = cls;
            this._packer = null;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long getStartRange() {
        this.assertOpen();
        return this._startIdx;
    }

    @Override
    public long getEndRange() {
        this.assertOpen();
        return this._endIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRange(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new UserException(_loc.get("invalid-range", (Object)String.valueOf(start), (Object)String.valueOf(end)));
        }
        if (end - start > Integer.MAX_VALUE && end != Long.MAX_VALUE) {
            throw new UserException(_loc.get("range-too-big", (Object)String.valueOf(start), (Object)String.valueOf(end)));
        }
        this.lock();
        try {
            this.assertOpen();
            this._startIdx = start;
            this._endIdx = end;
            this._rangeSet = true;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParameterDeclaration() {
        this.lock();
        try {
            this.assertOpen();
            if (this._params != null || this._compiled != null || this._compiling || this._broker == null) {
                String string = this._params;
                return string;
            }
            this.compileForCompilation();
            String string = this._params;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void declareParameters(String params) {
        if (!this._storeQuery.supportsParameterDeclarations()) {
            throw new UnsupportedException(_loc.get("query-nosupport", (Object)this._language));
        }
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._params = StringUtils.trimToNull((String)params);
            this.invalidateCompilation();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile() {
        this.lock();
        try {
            this.assertOpen();
            StoreQuery.Executor ex = this.compileForExecutor();
            this.getResultPacker(this._storeQuery, ex);
            ex.validate(this._storeQuery);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCompilation() {
        this.lock();
        try {
            Object object = this.compileForCompilation().storeData;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    private Compilation compileForCompilation() {
        if (this._compiled != null || this._compiling) {
            return this._compiled;
        }
        this.assertNotSerialized();
        this.assertOpen();
        boolean readOnly = this._readOnly;
        this._readOnly = false;
        this._compiling = true;
        try {
            Compilation compilation = this._compiled = this.compilationFromCache();
            return compilation;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this._compiling = false;
            this._readOnly = readOnly;
        }
    }

    protected Compilation compilationFromCache() {
        Map compCache = this._broker.getConfiguration().getQueryCompilationCacheInstance();
        if (compCache == null || !this.isParsedQuery()) {
            return this.newCompilation();
        }
        CompilationKey key = new CompilationKey();
        key.queryType = this._storeQuery.getClass();
        key.candidateType = this.getCandidateType();
        key.subclasses = this.hasSubclasses();
        key.query = this.getQueryString();
        key.language = this.getLanguage();
        key.storeKey = this._storeQuery.newCompilationKey();
        Compilation comp = (Compilation)compCache.get(key);
        boolean cache = false;
        if (comp == null) {
            comp = this.newCompilation();
            cache = comp.storeData != null;
        } else {
            this._storeQuery.populateFromCompilation(comp.storeData);
        }
        if (cache) {
            compCache.put(key, comp);
        }
        return comp;
    }

    private Compilation newCompilation() {
        Compilation comp = new Compilation();
        comp.storeData = this._storeQuery.newCompilation();
        this._storeQuery.populateFromCompilation(comp.storeData);
        return comp;
    }

    private StoreQuery.Executor compileForExecutor() {
        Compilation comp = this.compileForCompilation();
        if (this._collection == null) {
            if (comp.datastore != null) {
                return comp.datastore;
            }
            if (comp.memory != null) {
                return comp.memory;
            }
            if (this._storeQuery.supportsDataStoreExecution()) {
                return this.compileForDataStore(comp);
            }
            return this.compileForInMemory(comp);
        }
        if (comp.memory != null) {
            return comp.memory;
        }
        if (comp.datastore != null) {
            return comp.datastore;
        }
        if (this._storeQuery.supportsInMemoryExecution()) {
            return this.compileForInMemory(comp);
        }
        return this.compileForDataStore(comp);
    }

    private StoreQuery.Executor compileForDataStore(Compilation comp) {
        if (comp.datastore == null) {
            comp.datastore = this.createExecutor(false);
        }
        return comp.datastore;
    }

    private StoreQuery.Executor compileForInMemory(Compilation comp) {
        if (comp.memory == null) {
            comp.memory = this.createExecutor(true);
        }
        return comp.memory;
    }

    private StoreQuery.Executor createExecutor(boolean inMem) {
        this.assertCandidateType();
        MetaDataRepository repos = this._broker.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(this._class, this._broker.getClassLoader(), false);
        ClassMetaData[] metas = this._class == null || this._storeQuery.supportsAbstractExecutors() ? new ClassMetaData[]{meta} : (this._subclasses && (meta == null || meta.isManagedInterface()) ? repos.getImplementorMetaDatas(this._class, this._broker.getClassLoader(), true) : (meta != null && (this._subclasses || meta.isMapped()) ? new ClassMetaData[]{meta} : StoreQuery.EMPTY_METAS));
        if (metas.length == 0) {
            throw new UserException(_loc.get("no-impls", this._class));
        }
        try {
            if (metas.length == 1) {
                if (inMem) {
                    return this._storeQuery.newInMemoryExecutor(metas[0], this._subclasses);
                }
                return this._storeQuery.newDataStoreExecutor(metas[0], this._subclasses);
            }
            StoreQuery.Executor[] es = new StoreQuery.Executor[metas.length];
            for (int i = 0; i < es.length; ++i) {
                es[i] = inMem ? this._storeQuery.newInMemoryExecutor(metas[i], true) : this._storeQuery.newDataStoreExecutor(metas[i], true);
            }
            return new MergedExecutor(es);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    private boolean invalidateCompilation() {
        if (this._compiling) {
            return false;
        }
        this._storeQuery.invalidateCompilation();
        this._compiled = null;
        this._packer = null;
        return true;
    }

    @Override
    public Object execute() {
        return this.execute((Object[])null);
    }

    @Override
    public Object execute(Object[] params) {
        return this.execute(1, params);
    }

    public Object execute(Map params) {
        return this.execute(1, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execute(int operation, Object[] params) {
        if (params == null) {
            params = StoreQuery.EMPTY_OBJECTS;
        }
        this.lock();
        try {
            this.assertNotSerialized();
            this._broker.beginOperation(true);
            try {
                this.assertOpen();
                this._broker.assertNontransactionalRead();
                Compilation comp = this.compileForCompilation();
                StoreQuery.Executor ex = this.isInMemory(operation) ? this.compileForInMemory(comp) : this.compileForDataStore(comp);
                this.assertParameters(this._storeQuery, ex, params);
                if (this._log.isTraceEnabled()) {
                    this.logExecution(operation, ex.getOrderedParameterTypes(this._storeQuery), params);
                }
                if (operation == 1) {
                    Object object = this.execute(this._storeQuery, ex, params);
                    return object;
                }
                if (operation == 2) {
                    Number number = this.delete(this._storeQuery, ex, params);
                    return number;
                }
                if (operation == 3) {
                    Number number = this.update(this._storeQuery, ex, params);
                    return number;
                }
                throw new UnsupportedException();
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new UserException(e);
            }
            finally {
                this._broker.endOperation();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execute(int operation, Map params) {
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        this.lock();
        try {
            this._broker.beginOperation(true);
            try {
                Object[] arr;
                this.assertNotSerialized();
                this.assertOpen();
                this._broker.assertNontransactionalRead();
                Compilation comp = this.compileForCompilation();
                StoreQuery.Executor ex = this.isInMemory(operation) ? this.compileForInMemory(comp) : this.compileForDataStore(comp);
                this.assertParameters(this._storeQuery, ex, params);
                Object[] objectArray = arr = params.isEmpty() ? StoreQuery.EMPTY_OBJECTS : ex.toParameterArray(this._storeQuery, params);
                if (this._log.isTraceEnabled()) {
                    this.logExecution(operation, params);
                }
                if (operation == 1) {
                    Object object = this.execute(this._storeQuery, ex, arr);
                    return object;
                }
                if (operation == 2) {
                    Number number = this.delete(this._storeQuery, ex, arr);
                    return number;
                }
                if (operation == 3) {
                    Number number = this.update(this._storeQuery, ex, arr);
                    return number;
                }
                throw new UnsupportedException();
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new UserException(_loc.get("query-execution-error", (Object)this._query), (Throwable)e);
            }
            finally {
                this._broker.endOperation();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long deleteAll() {
        return this.deleteAll((Object[])null);
    }

    @Override
    public long deleteAll(Object[] params) {
        return ((Number)this.execute(2, params)).longValue();
    }

    public long deleteAll(Map params) {
        return ((Number)this.execute(2, params)).longValue();
    }

    @Override
    public long updateAll() {
        return this.updateAll((Object[])null);
    }

    @Override
    public long updateAll(Object[] params) {
        return ((Number)this.execute(3, params)).longValue();
    }

    public long updateAll(Map params) {
        return ((Number)this.execute(3, params)).longValue();
    }

    private boolean isInMemory(int operation) {
        boolean inMem;
        boolean bl = inMem = !this._storeQuery.supportsDataStoreExecution() || this._collection != null;
        if (!inMem && (!this._ignoreChanges || operation != 1) && this._broker.isActive() && this.isAccessPathDirty()) {
            int flush = this._fc.getFlushBeforeQueries();
            if ((flush == 0 || flush == 2 && this._broker.hasConnection() || operation != 1 || !this._storeQuery.supportsInMemoryExecution()) && this._broker.getConfiguration().supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                this._broker.flush();
            } else {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)_loc.get("force-in-mem", this._class));
                }
                inMem = true;
            }
        }
        if (inMem && !this._storeQuery.supportsInMemoryExecution()) {
            throw new InvalidStateException(_loc.get("cant-exec-inmem", (Object)this._language));
        }
        return inMem;
    }

    private Object execute(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        StoreQuery.Range range = new StoreQuery.Range(this._startIdx, this._endIdx);
        if (!this._rangeSet) {
            ex.getRange(q, params, range);
        }
        if (range.start >= range.end) {
            return this.emptyResult(q, ex);
        }
        range.lrs = this.isLRS(range.start, range.end);
        ResultObjectProvider rop = ex.executeQuery(q, params, range);
        try {
            return this.toResult(q, ex, rop, range);
        }
        catch (Exception e) {
            if (rop != null) {
                try {
                    rop.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private Number delete(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        this.assertBulkModify(q, ex, params);
        return ex.executeDelete(q, params);
    }

    @Override
    public Number deleteInMemory(StoreQuery q, StoreQuery.Executor executor, Object[] params) {
        try {
            Set<Object> o = this.execute(q, executor, params);
            if (!(o instanceof Collection)) {
                o = Collections.singleton(o);
            }
            int size = 0;
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                this._broker.delete(i.next(), null);
                ++size;
            }
            return size;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(e);
        }
    }

    private Number update(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        this.assertBulkModify(q, ex, params);
        return ex.executeUpdate(q, params);
    }

    @Override
    public Number updateInMemory(StoreQuery q, StoreQuery.Executor executor, Object[] params) {
        try {
            Set<Object> o = this.execute(q, executor, params);
            if (!(o instanceof Collection)) {
                o = Collections.singleton(o);
            }
            int size = 0;
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                this.updateInMemory(i.next(), params, q);
                ++size;
            }
            return size;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(e);
        }
    }

    private void updateInMemory(Object ob, Object[] params, StoreQuery q) {
        block14: for (Map.Entry e : this.getUpdates().entrySet()) {
            Object val;
            Path path = (Path)e.getKey();
            FieldMetaData fmd = path.last();
            OpenJPAStateManager sm = this._broker.getStateManager(ob);
            Object value = e.getValue();
            if (value instanceof Val) {
                val = ((Val)value).evaluate(ob, null, this.getStoreContext(), params);
            } else if (value instanceof Literal) {
                val = ((Literal)value).getValue();
            } else if (value instanceof Constant) {
                val = ((Constant)value).getValue(params);
            } else {
                try {
                    val = q.evaluate(value, ob, params, sm);
                }
                catch (UnsupportedException e1) {
                    throw new UserException(_loc.get("fail-to-get-update-value"));
                }
            }
            int i = fmd.getIndex();
            PersistenceCapable into = ImplHelper.toPersistenceCapable(ob, this._broker.getConfiguration());
            int set = 0;
            switch (fmd.getDeclaredTypeCode()) {
                case 0: {
                    sm.settingBooleanField(into, i, sm.fetchBooleanField(i), val == null ? false : (Boolean)val, set);
                    continue block14;
                }
                case 1: {
                    sm.settingByteField(into, i, sm.fetchByteField(i), val == null ? (byte)0 : ((Number)val).byteValue(), set);
                    continue block14;
                }
                case 2: {
                    sm.settingCharField(into, i, sm.fetchCharField(i), val == null ? (char)'\u0000' : val.toString().charAt(0), set);
                    continue block14;
                }
                case 3: {
                    sm.settingDoubleField(into, i, sm.fetchDoubleField(i), val == null ? 0.0 : ((Number)val).doubleValue(), set);
                    continue block14;
                }
                case 4: {
                    sm.settingFloatField(into, i, sm.fetchFloatField(i), val == null ? 0.0f : ((Number)val).floatValue(), set);
                    continue block14;
                }
                case 5: {
                    sm.settingIntField(into, i, sm.fetchIntField(i), val == null ? 0 : ((Number)val).intValue(), set);
                    continue block14;
                }
                case 6: {
                    sm.settingLongField(into, i, sm.fetchLongField(i), val == null ? 0L : ((Number)val).longValue(), set);
                    continue block14;
                }
                case 7: {
                    sm.settingShortField(into, i, sm.fetchShortField(i), val == null ? (short)0 : ((Number)val).shortValue(), set);
                    continue block14;
                }
                case 9: {
                    sm.settingStringField(into, i, sm.fetchStringField(i), val == null ? null : val.toString(), set);
                    continue block14;
                }
                case 8: 
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 29: 
                case 32: {
                    sm.settingObjectField(into, i, sm.fetchObjectField(i), val, set);
                    continue block14;
                }
            }
            throw new UserException(_loc.get("only-update-primitives"));
        }
    }

    private void logExecution(int op, OrderedMap<Object, Class<?>> types, Object[] params) {
        OrderedMap pmap = new OrderedMap();
        if (params.length > 0) {
            if (types != null && types.size() == params.length) {
                int i = 0;
                Iterator itr = types.keySet().iterator();
                while (itr.hasNext()) {
                    pmap.put(itr.next(), params[i++]);
                }
            } else {
                for (int i = 0; i < params.length; ++i) {
                    pmap.put((Object)String.valueOf(i), params[i]);
                }
            }
        }
        this.logExecution(op, (Map<Object, Object>)pmap);
    }

    private void logExecution(int op, Map<Object, Object> params) {
        String s = this._query;
        if (StringUtils.isEmpty((String)s)) {
            s = this.toString();
        }
        String msg = "executing-query";
        if (!params.isEmpty()) {
            msg = "executing-query-with-params";
        }
        Object p = this._printParameters ? params : "?";
        this._log.trace((Object)_loc.get(msg, (Object)s, p));
    }

    private boolean isLRS(long start, long end) {
        long range = end - start;
        return this._fc.getFetchBatchSize() >= 0 && range > (long)this._fc.getFetchBatchSize() && (this._fc.getFetchBatchSize() != 0 || range > 50L);
    }

    protected Object toResult(StoreQuery q, StoreQuery.Executor ex, ResultObjectProvider rop, StoreQuery.Range range) throws Exception {
        ResultPacker packer;
        String[] aliases = ex.getProjectionAliases(q);
        if (!(ex.isPacking(q) || (packer = this.getResultPacker(q, ex)) == null && aliases.length != 1)) {
            rop = new PackingResultObjectProvider(rop, packer, aliases.length);
        }
        if (this._unique == Boolean.TRUE || aliases.length > 0 && !ex.hasGrouping(q) && ex.isAggregate(q)) {
            return this.singleResult(rop, range);
        }
        boolean detach = (this._broker.getAutoDetach() & 8) > 0 && !this._broker.isActive();
        boolean lrs = range.lrs && !ex.isAggregate(q) && !ex.hasGrouping(q);
        ListResultList res = new ListResultList(Collections.emptyList());
        try {
            res = !detach && lrs ? this._fc.newResultList(rop) : new ResultList(rop);
            res.setUserObject((Object)new Object[]{rop, ex});
            this._resultLists.add(this.decorateResultList((ResultList<?>)res));
        }
        catch (OpenJPAException e) {
            if (e.getFailedObject() == null) {
                e.setFailedObject(this.getQueryString());
            }
            throw e;
        }
        return res;
    }

    protected RemoveOnCloseResultList decorateResultList(ResultList<?> res) {
        return new RemoveOnCloseResultList(res);
    }

    private ResultPacker getResultPacker(StoreQuery q, StoreQuery.Executor ex) {
        Class<?> resultClass;
        if (this._packer != null) {
            return this._packer;
        }
        Class<?> clazz = resultClass = this._resultClass != null ? this._resultClass : ex.getResultClass(q);
        if (resultClass == null) {
            return null;
        }
        String[] aliases = ex.getProjectionAliases(q);
        ResultShape<?> shape = ex.getResultShape(q);
        if (shape != null) {
            this._packer = aliases.length == 0 ? new ResultShapePacker(new Class[]{this._class}, new String[]{""}, resultClass, shape) : new ResultShapePacker(ex.getProjectionTypes(q), aliases, resultClass, shape);
        } else if (aliases.length == 0) {
            this._packer = new ResultPacker(this._class, this.getAlias(), resultClass);
        } else if (resultClass != null) {
            Class<?>[] types = ex.getProjectionTypes(q);
            this._packer = new ResultPacker(types, aliases, resultClass);
        }
        return this._packer;
    }

    private Object emptyResult(StoreQuery q, StoreQuery.Executor ex) {
        if (this._unique == Boolean.TRUE || this._unique == null && !ex.hasGrouping(q) && ex.isAggregate(q)) {
            return null;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object singleResult(ResultObjectProvider rop, StoreQuery.Range range) throws Exception {
        rop.open();
        try {
            boolean next = rop.next();
            Object single = null;
            if (next) {
                single = rop.getResultObject();
                if (range.end != range.start + 1L && rop.next()) {
                    throw new NonUniqueResultException(_loc.get("not-unique", this._class, (Object)this._query));
                }
            } else if (this._unique == Boolean.TRUE) {
                throw new NoResultException(_loc.get("no-result", this._class, (Object)this._query));
            }
            if (this._unique == Boolean.FALSE) {
                if (!next) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                List<Object> list = Arrays.asList(single);
                return list;
            }
            Object object = single;
            return object;
        }
        finally {
            rop.close();
        }
    }

    private boolean isAccessPathDirty() {
        return QueryImpl.isAccessPathDirty(this._broker, this.getAccessPathMetaDatas());
    }

    public static boolean isAccessPathDirty(Broker broker, ClassMetaData[] accessMetas) {
        Collection persisted = broker.getPersistedTypes();
        Collection updated = broker.getUpdatedTypes();
        Collection deleted = broker.getDeletedTypes();
        if (persisted.isEmpty() && updated.isEmpty() && deleted.isEmpty()) {
            return false;
        }
        if (accessMetas.length == 0) {
            return true;
        }
        for (int i = 0; i < accessMetas.length; ++i) {
            if (accessMetas[i] == null) continue;
            Class<?> accClass = accessMetas[i].getDescribedType();
            if (persisted.contains(accClass) || updated.contains(accClass) || deleted.contains(accClass)) {
                return true;
            }
            Iterator dirty = persisted.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
            dirty = updated.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
            dirty = deleted.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void closeAll() {
        this.closeResults(true);
    }

    @Override
    public void closeResources() {
        this.closeResults(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResults(boolean force) {
        this.lock();
        try {
            this.assertOpen();
            for (RemoveOnCloseResultList res : this._resultLists) {
                if (!force && !res.isProviderOpen()) continue;
                res.close(false);
            }
            this._resultLists.clear();
        }
        finally {
            this.unlock();
        }
    }

    public String[] getDataStoreActions(Map params) {
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        this.lock();
        try {
            this.assertNotSerialized();
            this.assertOpen();
            StoreQuery.Executor ex = this.compileForExecutor();
            this.assertParameters(this._storeQuery, ex, params);
            Object[] arr = ex.toParameterArray(this._storeQuery, params);
            StoreQuery.Range range = new StoreQuery.Range(this._startIdx, this._endIdx);
            if (!this._rangeSet) {
                ex.getRange(this._storeQuery, arr, range);
            }
            String[] stringArray = ex.getDataStoreActions(this._storeQuery, arr, range);
            return stringArray;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(e);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setQuery(Object query) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (query == null || query instanceof String) {
                this.invalidateCompilation();
                this._query = (String)query;
                if (this._query != null) {
                    this._query = this._query.trim();
                }
                boolean bl = true;
                return bl;
            }
            if (!(query instanceof QueryImpl)) {
                boolean bl = this._storeQuery.setQuery(query);
                return bl;
            }
            this.invalidateCompilation();
            QueryImpl q = (QueryImpl)query;
            this._class = q._class;
            this._subclasses = q._subclasses;
            this._query = q._query;
            this._ignoreChanges = q._ignoreChanges;
            this._unique = q._unique;
            this._resultClass = q._resultClass;
            this._params = q._params;
            this._resultMappingScope = q._resultMappingScope;
            this._resultMappingName = q._resultMappingName;
            this._readOnly = q._readOnly;
            this._fc.copy(q._fc);
            if (q._filtListeners != null) {
                this._filtListeners = new HashMap<String, FilterListener>(q._filtListeners);
            }
            if (q._aggListeners != null) {
                this._aggListeners = new HashMap<String, AggregateListener>(q._aggListeners);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlias() {
        this.lock();
        try {
            String alias = this.compileForExecutor().getAlias(this._storeQuery);
            if (alias == null) {
                alias = Strings.getClassName(this._class);
            }
            String string = alias;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getProjectionAliases() {
        this.lock();
        try {
            String[] stringArray = this.compileForExecutor().getProjectionAliases(this._storeQuery);
            return stringArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?>[] getProjectionTypes() {
        this.lock();
        try {
            Class<?>[] classArray = this.compileForExecutor().getProjectionTypes(this._storeQuery);
            return classArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOperation() {
        this.lock();
        try {
            int n = this.compileForExecutor().getOperation(this._storeQuery);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAggregate() {
        this.lock();
        try {
            boolean bl = this.compileForExecutor().isAggregate(this._storeQuery);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDistinct() {
        this.lock();
        try {
            boolean bl = this.compileForExecutor().isDistinct(this._storeQuery);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrouping() {
        this.lock();
        try {
            boolean bl = this.compileForExecutor().hasGrouping(this._storeQuery);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassMetaData[] getAccessPathMetaDatas() {
        this.lock();
        try {
            ClassMetaData[] metas = this.compileForExecutor().getAccessPathMetaDatas(this._storeQuery);
            ClassMetaData[] classMetaDataArray = metas == null ? StoreQuery.EMPTY_METAS : metas;
            return classMetaDataArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderedMap<Object, Class<?>> getOrderedParameterTypes() {
        this.lock();
        try {
            OrderedMap<Object, Class<?>> orderedMap = this.compileForExecutor().getOrderedParameterTypes(this._storeQuery);
            return orderedMap;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedMap getParameterTypes() {
        this.lock();
        try {
            LinkedMap wrap = new LinkedMap();
            wrap.putAll(this.compileForExecutor().getOrderedParameterTypes(this._storeQuery));
            LinkedMap linkedMap = wrap;
            return linkedMap;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUpdates() {
        this.lock();
        try {
            Map<FieldMetaData, Value> map = this.compileForExecutor().getUpdates(this._storeQuery);
            return map;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    @Override
    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    public synchronized void startLocking() {
        if (this._lock == null) {
            this._lock = new ReentrantLock();
        }
    }

    public synchronized void stopLocking() {
        if (this._lock != null && !this._broker.getMultithreaded()) {
            this._lock = null;
        }
    }

    public Class classForName(String name, String[] imports) {
        String fullName;
        Class type = this.toClass(name);
        if (type != null) {
            return type;
        }
        ClassLoader loader = this._class == null ? this._loader : (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(this._class));
        ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(name, loader, false);
        if (meta != null) {
            return meta.getDescribedType();
        }
        if (this._class != null && (type = this.toClass(fullName = this._class.getName().substring(0, this._class.getName().lastIndexOf(46) + 1) + name)) != null) {
            return type;
        }
        type = this.toClass("java.lang." + name);
        if (type != null) {
            return type;
        }
        if (imports != null && imports.length > 0) {
            String dotName = "." + name;
            for (int i = 0; i < imports.length; ++i) {
                String importName = imports[i];
                if (importName.endsWith(dotName)) {
                    type = this.toClass(importName);
                } else if (importName.endsWith(".*")) {
                    importName = importName.substring(0, importName.length() - 1);
                    type = this.toClass(importName + name);
                }
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private Class toClass(String name) {
        if (this._loader == null) {
            this._loader = this._broker.getConfiguration().getClassResolverInstance().getClassLoader(this._class, this._broker.getClassLoader());
        }
        try {
            return Strings.toClass((String)name, (ClassLoader)this._loader);
        }
        catch (RuntimeException re) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void assertOpen() {
        if (this._broker != null) {
            this._broker.assertOpen();
        }
    }

    @Override
    public void assertNotReadOnly() {
        if (this._readOnly) {
            throw new InvalidStateException(_loc.get("read-only"));
        }
    }

    @Override
    public void assertNotSerialized() {
        if (this._broker == null) {
            throw new InvalidStateException(_loc.get("serialized"));
        }
    }

    private void assertCandidateType() {
        if (this._class == null && this._storeQuery.requiresCandidateType()) {
            throw new InvalidStateException(_loc.get("no-class"));
        }
    }

    private void assertBulkModify(StoreQuery q, StoreQuery.Executor ex, Object[] params) {
        this._broker.assertActiveTransaction();
        if (this._startIdx != 0L || this._endIdx != Long.MAX_VALUE) {
            throw new UserException(_loc.get("no-modify-range"));
        }
        if (this._resultClass != null) {
            throw new UserException(_loc.get("no-modify-resultclass"));
        }
        StoreQuery.Range range = new StoreQuery.Range();
        ex.getRange(q, params, range);
        if (range.start != 0L || range.end != Long.MAX_VALUE) {
            throw new UserException(_loc.get("no-modify-range"));
        }
    }

    protected void assertParameters(StoreQuery q, StoreQuery.Executor ex, Object[] params) {
        if (!q.requiresParameterDeclarations() || !this.isParsedQuery()) {
            return;
        }
        OrderedMap<Object, Class<?>> paramTypes = ex.getOrderedParameterTypes(q);
        int typeCount = paramTypes.size();
        if (typeCount > params.length) {
            throw new UserException(_loc.get("unbound-params", (Object)paramTypes.keySet()));
        }
        Iterator itr = paramTypes.entrySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            if (((Class)entry.getValue()).isPrimitive() && params[i] == null) {
                throw new UserException(_loc.get("null-primitive-param", entry.getKey()));
            }
            ++i;
        }
    }

    protected void assertParameters(StoreQuery q, StoreQuery.Executor ex, Map params) {
        if (!q.requiresParameterDeclarations()) {
            return;
        }
        OrderedMap<Object, Class<?>> paramTypes = ex.getOrderedParameterTypes(q);
        for (Object actual : params.keySet()) {
            if (paramTypes.containsKey(actual)) continue;
            throw new UserException(_loc.get("unbound-params", actual, (Object)paramTypes.keySet()));
        }
        for (Object expected : paramTypes.keySet()) {
            if (params.containsKey(expected)) continue;
            throw new UserException(_loc.get("unbound-params", expected, (Object)paramTypes.keySet()));
        }
        for (Map.Entry entry : paramTypes.entrySet()) {
            if (!((Class)entry.getValue()).isPrimitive() || params.get(entry.getKey()) != null) continue;
            throw new UserException(_loc.get("null-primitive-param", entry.getKey()));
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(255);
        buf.append("Query: ").append(super.toString());
        buf.append("; candidate class: ").append(this._class);
        buf.append("; query: ").append(this._query);
        return buf.toString();
    }

    public class RemoveOnCloseResultList
    implements ResultList {
        private final ResultList _res;

        public RemoveOnCloseResultList(ResultList res) {
            this._res = res;
        }

        public ResultList getDelegate() {
            return this._res;
        }

        public boolean isProviderOpen() {
            return this._res.isProviderOpen();
        }

        public Object getUserObject() {
            return this._res.getUserObject();
        }

        public void setUserObject(Object opaque) {
            this._res.setUserObject(opaque);
        }

        public boolean isClosed() {
            return this._res.isClosed();
        }

        public void close() {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean remove) {
            if (this.isClosed()) {
                return;
            }
            this._res.close();
            if (!remove) {
                return;
            }
            QueryImpl.this.lock();
            try {
                Iterator itr = QueryImpl.this._resultLists.iterator();
                while (itr.hasNext()) {
                    if (itr.next() != this) continue;
                    itr.remove();
                    break;
                }
            }
            finally {
                QueryImpl.this.unlock();
            }
        }

        public int size() {
            return this._res.size();
        }

        public boolean isEmpty() {
            return this._res.isEmpty();
        }

        public boolean contains(Object o) {
            return this._res.contains(o);
        }

        public Iterator iterator() {
            return this._res.iterator();
        }

        public Object[] toArray() {
            return this._res.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._res.toArray(a);
        }

        public boolean add(Object o) {
            return this._res.add(o);
        }

        public boolean remove(Object o) {
            return this._res.remove(o);
        }

        public boolean containsAll(Collection c) {
            return this._res.containsAll(c);
        }

        public boolean addAll(Collection c) {
            return this._res.addAll(c);
        }

        public boolean addAll(int idx, Collection c) {
            return this._res.addAll(idx, c);
        }

        public boolean removeAll(Collection c) {
            return this._res.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this._res.retainAll(c);
        }

        public void clear() {
            this._res.clear();
        }

        public Object get(int idx) {
            return this._res.get(idx);
        }

        public Object set(int idx, Object o) {
            return this._res.set(idx, o);
        }

        public void add(int idx, Object o) {
            this._res.add(idx, o);
        }

        public Object remove(int idx) {
            return this._res.remove(idx);
        }

        public int indexOf(Object o) {
            return this._res.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this._res.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this._res.listIterator();
        }

        public ListIterator listIterator(int idx) {
            return this._res.listIterator(idx);
        }

        public List subList(int start, int end) {
            return this._res.subList(start, end);
        }

        public boolean equals(Object o) {
            return this._res.equals(o);
        }

        public int hashCode() {
            return this._res.hashCode();
        }

        public String toString() {
            return this._res.toString();
        }

        public Object writeReplace() {
            return this._res;
        }
    }

    public static class PackingResultObjectProvider
    implements ResultObjectProvider {
        private final ResultObjectProvider _delegate;
        private final ResultPacker _packer;
        private final int _len;

        public PackingResultObjectProvider(ResultObjectProvider delegate, ResultPacker packer, int resultLength) {
            this._delegate = delegate;
            this._packer = packer;
            this._len = resultLength;
        }

        public boolean supportsRandomAccess() {
            return this._delegate.supportsRandomAccess();
        }

        public void open() throws Exception {
            this._delegate.open();
        }

        public Object getResultObject() throws Exception {
            Object ob = this._delegate.getResultObject();
            if (this._packer == null && this._len == 1) {
                return ((Object[])ob)[0];
            }
            if (this._packer == null) {
                return ob;
            }
            if (this._len == 0) {
                return this._packer.pack(ob);
            }
            return this._packer.pack((Object[])ob);
        }

        public boolean next() throws Exception {
            return this._delegate.next();
        }

        public boolean absolute(int pos) throws Exception {
            return this._delegate.absolute(pos);
        }

        public int size() throws Exception {
            return this._delegate.size();
        }

        public void reset() throws Exception {
            this._delegate.reset();
        }

        public void close() throws Exception {
            this._delegate.close();
        }

        public void handleCheckedException(Exception e) {
            this._delegate.handleCheckedException(e);
        }

        public ResultObjectProvider getDelegate() {
            return this._delegate;
        }
    }

    private static class MergedExecutor
    implements StoreQuery.Executor {
        private final StoreQuery.Executor[] _executors;

        public MergedExecutor(StoreQuery.Executor[] executors) {
            this._executors = executors;
        }

        @Override
        public QueryExpressions[] getQueryExpressions() {
            return this._executors[0].getQueryExpressions();
        }

        @Override
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            if (this._executors.length == 1) {
                return this._executors[0].executeQuery(q, params, range);
            }
            StoreQuery.Range ropRange = new StoreQuery.Range(0L, range.end);
            ropRange.lrs = range.lrs || range.start > 0L && q.getContext().getFetchConfiguration().getFetchBatchSize() >= 0;
            ResultObjectProvider[] rops = new ResultObjectProvider[this._executors.length];
            for (int i = 0; i < this._executors.length; ++i) {
                rops[i] = this._executors[i].executeQuery(q, params, ropRange);
            }
            boolean[] asc = this._executors[0].getAscending(q);
            Object rop = asc.length == 0 ? new MergedResultObjectProvider(rops) : new OrderingMergedResultObjectProvider(rops, asc, this._executors, q, params);
            if (range.start != 0L) {
                rop = new RangeResultObjectProvider((ResultObjectProvider)rop, range.start, range.end);
            }
            return rop;
        }

        @Override
        public Number executeDelete(StoreQuery q, Object[] params) {
            long num = 0L;
            for (int i = 0; i < this._executors.length; ++i) {
                num += this._executors[i].executeDelete(q, params).longValue();
            }
            return num;
        }

        @Override
        public Number executeUpdate(StoreQuery q, Object[] params) {
            long num = 0L;
            for (int i = 0; i < this._executors.length; ++i) {
                num += this._executors[i].executeUpdate(q, params).longValue();
            }
            return num;
        }

        @Override
        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            if (this._executors.length == 1) {
                return this._executors[0].getDataStoreActions(q, params, range);
            }
            ArrayList<String> results = new ArrayList<String>(this._executors.length);
            StoreQuery.Range ropRange = new StoreQuery.Range(0L, range.end);
            for (int i = 0; i < this._executors.length; ++i) {
                String[] actions = this._executors[i].getDataStoreActions(q, params, ropRange);
                if (actions == null || actions.length <= 0) continue;
                results.addAll(Arrays.asList(actions));
            }
            return results.toArray(new String[results.size()]);
        }

        @Override
        public void validate(StoreQuery q) {
            this._executors[0].validate(q);
        }

        @Override
        public void getRange(StoreQuery q, Object[] params, StoreQuery.Range range) {
            this._executors[0].getRange(q, params, range);
        }

        @Override
        public Object getOrderingValue(StoreQuery q, Object[] params, Object resultObject, int idx) {
            return this._executors[0].getOrderingValue(q, params, resultObject, idx);
        }

        @Override
        public boolean[] getAscending(StoreQuery q) {
            return this._executors[0].getAscending(q);
        }

        @Override
        public String getAlias(StoreQuery q) {
            return this._executors[0].getAlias(q);
        }

        @Override
        public String[] getProjectionAliases(StoreQuery q) {
            return this._executors[0].getProjectionAliases(q);
        }

        public Class getResultClass(StoreQuery q) {
            return this._executors[0].getResultClass(q);
        }

        @Override
        public ResultShape<?> getResultShape(StoreQuery q) {
            return this._executors[0].getResultShape(q);
        }

        public Class[] getProjectionTypes(StoreQuery q) {
            return this._executors[0].getProjectionTypes(q);
        }

        @Override
        public boolean isPacking(StoreQuery q) {
            return this._executors[0].isPacking(q);
        }

        @Override
        public ClassMetaData[] getAccessPathMetaDatas(StoreQuery q) {
            if (this._executors.length == 1) {
                return this._executors[0].getAccessPathMetaDatas(q);
            }
            List<ClassMetaData> metas = null;
            for (int i = 0; i < this._executors.length; ++i) {
                metas = Filters.addAccessPathMetaDatas(metas, this._executors[i].getAccessPathMetaDatas(q));
            }
            if (metas == null) {
                return StoreQuery.EMPTY_METAS;
            }
            return metas.toArray(new ClassMetaData[metas.size()]);
        }

        @Override
        public boolean isAggregate(StoreQuery q) {
            if (!this._executors[0].isAggregate(q)) {
                return false;
            }
            throw new UnsupportedException(_loc.get("merged-aggregate", q.getContext().getCandidateType(), (Object)q.getContext().getQueryString()));
        }

        @Override
        public boolean isDistinct(StoreQuery q) {
            return this._executors[0].isDistinct(q);
        }

        @Override
        public int getOperation(StoreQuery q) {
            return this._executors[0].getOperation(q);
        }

        @Override
        public boolean hasGrouping(StoreQuery q) {
            return this._executors[0].hasGrouping(q);
        }

        @Override
        public OrderedMap<Object, Class<?>> getOrderedParameterTypes(StoreQuery q) {
            return this._executors[0].getOrderedParameterTypes(q);
        }

        @Override
        public LinkedMap getParameterTypes(StoreQuery q) {
            return this._executors[0].getParameterTypes(q);
        }

        public Object[] toParameterArray(StoreQuery q, Map userParams) {
            return this._executors[0].toParameterArray(q, userParams);
        }

        public Map getUpdates(StoreQuery q) {
            return this._executors[0].getUpdates(q);
        }
    }

    private static class CompilationKey
    implements Serializable {
        public Class queryType = null;
        public Class candidateType = null;
        public boolean subclasses = true;
        public String query = null;
        public String language = null;
        public Object storeKey = null;

        private CompilationKey() {
        }

        public int hashCode() {
            int rs = 17;
            rs = 37 * rs + (this.queryType == null ? 0 : this.queryType.hashCode());
            rs = 37 * rs + (this.query == null ? 0 : this.query.hashCode());
            rs = 37 * rs + (this.language == null ? 0 : this.language.hashCode());
            rs = 37 * rs + (this.storeKey == null ? 0 : this.storeKey.hashCode());
            if (this.subclasses) {
                ++rs;
            }
            return rs;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            CompilationKey key = (CompilationKey)other;
            if (key.queryType != this.queryType || !StringUtils.equals((String)key.query, (String)this.query) || !StringUtils.equals((String)key.language, (String)this.language)) {
                return false;
            }
            if (key.subclasses != this.subclasses) {
                return false;
            }
            if (!ObjectUtils.equals((Object)key.storeKey, (Object)this.storeKey)) {
                return false;
            }
            return key.candidateType == null || this.candidateType == null || key.candidateType == this.candidateType;
        }
    }

    protected static class Compilation
    implements Serializable {
        public StoreQuery.Executor memory = null;
        public StoreQuery.Executor datastore = null;
        public Object storeData = null;

        protected Compilation() {
        }
    }
}

