/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resolver;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.LocationResolver;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.resolver.maven.Handler;
import org.apache.openejb.resolver.maven.Parser;

public class Resolver
implements LocationResolver {
    public String resolve(String rawLocation) throws Exception {
        if (rawLocation.startsWith("mvn:") && rawLocation.length() > "mvn:".length()) {
            String info = rawLocation.substring("mvn:".length());
            Parser parser = new Parser(info);
            File file = ProvisioningUtil.cacheFile((String)parser.getArtifactPath());
            if (!file.exists() || !file.canRead()) {
                try {
                    URL url = new URL("mvn:".substring("mvn:".length() - 1), "localhost", -1, info, new Handler());
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists() && !parentFile.mkdirs()) {
                        throw new Exception("Failed to create: " + parentFile);
                    }
                    IO.copy((InputStream)IO.read((URL)url), (File)file);
                }
                catch (Exception e) {
                    if (file.exists() && !file.delete()) {
                        file.deleteOnExit();
                    }
                    throw e;
                }
            }
            return file.getPath();
        }
        return rawLocation;
    }
}

