/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resolver.maven;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;

public class Parser {
    private static final String SYNTAX = "mvn:[repository_url!]groupId/artifactId[/[version]/[type]]";
    private static final String REPOSITORY_SEPARATOR = "!";
    private static final String ARTIFACT_SEPARATOR = "/";
    private static final String VERSION_SNAPSHOT = "SNAPSHOT";
    private static final String FILE_SEPARATOR = "/";
    private static final String GROUP_SEPARATOR = "\\.";
    private static final String VERSION_SEPARATOR = "-";
    private static final String TYPE_SEPARATOR = ".";
    private static final String CLASSIFIER_SEPARATOR = "-";
    private static final String METADATA_FILE = "maven-metadata.xml";
    private static final String METADATA_FILE_LOCAL = "maven-metadata-local.xml";
    private final String group;
    private final String artifact;
    private final String version;
    private final String type;
    private final String classifier;
    private final String fullClassifier;
    private MavenRepositoryURL repositoryURL;

    public Parser(String rawPath) throws MalformedURLException {
        String part;
        if (rawPath == null) {
            throw new MalformedURLException("Path cannot be null. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        boolean possibleMavenCoordinates = rawPath.contains(":");
        String path = rawPath.replace(":", "/");
        if (path.startsWith(REPOSITORY_SEPARATOR) || path.endsWith(REPOSITORY_SEPARATOR)) {
            throw new MalformedURLException("Path cannot start or end with !. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (path.contains(REPOSITORY_SEPARATOR)) {
            int pos = path.lastIndexOf(REPOSITORY_SEPARATOR);
            part = path.substring(pos + 1);
            this.repositoryURL = new MavenRepositoryURL(path.substring(0, pos) + "@snapshots");
        } else {
            part = path;
        }
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(part.split("/")));
        if (segments.size() < 2 || segments.size() > 5) {
            throw new MalformedURLException("Invalid path. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (possibleMavenCoordinates && ((String)segments.get(segments.size() - 1)).matches("[0-9].*")) {
            String version = (String)segments.remove(segments.size() - 1);
            segments.add(2, version);
        }
        String[] coordinates = new String[]{null, null, "LATEST", "jar", null};
        for (int i = 0; i < segments.size(); ++i) {
            String value = ((String)segments.get(i)).trim();
            if (value.length() == 0) continue;
            coordinates[i] = value;
        }
        this.group = coordinates[0];
        this.artifact = coordinates[1];
        this.version = coordinates[2];
        this.type = coordinates[3];
        this.classifier = coordinates[4];
        String string = this.fullClassifier = this.classifier != null ? "-" + this.classifier : null;
        if (this.group == null) {
            throw new MalformedURLException("Invalid groupId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (this.artifact == null) {
            throw new MalformedURLException("Invalid artifactId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getArtifactPath() {
        return this.getArtifactPath(this.version);
    }

    public String getArtifactPath(String version) {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + version + "/" + this.artifact + "-" + version + this.fullClassifier + TYPE_SEPARATOR + this.type;
    }

    public String getSnapshotVersion(String version, String timestamp, String buildnumber) {
        return version.replace(VERSION_SNAPSHOT, timestamp) + "-" + buildnumber;
    }

    public String getSnapshotPath(String version, String timestamp, String buildnumber) {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + version + "/" + this.artifact + "-" + this.getSnapshotVersion(version, timestamp, buildnumber) + this.fullClassifier + TYPE_SEPARATOR + this.type;
    }

    public String getVersionMetadataPath(String version) {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + version + "/" + METADATA_FILE;
    }

    public String getVersionLocalMetadataPath(String version) {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + version + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactLocalMetdataPath() {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactMetdataPath() {
        return this.group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.artifact + "/" + METADATA_FILE;
    }

    public MavenRepositoryURL getRepositoryURL() {
        return this.repositoryURL;
    }
}

