/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.rest.RESTResourceFinder;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.cxf.rs.CxfRESTResourceFinder;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.cxf.transport.HttpTransportFactory;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.rest.RESTService;
import org.apache.openejb.server.rest.RsHttpListener;

public class CxfRSService
extends RESTService {
    private static final String NAME = "cxf-rs";
    private HttpTransportFactory httpTransportFactory;

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties properties) throws Exception {
        super.init(properties);
        SystemInstance.get().setComponent(RESTResourceFinder.class, (Object)new CxfRESTResourceFinder());
        CxfUtil.configureBus();
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            if (!CxfUtil.hasService((String)"http://apache.org/cxf/binding/jaxrs")) {
                BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
                try {
                    bfm.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)new JAXRSBindingFactory(bus));
                }
                catch (Throwable b) {
                    // empty catch block
                }
            }
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    protected void beforeStart() {
        super.beforeStart();
        this.httpTransportFactory = new HttpTransportFactory(CxfUtil.getBus());
    }

    protected boolean containsJaxRsConfiguration(Properties properties) {
        return properties.containsKey("cxf.jaxrs.providers") || properties.containsKey("cxf.jaxrs.in-fault-interceptors") || properties.containsKey("cxf.jaxrs.in-interceptors") || properties.containsKey("cxf.jaxrs.out-fault-interceptors") || properties.containsKey("cxf.jaxrs.out-interceptors") || properties.containsKey("cxf.jaxrs.databinding") || properties.containsKey("cxf.jaxrs.features") || properties.containsKey("cxf.jaxrs.address") || properties.containsKey("cxf.jaxrs.properties");
    }

    protected RsHttpListener createHttpListener() {
        return new CxfRsHttpListener((HTTPTransportFactory)this.httpTransportFactory, this.getWildcard());
    }
}

