/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.openejb.rest.ThreadLocalContextManager;

public final class Contexts {
    private Contexts() {
    }

    public static void bind(Exchange exchange) {
        if (exchange == null) {
            return;
        }
        ClassResourceInfo cri = ((OperationResourceInfo)exchange.get(OperationResourceInfo.class)).getClassResourceInfo();
        HashSet types = new HashSet();
        for (Field field : cri.getContextFields()) {
            types.add(field.getType());
        }
        Contexts.bind(exchange, types);
    }

    public static void bind(Exchange exchange, Set<Class<?>> types) {
        for (Class<?> type : types) {
            Request binding;
            if (Request.class.equals(type)) {
                binding = (Request)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Request.class);
                ThreadLocalContextManager.REQUEST.set((Object)binding);
                continue;
            }
            if (UriInfo.class.equals(type)) {
                binding = (UriInfo)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, UriInfo.class);
                ThreadLocalContextManager.URI_INFO.set((Object)binding);
                continue;
            }
            if (HttpHeaders.class.equals(type)) {
                binding = (HttpHeaders)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpHeaders.class);
                ThreadLocalContextManager.HTTP_HEADERS.set((Object)binding);
                continue;
            }
            if (SecurityContext.class.equals(type)) {
                binding = (SecurityContext)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, SecurityContext.class);
                ThreadLocalContextManager.SECURITY_CONTEXT.set((Object)binding);
                continue;
            }
            if (ContextResolver.class.equals(type)) {
                binding = (ContextResolver)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), type, ContextResolver.class);
                ThreadLocalContextManager.CONTEXT_RESOLVER.set((Object)binding);
                continue;
            }
            if (Providers.class.equals(type)) {
                Providers providers = (Providers)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Providers.class);
                ThreadLocalContextManager.PROVIDERS.set((Object)providers);
                continue;
            }
            if (ServletRequest.class.equals(type)) {
                ServletRequest servletRequest = (ServletRequest)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ServletRequest.class);
                ThreadLocalContextManager.SERVLET_REQUEST.set((Object)servletRequest);
                continue;
            }
            if (HttpServletRequest.class.equals(type)) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpServletRequest.class);
                ThreadLocalContextManager.HTTP_SERVLET_REQUEST.set((Object)httpServletRequest);
                continue;
            }
            if (HttpServletResponse.class.equals(type)) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpServletResponse.class);
                ThreadLocalContextManager.HTTP_SERVLET_RESPONSE.set((Object)httpServletResponse);
                continue;
            }
            if (ServletConfig.class.equals(type)) {
                ServletConfig servletConfig = (ServletConfig)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ServletConfig.class);
                ThreadLocalContextManager.SERVLET_CONFIG.set((Object)servletConfig);
                continue;
            }
            Message message = exchange.getInMessage();
            ContextProvider provider = ProviderFactory.getInstance((Message)message).createContextProvider(type, message);
            if (provider == null) continue;
            Object value = provider.createContext(message);
            HashMap<String, Object> map = (HashMap<String, Object>)ThreadLocalContextManager.OTHERS.get();
            if (map == null) {
                map = new HashMap<String, Object>();
                ThreadLocalContextManager.OTHERS.set(map);
            }
            map.put(type.getName(), value);
        }
    }
}

