/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.SimpleCompletor;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.Module;
import org.apache.openejb.server.cli.CliRuntimeException;
import org.apache.openejb.server.cli.StreamManager;
import org.apache.openejb.server.cli.command.AbstractCommand;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OpenEJBScripter;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class CliRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, CliRunnable.class);
    private static final String BRANDING_FILE = "branding.properties";
    private static final String WELCOME_KEY_PREFIX = "welcome_";
    private static final String WELCOME_COMMON_KEY = "welcome_common";
    private static final String WELCOME_OPENEJB_KEY = "welcome_openejb";
    private static final String WELCOME_TOMEE_KEY = "welcome_tomee";
    public static final String TOMEE_NAME = "TomEE";
    public static final String OPENEJB_NAME = "OpenEJB";
    public static final String EXIT_COMMAND = "exit";
    private static final String OS_LINE_SEP = System.getProperty("line.separator");
    private static final String NAME;
    private static final String PROMPT;
    private static final String PROMPT_SUFFIX = "> ";
    private static final Properties PROPERTIES;
    private static final boolean tomee;
    private static final Map<String, Class<?>> COMMANDS;
    private static final OpenEJBScripter scripter;
    public String lineSep;
    private OutputStream err;
    private OutputStream out;
    private InputStream sin;
    private String username;
    private final String bind;
    private final int port;

    public CliRunnable(String bind, int port) {
        this(bind, port, PROMPT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliRunnable(String bind, int port, String username, String sep) {
        this.bind = bind;
        this.port = port;
        this.username = username;
        if (sep != null) {
            this.lineSep = sep;
            System.setProperty("line.separator", sep);
            try {
                new ConsoleReader();
            }
            catch (IOException ignored) {
            }
            finally {
                System.setProperty("line.separator", OS_LINE_SEP);
            }
        } else {
            this.lineSep = OS_LINE_SEP;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setInputStream(InputStream in) {
        this.sin = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void start() throws IOException {
        new Thread((Runnable)this, "OpenEJB Cli").start();
    }

    public void destroy() {
    }

    public void clean() {
        OpenEJBScripter.clearEngines();
    }

    @Override
    public void run() {
        this.clean();
        try {
            String line;
            StreamManager streamManager = new StreamManager(this.out, this.err, this.lineSep);
            ConsoleReader reader = new ConsoleReader(this.sin, (Writer)streamManager.getSout());
            reader.addCompletor((Completor)new FileNameCompletor());
            reader.addCompletor((Completor)new SimpleCompletor(COMMANDS.keySet().toArray(new String[COMMANDS.size()])));
            StringBuilder builtWelcome = new StringBuilder("Apache OpenEJB ").append(OpenEjbVersion.get().getVersion()).append("    build: ").append(OpenEjbVersion.get().getDate()).append("-").append(OpenEjbVersion.get().getTime()).append(this.lineSep);
            if (tomee) {
                builtWelcome.append(OS_LINE_SEP).append(PROPERTIES.getProperty(WELCOME_TOMEE_KEY));
            } else {
                builtWelcome.append(OS_LINE_SEP).append(PROPERTIES.getProperty(WELCOME_OPENEJB_KEY));
            }
            builtWelcome.append(this.lineSep).append(PROPERTIES.getProperty(WELCOME_COMMON_KEY));
            streamManager.writeOut(OpenEjbVersion.get().getUrl());
            streamManager.writeOut(builtWelcome.toString().replace("$bind", this.bind).replace("$port", Integer.toString(this.port)).replace("$name", NAME).replace(OS_LINE_SEP, this.lineSep));
            while ((line = reader.readLine(this.prompt())) != null && !EXIT_COMMAND.equals(line)) {
                Class<?> cmdClass = null;
                String key = null;
                for (Map.Entry<String, Class<?>> cmd : COMMANDS.entrySet()) {
                    if (!line.startsWith(cmd.getKey())) continue;
                    cmdClass = cmd.getValue();
                    key = cmd.getKey();
                    break;
                }
                if (cmdClass != null) {
                    ObjectRecipe recipe = new ObjectRecipe(cmdClass);
                    recipe.setProperty("streamManager", (Object)streamManager);
                    recipe.setProperty("command", (Object)line);
                    recipe.setProperty("scripter", (Object)scripter);
                    recipe.setProperty("commands", COMMANDS);
                    recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                    recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                    recipe.allow(Option.NAMED_PARAMETERS);
                    try {
                        AbstractCommand cmdInstance = (AbstractCommand)recipe.create();
                        cmdInstance.execute(this.trunc(line, key));
                    }
                    catch (Exception e) {
                        streamManager.writeErr(e);
                    }
                    continue;
                }
                streamManager.writeErr("sorry i don't understand '" + line + "'");
            }
            this.clean();
        }
        catch (IOException e) {
            this.clean();
            throw new CliRuntimeException(e);
        }
    }

    private String trunc(String line, String cmd) {
        if (line.length() == cmd.length()) {
            return "";
        }
        String trunc = line.substring(cmd.length());
        int idx = 0;
        while (trunc.charAt(idx) == ' ') {
            ++idx;
        }
        if (idx < trunc.length()) {
            return trunc.substring(idx);
        }
        return "";
    }

    private String prompt() {
        StringBuilder prompt = new StringBuilder("");
        if (this.username != null) {
            prompt.append(this.username);
        } else {
            prompt.append(PROMPT);
        }
        prompt.append(" @ ").append(this.bind).append(":").append(this.port).append(PROMPT_SUFFIX);
        return prompt.toString();
    }

    static {
        PROPERTIES = new Properties();
        COMMANDS = new TreeMap();
        scripter = new OpenEJBScripter();
        String name = OPENEJB_NAME;
        try {
            CliRunnable.class.getClassLoader().loadClass("org.apache.tomee.loader.TomcatHook");
            name = TOMEE_NAME;
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        tomee = TOMEE_NAME.equals(name);
        NAME = name;
        PROMPT = NAME.toLowerCase() + PROMPT_SUFFIX;
        try {
            PROPERTIES.load(CliRunnable.class.getClassLoader().getResourceAsStream(BRANDING_FILE));
        }
        catch (IOException e) {
            // empty catch block
        }
        ClassLoader loader = CliRunnable.class.getClassLoader();
        try {
            UrlSet urlSet = new UrlSet(loader).excludeJvm();
            urlSet = urlSet.exclude(loader.getParent());
            AnnotationFinder finder = new AnnotationFinder((Archive)new ConfigurableClasspathArchive((Module)new ConfigurableClasspathArchive.FakeModule(loader, Collections.EMPTY_MAP), true, (Iterable)urlSet.getUrls()));
            for (Annotated cmd : finder.findMetaAnnotatedClasses(Command.class)) {
                try {
                    Command annotation = (Command)cmd.getAnnotation(Command.class);
                    String key = annotation.name();
                    if (!COMMANDS.containsKey(key)) {
                        COMMANDS.put(key, (Class<?>)cmd.get());
                        continue;
                    }
                    LOGGER.warning("command " + key + " already exists, this one will be ignored ( " + annotation.description() + ")");
                }
                catch (Exception e) {}
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("an error occured while getting commands", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("can't get commands");
        }
    }
}

