/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StreamManager {
    private static final String OS_LINE_SEP = System.getProperty("line.separator");
    private String lineSep;
    private OutputStreamWriter serr;
    private OutputStreamWriter sout;
    private OutputStream out;
    private OutputStream err;

    public StreamManager(OutputStream out, OutputStream err, String lineSep) {
        this.lineSep = lineSep;
        this.out = out;
        this.err = err;
        this.sout = new OutputStreamWriter(out);
        this.serr = new OutputStreamWriter(err);
    }

    private void write(OutputStreamWriter writer, String s) {
        for (String l : s.split(this.lineSep)) {
            try {
                writer.write(l);
                writer.write(this.lineSep);
                writer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void writeOut(String s) {
        this.write(this.sout, s);
    }

    public void writeErr(Exception e) {
        if (e.getStackTrace() == null) {
            this.write(this.serr, e.getMessage());
        } else {
            StringBuilder error = new StringBuilder();
            error.append(e.getMessage()).append(this.lineSep);
            for (StackTraceElement elt : e.getStackTrace()) {
                error.append("    ").append(elt.toString()).append(this.lineSep);
            }
            this.write(this.serr, error.toString());
        }
    }

    public String asString(Object out) {
        if (out == null) {
            return "null";
        }
        if (out instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            for (Object o : (Collection)out) {
                builder.append(StreamManager.string(o, this.lineSep)).append(this.lineSep);
            }
            return builder.toString();
        }
        return StreamManager.string(out, this.lineSep);
    }

    private static String string(Object out, String lineSep) {
        if (!out.getClass().getName().startsWith("java")) {
            try {
                return new GsonBuilder().setPrettyPrinting().create().toJson(out).replace(OS_LINE_SEP, lineSep);
            }
            catch (RuntimeException re) {
                return ToStringBuilder.reflectionToString((Object)out, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).replace(OS_LINE_SEP, lineSep);
            }
        }
        return out.toString();
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public OutputStreamWriter getSerr() {
        return this.serr;
    }

    public OutputStreamWriter getSout() {
        return this.sout;
    }

    public String getLineSep() {
        return this.lineSep;
    }

    public void writeErr(String s) {
        this.write(this.serr, s);
    }
}

