/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtils;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private int size = 0;
    private ELResolver[] resolvers = new ELResolver[2];

    public synchronized void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        if (this.size >= this.resolvers.length) {
            ELResolver[] nr = new ELResolver[this.size * 2];
            System.arraycopy(this.resolvers, 0, nr, 0, this.size);
            this.resolvers = nr;
        }
        this.resolvers[this.size++] = elResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        ELResolver[] rslvrs;
        int sz;
        context.setPropertyResolved(false);
        CompositeELResolver compositeELResolver = this;
        synchronized (compositeELResolver) {
            sz = this.size;
            rslvrs = this.resolvers;
        }
        Object result = null;
        for (int i = 0; i < sz; ++i) {
            result = rslvrs[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        ELResolver[] rslvrs;
        int sz;
        context.setPropertyResolved(false);
        CompositeELResolver compositeELResolver = this;
        synchronized (compositeELResolver) {
            sz = this.size;
            rslvrs = this.resolvers;
        }
        for (int i = 0; i < sz; ++i) {
            rslvrs[i].setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        ELResolver[] rslvrs;
        int sz;
        context.setPropertyResolved(false);
        CompositeELResolver compositeELResolver = this;
        synchronized (compositeELResolver) {
            sz = this.size;
            rslvrs = this.resolvers;
        }
        boolean readOnly = false;
        for (int i = 0; i < sz; ++i) {
            readOnly = rslvrs[i].isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public synchronized Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return new FeatureIterator(context, base, this.resolvers, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        ELResolver[] rslvrs;
        int sz;
        CompositeELResolver compositeELResolver = this;
        synchronized (compositeELResolver) {
            sz = this.size;
            rslvrs = this.resolvers;
        }
        Class<?> commonType = null;
        Class<?> type = null;
        for (int i = 0; i < sz; ++i) {
            type = rslvrs[i].getCommonPropertyType(context, base);
            if (type == null || commonType != null && !commonType.isAssignableFrom(type)) continue;
            commonType = type;
        }
        return commonType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        ELResolver[] rslvrs;
        int sz;
        context.setPropertyResolved(false);
        CompositeELResolver compositeELResolver = this;
        synchronized (compositeELResolver) {
            sz = this.size;
            rslvrs = this.resolvers;
        }
        for (int i = 0; i < sz; ++i) {
            Class<?> type = rslvrs[i].getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        String targetMethod;
        if (context == null) {
            throw new NullPointerException("ELContext could not be null");
        }
        if (method == null || base == null) {
            return null;
        }
        ExpressionFactory expressionFactory = null;
        if (ELUtils.isCachedExpressionFactoryEnabled()) {
            expressionFactory = ELUtils.getCachedExpressionFactory();
        }
        if (expressionFactory == null) {
            expressionFactory = ExpressionFactory.newInstance();
        }
        if ((targetMethod = (String)expressionFactory.coerceToType(method, String.class)).length() == 0) {
            throw new ELException(new NoSuchMethodException());
        }
        context.setPropertyResolved(false);
        if (context.getContext(ExpressionFactory.class) == null) {
            context.putContext(ExpressionFactory.class, expressionFactory);
        }
        Object retValue = null;
        for (ELResolver resolver : this.resolvers) {
            retValue = resolver.invoke(context, base, targetMethod, paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return retValue;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext context;
        private final Object base;
        private final ELResolver[] resolvers;
        private final int size;
        private Iterator itr;
        private int idx;

        public FeatureIterator(ELContext context, Object base, ELResolver[] resolvers, int size) {
            this.context = context;
            this.base = base;
            this.resolvers = resolvers;
            this.size = size;
            this.idx = 0;
            this.guaranteeIterator();
        }

        private void guaranteeIterator() {
            while (this.itr == null && this.idx < this.size) {
                this.itr = this.resolvers[this.idx].getFeatureDescriptors(this.context, this.base);
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.itr != null;
        }

        @Override
        public FeatureDescriptor next() {
            Object result = null;
            if (this.itr != null && this.itr.hasNext()) {
                result = this.itr.next();
                if (!this.itr.hasNext()) {
                    this.itr = null;
                    this.guaranteeIterator();
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

