/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.arquillian.common.Zips;
import org.apache.openejb.config.RemoteServer;
import org.apache.tomee.arquillian.webapp.TomEEWebappConfiguration;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.Paths;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

public class TomEEWebappContainer
extends TomEEContainer<TomEEWebappConfiguration> {
    private static final Logger logger = Logger.getLogger(TomEEWebappContainer.class.getName());
    private RemoteServer container;
    private boolean shutdown = false;

    public void start() throws LifecycleException {
        if (Setup.isRunning((String)((TomEEWebappConfiguration)this.configuration).getHost(), (int)((TomEEWebappConfiguration)this.configuration).getHttpPort())) {
            logger.info(String.format("Tomcat found running on port %s", ((TomEEWebappConfiguration)this.configuration).getHttpPort()));
            return;
        }
        this.shutdown = true;
        String s = File.separator;
        try {
            File workingDirectory = new File(((TomEEWebappConfiguration)this.configuration).getDir());
            if (workingDirectory.exists()) {
                Files.assertDir((File)workingDirectory);
            } else {
                Files.mkdir((File)workingDirectory);
                Files.deleteOnExit((File)workingDirectory);
            }
            Files.readable((File)workingDirectory);
            Files.writable((File)workingDirectory);
            File openejbHome = Setup.findHome((File)workingDirectory);
            if (openejbHome == null) {
                this.downloadTomcat(workingDirectory, ((TomEEWebappConfiguration)this.configuration).getTomcatVersion());
                openejbHome = Setup.findHome((File)workingDirectory);
                Files.deleteOnExit((File)openejbHome);
                File webapp = new File(openejbHome, "webapps" + s + "tomee");
                Files.mkdir((File)webapp);
                this.downloadOpenEJBWebapp(webapp);
                System.setProperty("catalina.home", openejbHome.getAbsolutePath());
                System.setProperty("catalina.base", openejbHome.getAbsolutePath());
                System.setProperty("openejb.deploymentId.format", "{appId}/{ejbJarId}/{ejbName}");
                Paths paths = new Paths(webapp);
                Installer installer = new Installer(paths, true);
                installer.installAll();
            }
            Files.assertDir((File)openejbHome);
            Files.readable((File)openejbHome);
            Files.writable((File)openejbHome);
            Setup.configureServerXml((File)openejbHome, (TomEEConfiguration)this.configuration);
            Setup.configureSystemProperties((File)openejbHome, (TomEEConfiguration)this.configuration);
            Setup.exportProperties((File)openejbHome, (TomEEConfiguration)this.configuration);
            URL logging = Thread.currentThread().getContextClassLoader().getResource("default.remote.logging.properties");
            if (logging != null) {
                TomEEWebappContainer.write(logging, new File(openejbHome, "conf" + s + "logging.properties"));
            }
            if (((TomEEWebappConfiguration)this.configuration).isRemoveUnusedWebapps()) {
                Setup.removeUselessWebapps((File)openejbHome);
            }
            if (logger.isLoggable(Level.FINE)) {
                TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
                for (Map.Entry entry : map.entrySet()) {
                    System.out.printf("%s = %s\n", entry.getKey(), entry.getValue());
                }
            }
            this.container = new RemoteServer();
            this.container.start();
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to start remote container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(URL resource, File file) throws IOException {
        if (file.exists()) {
            Files.delete((File)file);
        }
        InputStream is = org.apache.openejb.loader.IO.read((URL)resource);
        try {
            IO.copy((InputStream)is, (File)file);
        }
        finally {
            is.close();
        }
    }

    protected void downloadOpenEJBWebapp(File targetDirectory) throws LifecycleException {
        String artifactName = ((TomEEWebappConfiguration)this.configuration).getArtifactName();
        File zipFile = Setup.downloadFile((String)artifactName, null);
        Zips.unzip((File)zipFile, (File)targetDirectory);
    }

    protected void downloadTomcat(File catalinaDirectory, String tomcatVersion) throws LifecycleException {
        String source = null;
        if (tomcatVersion.startsWith("7.")) {
            source = "http://archive.apache.org/dist/tomcat/tomcat-7/v" + tomcatVersion + "/bin/apache-tomcat-" + tomcatVersion + ".zip";
        }
        if (tomcatVersion.startsWith("6.")) {
            source = "http://archive.apache.org/dist/tomcat/tomcat-6/v" + tomcatVersion + "/bin/apache-tomcat-" + tomcatVersion + ".zip";
        }
        if (tomcatVersion.startsWith("5.5")) {
            source = "http://archive.apache.org/dist/tomcat/tomcat-5/v" + tomcatVersion + "/bin/apache-tomcat-" + tomcatVersion + ".zip";
        }
        if (source == null) {
            throw new LifecycleException("Unable to find URL for Tomcat " + tomcatVersion);
        }
        File zipFile = Setup.downloadFile((String)("org.apache.openejb:apache-tomcat:" + tomcatVersion + ":zip"), (String)source);
        Zips.unzip((File)zipFile, (File)catalinaDirectory);
    }

    public void stop() throws LifecycleException {
        if (this.shutdown) {
            this.container.stop();
        }
    }

    public Class<TomEEWebappConfiguration> getConfigurationClass() {
        return TomEEWebappConfiguration.class;
    }
}

