/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.debian;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tomee.debian.PackageException;

public class PackageBuilder {
    private final String user;
    private final String group;
    private long size = 0L;

    public PackageBuilder(String user, String group) {
        this.user = user;
        this.group = group;
    }

    private File uncompress(File gz) throws IOException, CompressorException {
        File output = new File(gz.getParent(), FilenameUtils.getBaseName((String)gz.getName()));
        output.delete();
        FileInputStream is = new FileInputStream(gz);
        CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)is);
        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(output));
        in.close();
        return output;
    }

    private File compress(File file) throws IOException, CompressorException {
        File output = new File(file.getParent(), file.getName() + ".gz");
        output.delete();
        FileOutputStream out = new FileOutputStream(output);
        CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)out);
        FileInputStream is = new FileInputStream(file);
        IOUtils.copy((InputStream)is, (OutputStream)cos);
        is.close();
        cos.close();
        ((OutputStream)out).close();
        return output;
    }

    private File untar(File tar) throws IOException, ArchiveException {
        File output = new File(tar.getParent(), FilenameUtils.getBaseName((String)tar.getName()));
        try {
            FileUtils.deleteDirectory((File)output);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        FileInputStream is = new FileInputStream(tar);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
        while (entry != null) {
            File newFile = new File(output, entry.getName());
            if (entry.isDirectory()) {
                newFile.mkdirs();
            } else {
                FileOutputStream out = new FileOutputStream(newFile);
                this.size += IOUtils.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
            }
            entry = (TarArchiveEntry)in.getNextEntry();
        }
        in.close();
        return output;
    }

    private String getCheckSumLine(String name, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        return md5 + " " + name;
    }

    private void tar(File baseDir, PrintWriter checksumWriter, File file, ArchiveOutputStream os, Map<String, Integer> modeMappings) throws IOException {
        if (!baseDir.equals(file)) {
            int length = baseDir.getAbsolutePath().length();
            String name = file.getAbsolutePath().substring(length).replaceAll("\\\\", "/");
            TarArchiveEntry entry = new TarArchiveEntry(file);
            entry.setName(name);
            entry.setUserName(this.user);
            entry.setGroupName(this.group);
            if (modeMappings != null && modeMappings.containsKey(name)) {
                entry.setMode(modeMappings.get(name).intValue());
            }
            os.putArchiveEntry((ArchiveEntry)entry);
            if (file.isFile()) {
                if (checksumWriter != null) {
                    checksumWriter.println(this.getCheckSumLine(name, file));
                }
                FileInputStream is = new FileInputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                is.close();
            }
            os.closeArchiveEntry();
        }
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                this.tar(baseDir, checksumWriter, child, os, modeMappings);
            }
        }
    }

    private File tar(File src, File checksum, Map<String, Integer> modeMappings) throws IOException, ArchiveException {
        File output = new File(src.getParent(), src.getName() + ".tar");
        output.delete();
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)out);
        if (checksum == null) {
            this.tar(src, null, src, os, modeMappings);
        } else {
            PrintWriter checksumWriter = new PrintWriter(checksum);
            this.tar(src, checksumWriter, src, os, modeMappings);
            checksumWriter.close();
        }
        os.close();
        out.flush();
        ((OutputStream)out).close();
        return output;
    }

    private File ar(File folder, String name) throws IOException, ArchiveException {
        File output = new File(folder.getParent(), name + ".deb");
        output.delete();
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("ar", (OutputStream)out);
        this.ar(new File(folder, "debian-binary"), os);
        this.ar(new File(folder, "control.tar.gz"), os);
        this.ar(new File(folder, "data.tar.gz"), os);
        os.close();
        out.flush();
        ((OutputStream)out).close();
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ar(File file, ArchiveOutputStream os) throws IOException {
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry(file.getName(), file.length()));
        FileInputStream input = new FileInputStream(file);
        try {
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        finally {
            ((InputStream)input).close();
        }
        os.closeArchiveEntry();
    }

    public File expandTarGz(File tarGz) {
        try {
            File tar = this.uncompress(tarGz);
            File result = this.untar(tar);
            tar.delete();
            return result;
        }
        catch (Exception e) {
            throw new PackageException(e);
        }
    }

    public File buildDataTarGzFolder(File baseDir, Map<String, String> dirMappings) {
        File[] files;
        File dataTarGzDir = new File(baseDir.getParent(), "data");
        try {
            FileUtils.deleteDirectory((File)dataTarGzDir);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        int baseDirLength = baseDir.getAbsolutePath().length();
        for (File entry : files = baseDir.listFiles()) {
            String basePath = entry.getAbsolutePath().substring(baseDirLength).replaceAll("\\\\", "/");
            String dest = dirMappings.get(basePath);
            if (dest == null) {
                throw new PackageException("i don't know where the entry should go. Entry: " + basePath);
            }
            File destFile = new File(dataTarGzDir, dest);
            try {
                FileUtils.moveToDirectory((File)entry, (File)destFile, (boolean)true);
            }
            catch (IOException e) {
                throw new PackageException(e);
            }
        }
        try {
            FileUtils.deleteDirectory((File)baseDir);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        return dataTarGzDir;
    }

    public File compressTarGz(File src, File checksum, Map<String, Integer> modeMappings) {
        if (checksum != null) {
            checksum.delete();
        }
        try {
            File tar = this.tar(src, checksum, modeMappings);
            if (src.isDirectory()) {
                FileUtils.deleteDirectory((File)src);
            } else {
                src.delete();
            }
            File result = this.compress(tar);
            tar.delete();
            return result;
        }
        catch (Exception e) {
            throw new PackageException(e);
        }
    }

    public void createDebPackage(String isControl, String isPostinst, String isPrerm, File md5sums, File data, File deb) throws IOException {
        File debFolder = new File(deb.getParent(), "DEBIAN");
        debFolder.mkdirs();
        FileUtils.cleanDirectory((File)debFolder);
        FileUtils.moveToDirectory((File)data, (File)debFolder, (boolean)true);
        File control = new File(debFolder, "control");
        control.mkdirs();
        FileUtils.writeStringToFile((File)new File(control, "control"), (String)isControl);
        FileUtils.writeStringToFile((File)new File(control, "postinst"), (String)isPostinst);
        FileUtils.writeStringToFile((File)new File(control, "prerm"), (String)isPrerm);
        FileUtils.moveToDirectory((File)md5sums, (File)control, (boolean)true);
        FileUtils.writeStringToFile((File)new File(debFolder, "debian-binary"), (String)"2.0\n");
        this.compressTarGz(control, null, null);
        try {
            this.ar(debFolder, FilenameUtils.getBaseName((String)deb.getName()));
        }
        catch (ArchiveException e) {
            throw new PackageException(e);
        }
        FileUtils.deleteDirectory((File)debFolder);
    }

    public File createDebPackage(String name, String version, File sourceTarGz, String isControl, String isPostinst, String isPrerm, Map<String, String> dirMapping, Map<String, Integer> modeMapping) {
        File expandedTarGz = this.expandTarGz(sourceTarGz);
        File dataTarGzFolder = this.buildDataTarGzFolder(expandedTarGz.listFiles()[0], dirMapping);
        File md5sums = new File(sourceTarGz.getParent(), "md5sums");
        File data = this.compressTarGz(dataTarGzFolder, md5sums, modeMapping);
        File deb = new File(sourceTarGz.getParent(), name + "-" + version + ".deb");
        try {
            this.createDebPackage("Installed-Size: " + this.size / 1024L + "\n" + isControl, isPostinst, isPrerm, md5sums, data, deb);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        try {
            FileUtils.deleteDirectory((File)expandedTarGz);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        return deb;
    }
}

