/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGEMatrix {
    private List<List<Object>> rows;
    private int numCols;
    private String name;

    public PGEMatrix() {
        this(null, 0, 0);
    }

    public PGEMatrix(String name, int numrows, int numcols) {
        this.rows = new Vector<List<Object>>(numrows);
        this.numCols = numcols;
        this.name = name;
        for (int i = 0; i < numrows; ++i) {
            Vector colVector = new Vector(numcols);
            this.rows.add(i, colVector);
        }
    }

    public void addValue(Object value, int row, int col) {
        if (row > this.rows.size() || row < 0 || col > this.numCols || col < 0) {
            return;
        }
        this.rows.get(row).add(col, value);
    }

    public Object getValue(int row, int col) {
        if (row > this.rows.size() || row < 0 || col > this.numCols || col < 0) {
            return null;
        }
        return this.rows.get(row).get(col);
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Object>> rows) {
        this.rows = rows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
    }
}

