/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.pcs.input;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oodt.pcs.input.PGEConfigFileException;
import org.apache.oodt.pcs.input.PGEConfigurationFile;
import org.apache.oodt.pcs.input.PGEGroup;
import org.apache.oodt.pcs.input.PGEMatrix;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;
import org.apache.oodt.pcs.input.PGEXMLFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PGEConfigFileReader {
    public PGEConfigurationFile read(URL url) throws PGEConfigFileException {
        PGEConfigurationFile configFile = null;
        try {
            configFile = this.read(url.openStream());
        }
        catch (IOException e) {
            throw new PGEConfigFileException("Unable to read PGE configuration file from url: " + url + ": Message: " + e.getMessage());
        }
        return configFile;
    }

    public PGEConfigurationFile read(InputStream is) throws PGEConfigFileException {
        PGEConfigurationFile configFile = null;
        DocumentBuilderFactory factory = null;
        DocumentBuilder parser = null;
        Document document = null;
        if (is == null) {
            return null;
        }
        InputSource inputSource = new InputSource(is);
        try {
            factory = DocumentBuilderFactory.newInstance();
            parser = factory.newDocumentBuilder();
            document = parser.parse(inputSource);
        }
        catch (Exception parseException) {
            parseException.printStackTrace();
            return null;
        }
        configFile = new PGEConfigurationFile();
        Element pgeConf = document.getDocumentElement();
        NodeList pgeGroups = pgeConf.getElementsByTagName("group");
        for (int i = 0; i < pgeGroups.getLength(); ++i) {
            Element group = (Element)pgeGroups.item(i);
            String groupName = group.getAttribute("name");
            if (groupName.equals("PGENameGroup")) {
                this.addPGEName(configFile, group);
                continue;
            }
            if (groupName.equals("InputProductFiles")) {
                this.addInputProductFiles(configFile, group);
                continue;
            }
            if (groupName.equals("StaticFileIdentificationFiles")) {
                this.addSFIFFiles(configFile, group);
                continue;
            }
            if (groupName.equals("DynamicAuxiliaryInputFiles")) {
                this.addDynamicAuxInputFiles(configFile, group);
                continue;
            }
            if (groupName.equals("RecordedAuxiliaryInputFiles")) {
                this.addRecAuxInputFiles(configFile, group);
                continue;
            }
            if (groupName.equals("ProductPathGroup")) {
                this.addProductPath(configFile, group);
                continue;
            }
            if (groupName.equals("MonitorGroup")) {
                this.addMonitorGroup(configFile, group);
                continue;
            }
            if (groupName.equals("MonitorLevel")) {
                this.addMonitorLevels(configFile, group);
                continue;
            }
            this.addPGESpecificGroup(configFile, group);
        }
        return configFile;
    }

    private void addPGESpecificGroup(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        List vectors = PGEXMLFileUtils.getVectors(group);
        List matrixs = PGEXMLFileUtils.getMatrixs(group);
        PGEGroup pgeGroup = new PGEGroup(group.getAttribute("name"));
        for (PGEScalar s : scalars) {
            pgeGroup.addScalar(s);
        }
        for (PGEVector v : vectors) {
            pgeGroup.addVector(v);
        }
        for (PGEMatrix m : matrixs) {
            pgeGroup.addMatrix(m);
        }
        configFile.getPgeSpecificGroups().put(pgeGroup.getName(), pgeGroup);
    }

    private void addMonitorLevels(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        if (scalars != null && scalars.size() > 0) {
            for (PGEScalar scalar : scalars) {
                configFile.getMonitorLevelGroup().addScalar(scalar);
            }
        }
    }

    private void addMonitorGroup(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        if (scalars == null) {
            throw new PGEConfigFileException("There is no monitor path or monitor filename format defined in the MonitorGroup!");
        }
        PGEScalar monPath = null;
        PGEScalar monFilenameFormat = null;
        for (PGEScalar scalar : scalars) {
            if (scalar.getName().equals("MonitorPath")) {
                monPath = scalar;
                continue;
            }
            if (!scalar.getName().equals("MonitorFilenameFormat")) continue;
            monFilenameFormat = scalar;
        }
        configFile.setMonitorPath(monPath);
        configFile.setMonitorFilenameFormat(monFilenameFormat);
    }

    private void addProductPath(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        if (scalars == null || scalars != null && scalars.size() != 1) {
            throw new PGEConfigFileException("There is no product path defined in the configuration file, or there is more than one scalar listed in the ProductPathGroup!");
        }
        PGEScalar scalar = (PGEScalar)scalars.get(0);
        if (!scalar.getName().equals("ProductPath")) {
            throw new PGEConfigFileException("The product path should be defined as a scalar with the name \"ProductPath\"!");
        }
        configFile.setProductPath(scalar);
    }

    private void addPGEName(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        if (scalars == null || scalars != null && scalars.size() != 1) {
            throw new PGEConfigFileException("There is no PGEName defined in the configuration file, or there is more than one scalar listed in the PGENameGroup");
        }
        PGEScalar scalar = (PGEScalar)scalars.get(0);
        if (!scalar.getName().equals("PGEName")) {
            throw new PGEConfigFileException("The name of the PGE should be defined as a scalar with the name \"PGEName\"!");
        }
        configFile.setPgeName(scalar);
    }

    private void addInputProductFiles(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        this.addScalarFilesToGroup(group, configFile.getInputProductFiles());
        this.addVectorFilesToGroup(group, configFile.getInputProductFiles());
    }

    private void addSFIFFiles(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        this.addScalarFilesToGroup(group, configFile.getStaticFileIdentificationFiles());
    }

    private void addDynamicAuxInputFiles(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        this.addScalarFilesToGroup(group, configFile.getDynamicAuxiliaryInputFiles());
    }

    private void addRecAuxInputFiles(PGEConfigurationFile configFile, Element group) throws PGEConfigFileException {
        this.addScalarFilesToGroup(group, configFile.getRecordedAuxiliaryInputFiles());
    }

    private void addScalarFilesToGroup(Element group, PGEGroup pgeGroup) throws PGEConfigFileException {
        List scalars = PGEXMLFileUtils.getScalars(group);
        if (scalars != null && scalars.size() > 0) {
            for (PGEScalar scalar : scalars) {
                pgeGroup.addScalar(scalar);
            }
        }
    }

    private void addVectorFilesToGroup(Element group, PGEGroup pgeGroup) throws PGEConfigFileException {
        List vectors = PGEXMLFileUtils.getVectors(group);
        if (vectors != null && vectors.size() > 0) {
            for (PGEVector vector : vectors) {
                pgeGroup.addVector(vector);
            }
        }
    }
}

