/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.lightweight;

import java.util.Map;
import org.apache.oodt.profile.handlers.lightweight.Intersection;
import org.apache.oodt.profile.handlers.lightweight.OrExpression;
import org.apache.oodt.profile.handlers.lightweight.Result;
import org.apache.oodt.profile.handlers.lightweight.SearchableResourceAttributes;
import org.apache.oodt.profile.handlers.lightweight.WhereExpression;

class AndExpression
implements WhereExpression {
    private WhereExpression lhs;
    private WhereExpression rhs;

    public AndExpression(WhereExpression lhs, WhereExpression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Result result(SearchableResourceAttributes resAttr, Map elements) {
        return new Intersection(this.lhs.result(resAttr, elements), this.rhs.result(resAttr, elements));
    }

    @Override
    public WhereExpression simplify() {
        this.lhs = this.lhs.simplify();
        this.rhs = this.rhs.simplify();
        return this;
    }

    @Override
    public WhereExpression negate() {
        return new OrExpression(this.lhs.negate(), this.rhs.negate());
    }

    public String toString() {
        return "and[" + this.lhs + "," + this.rhs + "]";
    }
}

