/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.cas;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.filemgr.structs.Element;
import org.apache.oodt.cas.filemgr.structs.Product;
import org.apache.oodt.cas.filemgr.structs.ProductType;
import org.apache.oodt.cas.filemgr.structs.Query;
import org.apache.oodt.cas.filemgr.structs.QueryCriteria;
import org.apache.oodt.cas.filemgr.structs.TermQueryCriteria;
import org.apache.oodt.cas.filemgr.system.XmlRpcFileManagerClient;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileException;
import org.apache.oodt.profile.handlers.ProfileHandler;
import org.apache.oodt.profile.handlers.cas.util.ProfileUtils;
import org.apache.oodt.xmlquery.QueryElement;
import org.apache.oodt.xmlquery.XMLQuery;

public class CASProfileHandler
implements ProfileHandler {
    private static final Logger LOG = Logger.getLogger(CASProfileHandler.class.getName());
    private XmlRpcFileManagerClient fmClient = null;
    private String dataDelivBaseUrlStr = null;
    private List productTypeFilter = null;

    public CASProfileHandler() throws InstantiationException {
        String filemgrUrlStr = System.getProperty("org.apache.oodt.cas.profile.fmUrl", "http://localhost:9000");
        try {
            this.fmClient = new XmlRpcFileManagerClient(new URL(filemgrUrlStr));
        }
        catch (Exception e) {
            throw new InstantiationException("Error communicating with the filemgr: [" + filemgrUrlStr + "]: message: " + e.getMessage());
        }
        this.dataDelivBaseUrlStr = System.getProperty("org.apache.oodt.cas.profile.dataDelivBaseUrl", "http://localhost:8080/filemgr/data");
        this.productTypeFilter = this.buildFilter(System.getProperty("org.apache.oodt.cas.profile.product.types"));
    }

    @Override
    public List findProfiles(XMLQuery query) throws ProfileException {
        Vector profs = new Vector();
        if (this.productTypeFilter != null && this.productTypeFilter.size() > 0) {
            for (ProductType type : this.productTypeFilter) {
                Query cQuery = this.convertQuery(query);
                profs.addAll(this.queryAndBuildProfiles(type, cQuery));
            }
        }
        return profs;
    }

    @Override
    public Profile get(String arg0) throws ProfileException {
        throw new ProfileException("Method not implemented yet");
    }

    @Override
    public String getID() {
        return "CAS Filemgr Profile Handler";
    }

    private List safeGetProductTypes() {
        List types = null;
        try {
            types = this.fmClient.getProductTypes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return types;
    }

    private List safeGetProducts(ProductType type) {
        List products = null;
        try {
            products = this.fmClient.getProductsByProductType(type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return products;
    }

    private ProductType safeGetProductTypeByName(String name) {
        ProductType type = null;
        try {
            type = this.fmClient.getProductTypeByName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    private Metadata safeGetMetadata(Product p) {
        Metadata met = null;
        try {
            met = this.fmClient.getMetadata(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return met;
    }

    private List safeGetProductReferences(Product p) {
        List references = null;
        try {
            references = this.fmClient.getProductReferences(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return references;
    }

    private Element safeGetElementByName(String name) {
        Element elem = null;
        try {
            elem = this.fmClient.getElementByName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elem;
    }

    private List buildFilter(String productTypeNames) {
        List<ProductType> typeFilter = new Vector();
        if (productTypeNames == null) {
            typeFilter = this.safeGetProductTypes();
        } else {
            String[] typeNames = productTypeNames.split(",");
            if (typeNames != null) {
                for (int i = 0; i < typeNames.length; ++i) {
                    ProductType type = this.safeGetProductTypeByName(typeNames[i]);
                    typeFilter.add(type);
                }
            } else {
                LOG.log(Level.WARNING, "Unable to parse comma delimited type string: [" + productTypeNames + "]: using all types");
                typeFilter = this.safeGetProductTypes();
            }
        }
        return typeFilter;
    }

    private Query convertQuery(XMLQuery xmlQuery) {
        Query query = new Query();
        if (xmlQuery.getWhereElementSet() != null && xmlQuery.getWhereElementSet().size() > 0) {
            Iterator i = xmlQuery.getWhereElementSet().iterator();
            while (i.hasNext()) {
                QueryElement elem = (QueryElement)i.next();
                if (!elem.getRole().equals("elemName")) continue;
                String elemName = elem.getValue();
                QueryElement litElem = (QueryElement)i.next();
                if (!litElem.getRole().equals("LITERAL")) {
                    LOG.log(Level.WARNING, "next element not literal: element: [" + litElem + "]: malformed xml query!");
                    break;
                }
                String elemValue = litElem.getValue();
                TermQueryCriteria crit = new TermQueryCriteria();
                crit.setElementName(elemName);
                crit.setValue(elemValue);
                query.addCriterion((QueryCriteria)crit);
            }
        }
        return query;
    }

    private List queryAndBuildProfiles(ProductType type, Query query) {
        Vector<Profile> profiles = new Vector<Profile>();
        List products = null;
        try {
            products = this.fmClient.query(query, type);
            if (products != null && products.size() > 0) {
                for (Product p : products) {
                    p.setProductReferences(this.safeGetProductReferences(p));
                    Metadata met = this.safeGetMetadata(p);
                    try {
                        profiles.add(ProfileUtils.buildProfile(p, met, this.dataDelivBaseUrlStr));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception querying the file manager for products: Message: " + e.getMessage());
        }
        return profiles;
    }
}

