/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileElement;
import org.apache.oodt.profile.RangedProfileElement;
import org.apache.oodt.profile.gui.LeafListener;
import org.apache.oodt.profile.gui.profileTree;
import org.apache.oodt.profile.gui.pstructs.ProfilePrinter;
import org.xml.sax.SAXException;

public class ProfileBuilderGUI
extends JFrame {
    private JButton jButton1;
    private JEditorPane jEditorPane1;
    private JScrollPane jPanel3;
    private profileTree jTree1;
    private JScrollPane jPanel2;
    private JPanel jPanel1;
    private JMenuItem helpMenuItem;
    private JMenu jMenu5;
    private JMenuItem deleteMenuItem;
    private JSeparator jSeparator1;
    private JMenuItem pasteMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu jMenu4;
    private JMenuItem exitMenuItem;
    private JSeparator jSeparator2;
    private JMenuItem closeFileMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem openFileMenuItem;
    private JMenuItem newFileMenuItem;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private Profile createdProfile = null;

    public ProfileBuilderGUI() {
        this.initGUI();
    }

    public void initGUI() {
        try {
            this.preInitGUI();
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jPanel1 = new JPanel();
            this.jPanel2 = new JScrollPane();
            this.jTree1 = new profileTree();
            this.jPanel3 = new JScrollPane();
            this.jEditorPane1 = new JEditorPane();
            this.jButton1 = new JButton();
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            thisLayout.setHgap(0);
            thisLayout.setVgap(0);
            this.setTitle("OODT Profile Builder");
            this.setSize(new Dimension(682, 387));
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHgap(0);
            jPanel1Layout.setVgap(0);
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel2.setPreferredSize(new Dimension(231, 339));
            this.jPanel2.setAutoscrolls(true);
            this.jPanel1.add((Component)this.jPanel2, "West");
            this.jTree1.setEditable(true);
            this.jTree1.setPreferredSize(new Dimension(426, 800));
            this.jTree1.setAutoscrolls(true);
            this.jTree1.setMaximumSize(new Dimension(426, 800));
            this.jTree1.setOpaque(true);
            this.jTree1.setSize(new Dimension(426, 800));
            this.jPanel2.add(this.jTree1);
            this.jPanel2.setViewportView(this.jTree1);
            this.jPanel3.setPreferredSize(new Dimension(444, 339));
            this.jPanel3.setAutoscrolls(true);
            this.jPanel1.add((Component)this.jPanel3, "East");
            this.jEditorPane1.setEditable(false);
            this.jEditorPane1.setPreferredSize(new Dimension(414, 320));
            this.jEditorPane1.setAutoscrolls(true);
            this.jPanel3.add(this.jEditorPane1);
            this.jPanel3.setViewportView(this.jEditorPane1);
            this.jButton1.setText("Show XML");
            this.getContentPane().add((Component)this.jButton1, "South");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProfileBuilderGUI.this.jButton1ActionPerformed(evt);
                }
            });
            this.jMenuBar1 = new JMenuBar();
            this.jMenu3 = new JMenu();
            this.newFileMenuItem = new JMenuItem();
            this.openFileMenuItem = new JMenuItem();
            this.saveMenuItem = new JMenuItem();
            this.closeFileMenuItem = new JMenuItem();
            this.jSeparator2 = new JSeparator();
            this.exitMenuItem = new JMenuItem();
            this.jMenu4 = new JMenu();
            this.cutMenuItem = new JMenuItem();
            this.copyMenuItem = new JMenuItem();
            this.pasteMenuItem = new JMenuItem();
            this.jSeparator1 = new JSeparator();
            this.deleteMenuItem = new JMenuItem();
            this.jMenu5 = new JMenu();
            this.helpMenuItem = new JMenuItem();
            this.setJMenuBar(this.jMenuBar1);
            this.jMenu3.setText("File");
            this.jMenu3.setVisible(true);
            this.jMenuBar1.add(this.jMenu3);
            this.newFileMenuItem.setText("New Profile");
            this.newFileMenuItem.setVisible(true);
            this.newFileMenuItem.setPreferredSize(new Dimension(28, 16));
            this.newFileMenuItem.setBounds(new Rectangle(5, 5, 28, 16));
            this.jMenu3.add(this.newFileMenuItem);
            this.newFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProfileBuilderGUI.this.newFileMenuItemActionPerformed(evt);
                }
            });
            this.openFileMenuItem.setText("Open Profile");
            this.openFileMenuItem.setVisible(true);
            this.openFileMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu3.add(this.openFileMenuItem);
            this.openFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProfileBuilderGUI.this.openFileMenuItemActionPerformed(evt);
                }
            });
            this.saveMenuItem.setText("Save Profile");
            this.saveMenuItem.setVisible(true);
            this.saveMenuItem.setVerifyInputWhenFocusTarget(false);
            this.saveMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu3.add(this.saveMenuItem);
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProfileBuilderGUI.this.saveMenuItemActionPerformed(evt);
                }
            });
            this.closeFileMenuItem.setText("Close");
            this.closeFileMenuItem.setVisible(true);
            this.closeFileMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu3.add(this.closeFileMenuItem);
            this.jSeparator2.setVisible(true);
            this.jSeparator2.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu3.add(this.jSeparator2);
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.setVisible(true);
            this.exitMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu3.add(this.exitMenuItem);
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProfileBuilderGUI.this.exitMenuItemActionPerformed(evt);
                }
            });
            this.jMenu4.setText("Edit");
            this.jMenu4.setVisible(true);
            this.jMenuBar1.add(this.jMenu4);
            this.cutMenuItem.setText("Cut");
            this.cutMenuItem.setVisible(true);
            this.cutMenuItem.setPreferredSize(new Dimension(27, 16));
            this.cutMenuItem.setBounds(new Rectangle(5, 5, 27, 16));
            this.jMenu4.add(this.cutMenuItem);
            this.copyMenuItem.setText("Copy");
            this.copyMenuItem.setVisible(true);
            this.copyMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu4.add(this.copyMenuItem);
            this.pasteMenuItem.setText("Paste");
            this.pasteMenuItem.setVisible(true);
            this.pasteMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu4.add(this.pasteMenuItem);
            this.jSeparator1.setVisible(true);
            this.jSeparator1.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu4.add(this.jSeparator1);
            this.deleteMenuItem.setText("Delete");
            this.deleteMenuItem.setVisible(true);
            this.deleteMenuItem.setBounds(new Rectangle(5, 5, 60, 30));
            this.jMenu4.add(this.deleteMenuItem);
            this.jMenu5.setText("Help");
            this.jMenu5.setVisible(true);
            this.jMenuBar1.add(this.jMenu5);
            this.helpMenuItem.setText("Help");
            this.helpMenuItem.setVisible(true);
            this.helpMenuItem.setPreferredSize(new Dimension(31, 16));
            this.helpMenuItem.setBounds(new Rectangle(5, 5, 31, 16));
            this.jMenu5.add(this.helpMenuItem);
            this.postInitGUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preInitGUI() {
    }

    public void postInitGUI() {
    }

    public static void main(String[] args) {
        ProfileBuilderGUI.showMainGUI();
    }

    public static void showMainGUI() {
        try {
            ProfileBuilderGUI inst = new ProfileBuilderGUI();
            inst.setVisible(true);
            inst.getJTree1().addMouseListener(new LeafListener(inst.getJTree1()));
            inst.getJTree1().setExpandsSelectedPaths(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showGUI() {
        try {
            ProfileBuilderGUI inst = new ProfileBuilderGUI();
            inst.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPanel getJPanel1() {
        return this.jPanel1;
    }

    public JScrollPane getJPanel2() {
        return this.jPanel2;
    }

    public profileTree getJTree1() {
        return this.jTree1;
    }

    public void setJTree1(profileTree jt) {
        this.jTree1 = jt;
        this.repaint();
    }

    public JScrollPane getJPanel3() {
        return this.jPanel3;
    }

    public JEditorPane getJEditorPane1() {
        return this.jEditorPane1;
    }

    protected void newFileMenuItemActionPerformed(ActionEvent evt) {
        this.createdProfile = new Profile();
        this.jEditorPane1.setText(new ProfilePrinter(this.createdProfile, "http://oodt.jpl.nasa.gov/dtd/prof.dtd").toXMLString());
        this.getJTree1().setModel(this.generateModelFromProfile(this.createdProfile));
    }

    protected void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(1);
    }

    private void addElementsFromTreeNode(TreeNode t, List multiValueElem) {
        Enumeration<? extends TreeNode> i = t.children();
        while (i.hasMoreElements()) {
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)i.nextElement();
            String theStr = (String)theNode.getUserObject();
            multiValueElem.add(theStr);
        }
    }

    private Profile generateProfileFromModel(TreeModel dtm) {
        Profile p = new Profile();
        DefaultMutableTreeNode theProfileRoot = (DefaultMutableTreeNode)dtm.getRoot();
        TreeNode theProfAttrRoot = theProfileRoot.getChildAt(0);
        TreeNode theProfAttr_Children = theProfAttrRoot.getChildAt(0);
        this.addElementsFromTreeNode(theProfAttr_Children, p.getProfileAttributes().getChildren());
        TreeNode theProfAttr_IDRoot = theProfAttrRoot.getChildAt(1);
        DefaultMutableTreeNode theProfAttr_ID = (DefaultMutableTreeNode)theProfAttr_IDRoot.getChildAt(0);
        p.getProfileAttributes().setID((String)theProfAttr_ID.getUserObject());
        TreeNode theProfAttr_ParentRoot = theProfAttrRoot.getChildAt(2);
        DefaultMutableTreeNode theProfAttr_Parent = (DefaultMutableTreeNode)theProfAttr_ParentRoot.getChildAt(0);
        p.getProfileAttributes().setParent((String)theProfAttr_Parent.getUserObject());
        TreeNode theProfAttr_RegAuthorityRoot = theProfAttrRoot.getChildAt(3);
        DefaultMutableTreeNode theProfAttr_RegAuthority = (DefaultMutableTreeNode)theProfAttr_RegAuthorityRoot.getChildAt(0);
        p.getProfileAttributes().setRegAuthority((String)theProfAttr_RegAuthority.getUserObject());
        TreeNode theProfAttr_revNotes = theProfAttrRoot.getChildAt(4);
        this.addElementsFromTreeNode(theProfAttr_revNotes, p.getProfileAttributes().getRevisionNotes());
        TreeNode theProfAttr_SecurityTypeRoot = theProfAttrRoot.getChildAt(5);
        DefaultMutableTreeNode theProfAttr_SecurityType = (DefaultMutableTreeNode)theProfAttr_SecurityTypeRoot.getChildAt(0);
        p.getProfileAttributes().setSecurityType((String)theProfAttr_SecurityType.getUserObject());
        TreeNode theProfAttr_StatusIDRoot = theProfAttrRoot.getChildAt(6);
        DefaultMutableTreeNode theProfAttr_StatusID = (DefaultMutableTreeNode)theProfAttr_StatusIDRoot.getChildAt(0);
        p.getProfileAttributes().setStatusID((String)theProfAttr_StatusID.getUserObject());
        TreeNode theProfAttr_TypeRoot = theProfAttrRoot.getChildAt(7);
        DefaultMutableTreeNode theProfAttr_Type = (DefaultMutableTreeNode)theProfAttr_TypeRoot.getChildAt(0);
        p.getProfileAttributes().setType((String)theProfAttr_Type.getUserObject());
        TreeNode theProfAttr_VersionRoot = theProfAttrRoot.getChildAt(8);
        DefaultMutableTreeNode theProfAttr_Version = (DefaultMutableTreeNode)theProfAttr_VersionRoot.getChildAt(0);
        p.getProfileAttributes().setVersion((String)theProfAttr_Version.getUserObject());
        TreeNode theResAttrRoot = theProfileRoot.getChildAt(1);
        TreeNode ra_aggRoot = theResAttrRoot.getChildAt(0);
        TreeNode ra_classRoot = theResAttrRoot.getChildAt(1);
        TreeNode ra_contextRoot = theResAttrRoot.getChildAt(2);
        TreeNode ra_contribRoot = theResAttrRoot.getChildAt(3);
        TreeNode ra_coverageRoot = theResAttrRoot.getChildAt(4);
        TreeNode ra_creatorRoot = theResAttrRoot.getChildAt(5);
        TreeNode ra_datesRoot = theResAttrRoot.getChildAt(6);
        TreeNode ra_descRoot = theResAttrRoot.getChildAt(7);
        TreeNode ra_formatsRoot = theResAttrRoot.getChildAt(8);
        TreeNode ra_identifierRoot = theResAttrRoot.getChildAt(9);
        TreeNode ra_langRoot = theResAttrRoot.getChildAt(10);
        TreeNode ra_locationRoot = theResAttrRoot.getChildAt(11);
        TreeNode ra_publishersRoot = theResAttrRoot.getChildAt(12);
        TreeNode ra_relationsRoot = theResAttrRoot.getChildAt(13);
        TreeNode ra_rightsRoot = theResAttrRoot.getChildAt(14);
        TreeNode ra_sourcesRoot = theResAttrRoot.getChildAt(15);
        TreeNode ra_subjectsRoot = theResAttrRoot.getChildAt(16);
        TreeNode ra_titleRoot = theResAttrRoot.getChildAt(17);
        TreeNode ra_typesRoot = theResAttrRoot.getChildAt(18);
        DefaultMutableTreeNode ra_agg = (DefaultMutableTreeNode)ra_aggRoot.getChildAt(0);
        DefaultMutableTreeNode ra_class = (DefaultMutableTreeNode)ra_classRoot.getChildAt(0);
        p.getResourceAttributes().setResAggregation((String)ra_agg.getUserObject());
        p.getResourceAttributes().setResClass((String)ra_class.getUserObject());
        this.addElementsFromTreeNode(ra_contextRoot, p.getResourceAttributes().getResContexts());
        this.addElementsFromTreeNode(ra_contribRoot, p.getResourceAttributes().getContributors());
        this.addElementsFromTreeNode(ra_coverageRoot, p.getResourceAttributes().getCoverages());
        this.addElementsFromTreeNode(ra_creatorRoot, p.getResourceAttributes().getCreators());
        this.addElementsFromTreeNode(ra_datesRoot, p.getResourceAttributes().getDates());
        DefaultMutableTreeNode ra_desc = (DefaultMutableTreeNode)ra_descRoot.getChildAt(0);
        DefaultMutableTreeNode ra_identifier = (DefaultMutableTreeNode)ra_identifierRoot.getChildAt(0);
        p.getResourceAttributes().setDescription((String)ra_desc.getUserObject());
        p.getResourceAttributes().setIdentifier((String)ra_identifier.getUserObject());
        this.addElementsFromTreeNode(ra_formatsRoot, p.getResourceAttributes().getFormats());
        this.addElementsFromTreeNode(ra_langRoot, p.getResourceAttributes().getLanguages());
        this.addElementsFromTreeNode(ra_locationRoot, p.getResourceAttributes().getResLocations());
        this.addElementsFromTreeNode(ra_publishersRoot, p.getResourceAttributes().getPublishers());
        this.addElementsFromTreeNode(ra_relationsRoot, p.getResourceAttributes().getRelations());
        this.addElementsFromTreeNode(ra_rightsRoot, p.getResourceAttributes().getRights());
        this.addElementsFromTreeNode(ra_sourcesRoot, p.getResourceAttributes().getSources());
        this.addElementsFromTreeNode(ra_subjectsRoot, p.getResourceAttributes().getSubjects());
        this.addElementsFromTreeNode(ra_typesRoot, p.getResourceAttributes().getTypes());
        DefaultMutableTreeNode ra_title = (DefaultMutableTreeNode)ra_titleRoot.getChildAt(0);
        p.getResourceAttributes().setTitle((String)ra_title.getUserObject());
        TreeNode theProfElemRoot = theProfileRoot.getChildAt(2);
        Enumeration<? extends TreeNode> e = theProfElemRoot.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode profElemN_Root = (DefaultMutableTreeNode)e.nextElement();
            System.out.println("Got Profile Element " + (String)profElemN_Root.getUserObject());
            ProfileElement profElem = this.makeProfileElementFromTreeNode(p, profElemN_Root);
            if (profElem == null) continue;
            System.out.println("Making profile element");
            System.out.println(profElem.toString());
            p.getProfileElements().put((String)profElemN_Root.getUserObject(), profElem);
        }
        return p;
    }

    private ProfileElement makeProfileElementFromTreeNode(Profile theProfile, DefaultMutableTreeNode tn) {
        RangedProfileElement theProfileElement = new RangedProfileElement(theProfile);
        DefaultMutableTreeNode commentRoot = (DefaultMutableTreeNode)tn.getChildAt(0);
        DefaultMutableTreeNode descRoot = (DefaultMutableTreeNode)tn.getChildAt(1);
        DefaultMutableTreeNode idRoot = (DefaultMutableTreeNode)tn.getChildAt(2);
        DefaultMutableTreeNode moRoot = (DefaultMutableTreeNode)tn.getChildAt(3);
        DefaultMutableTreeNode synRoot = (DefaultMutableTreeNode)tn.getChildAt(4);
        DefaultMutableTreeNode typeRoot = (DefaultMutableTreeNode)tn.getChildAt(5);
        DefaultMutableTreeNode unitRoot = (DefaultMutableTreeNode)tn.getChildAt(6);
        DefaultMutableTreeNode pe_Comments = (DefaultMutableTreeNode)commentRoot.getChildAt(0);
        DefaultMutableTreeNode pe_desc = (DefaultMutableTreeNode)descRoot.getChildAt(0);
        DefaultMutableTreeNode pe_id = (DefaultMutableTreeNode)idRoot.getChildAt(0);
        DefaultMutableTreeNode pe_mo = (DefaultMutableTreeNode)moRoot.getChildAt(0);
        DefaultMutableTreeNode pe_type = (DefaultMutableTreeNode)typeRoot.getChildAt(0);
        DefaultMutableTreeNode pe_unit = (DefaultMutableTreeNode)unitRoot.getChildAt(0);
        this.addElementsFromTreeNode(synRoot, theProfileElement.getSynonyms());
        theProfileElement.setName((String)tn.getUserObject());
        theProfileElement.setComments((String)pe_Comments.getUserObject());
        theProfileElement.setDescription((String)pe_desc.getUserObject());
        theProfileElement.setID((String)pe_id.getUserObject());
        theProfileElement.setMaxOccurrence(Integer.parseInt((String)pe_mo.getUserObject()));
        theProfileElement.setType((String)pe_type.getUserObject());
        theProfileElement.setUnit((String)pe_unit.getUserObject());
        return theProfileElement;
    }

    private DefaultTreeModel generateModelFromProfile(Profile p) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Profile");
        DefaultMutableTreeNode resAttrRoot = new DefaultMutableTreeNode("Resource Attributes");
        DefaultMutableTreeNode profAttrRoot = new DefaultMutableTreeNode("Profile Attributes");
        DefaultMutableTreeNode profElemRoot = new DefaultMutableTreeNode("Profile Elements");
        DefaultMutableTreeNode profAttr_children = new DefaultMutableTreeNode("Children");
        for (String theChild : p.getProfileAttributes().getChildren()) {
            DefaultMutableTreeNode profAttr_childN = new DefaultMutableTreeNode(theChild);
            profAttr_children.add(profAttr_childN);
        }
        DefaultMutableTreeNode profAttr_id = new DefaultMutableTreeNode("Id");
        profAttr_id.add(new DefaultMutableTreeNode(p.getProfileAttributes().getID()));
        DefaultMutableTreeNode profAttr_parent = new DefaultMutableTreeNode("Parent");
        profAttr_parent.add(new DefaultMutableTreeNode(p.getProfileAttributes().getParent()));
        DefaultMutableTreeNode profAttr_regAuth = new DefaultMutableTreeNode("Registration Authority");
        profAttr_regAuth.add(new DefaultMutableTreeNode(p.getProfileAttributes().getRegAuthority()));
        DefaultMutableTreeNode profAttr_revNotes = new DefaultMutableTreeNode("Revision Notes");
        for (String revNoteString : p.getProfileAttributes().getRevisionNotes()) {
            DefaultMutableTreeNode revNote_Child = new DefaultMutableTreeNode(revNoteString);
            profAttr_revNotes.add(revNote_Child);
        }
        DefaultMutableTreeNode profAttr_securityType = new DefaultMutableTreeNode("Security Type");
        profAttr_securityType.add(new DefaultMutableTreeNode(p.getProfileAttributes().getSecurityType()));
        DefaultMutableTreeNode profAttr_statusID = new DefaultMutableTreeNode("Status ID");
        profAttr_statusID.add(new DefaultMutableTreeNode(p.getProfileAttributes().getStatusID()));
        DefaultMutableTreeNode profAttr_type = new DefaultMutableTreeNode("Type");
        profAttr_type.add(new DefaultMutableTreeNode(p.getProfileAttributes().getType()));
        DefaultMutableTreeNode profAttr_version = new DefaultMutableTreeNode("Version");
        profAttr_version.add(new DefaultMutableTreeNode(p.getProfileAttributes().getVersion()));
        profAttrRoot.add(profAttr_children);
        profAttrRoot.add(profAttr_id);
        profAttrRoot.add(profAttr_parent);
        profAttrRoot.add(profAttr_regAuth);
        profAttrRoot.add(profAttr_revNotes);
        profAttrRoot.add(profAttr_securityType);
        profAttrRoot.add(profAttr_statusID);
        profAttrRoot.add(profAttr_type);
        profAttrRoot.add(profAttr_version);
        DefaultMutableTreeNode resAttr_aggregation = new DefaultMutableTreeNode("Aggregation");
        resAttr_aggregation.add(new DefaultMutableTreeNode(p.getResourceAttributes().getResAggregation()));
        DefaultMutableTreeNode resAttr_class = new DefaultMutableTreeNode("Class");
        resAttr_class.add(new DefaultMutableTreeNode(p.getResourceAttributes().getResClass()));
        DefaultMutableTreeNode resAttr_contexts = new DefaultMutableTreeNode("Contexts");
        for (String theContext : p.getResourceAttributes().getResContexts()) {
            DefaultMutableTreeNode resAttr_contextN = new DefaultMutableTreeNode(theContext);
            resAttr_contexts.add(resAttr_contextN);
        }
        DefaultMutableTreeNode resAttr_contributors = new DefaultMutableTreeNode("Contributors");
        for (String theContributor : p.getResourceAttributes().getContributors()) {
            DefaultMutableTreeNode resAttr_contribN = new DefaultMutableTreeNode(theContributor);
            resAttr_contributors.add(resAttr_contribN);
        }
        DefaultMutableTreeNode resAttr_coverages = new DefaultMutableTreeNode("Coverages");
        for (String theCoverage : p.getResourceAttributes().getCoverages()) {
            DefaultMutableTreeNode resAttr_coverageN = new DefaultMutableTreeNode(theCoverage);
            resAttr_coverages.add(resAttr_coverageN);
        }
        DefaultMutableTreeNode resAttr_creators = new DefaultMutableTreeNode("Creators");
        for (String theCreator : p.getResourceAttributes().getCreators()) {
            DefaultMutableTreeNode resAttr_creatorN = new DefaultMutableTreeNode(theCreator);
            resAttr_creators.add(resAttr_creatorN);
        }
        DefaultMutableTreeNode resAttr_dates = new DefaultMutableTreeNode("Dates");
        for (String theDate : p.getResourceAttributes().getDates()) {
            DefaultMutableTreeNode resAttr_dateN = new DefaultMutableTreeNode(theDate);
            resAttr_dates.add(resAttr_dateN);
        }
        DefaultMutableTreeNode resAttr_description = new DefaultMutableTreeNode("Description");
        resAttr_description.add(new DefaultMutableTreeNode(p.getResourceAttributes().getDescription()));
        DefaultMutableTreeNode resAttr_formats = new DefaultMutableTreeNode("Formats");
        for (String theFormat : p.getResourceAttributes().getFormats()) {
            DefaultMutableTreeNode resAttr_formatN = new DefaultMutableTreeNode(theFormat);
            resAttr_formats.add(resAttr_formatN);
        }
        DefaultMutableTreeNode resAttr_identifier = new DefaultMutableTreeNode("Identifier");
        resAttr_identifier.add(new DefaultMutableTreeNode(p.getResourceAttributes().getIdentifier()));
        DefaultMutableTreeNode resAttr_languages = new DefaultMutableTreeNode("Languages");
        for (String theLanguage : p.getResourceAttributes().getLanguages()) {
            DefaultMutableTreeNode resAttr_langN = new DefaultMutableTreeNode(theLanguage);
            resAttr_languages.add(resAttr_langN);
        }
        DefaultMutableTreeNode resAttr_locations = new DefaultMutableTreeNode("Resource Locations");
        for (String theLoc : p.getResourceAttributes().getResLocations()) {
            DefaultMutableTreeNode resAttr_locN = new DefaultMutableTreeNode(theLoc);
            resAttr_locations.add(resAttr_locN);
        }
        DefaultMutableTreeNode resAttr_publishers = new DefaultMutableTreeNode("Publishers");
        for (String thePublisher : p.getResourceAttributes().getPublishers()) {
            DefaultMutableTreeNode resAttr_pubN = new DefaultMutableTreeNode(thePublisher);
            resAttr_publishers.add(resAttr_pubN);
        }
        DefaultMutableTreeNode resAttr_relations = new DefaultMutableTreeNode("Relations");
        for (String theRelation : p.getResourceAttributes().getRelations()) {
            DefaultMutableTreeNode resAttr_relationN = new DefaultMutableTreeNode(theRelation);
            resAttr_relations.add(resAttr_relationN);
        }
        DefaultMutableTreeNode resAttr_rights = new DefaultMutableTreeNode("Rights");
        for (String theRight : p.getResourceAttributes().getRights()) {
            DefaultMutableTreeNode resAttr_rightN = new DefaultMutableTreeNode(theRight);
            resAttr_rights.add(resAttr_rightN);
        }
        DefaultMutableTreeNode resAttr_sources = new DefaultMutableTreeNode("Sources");
        for (String theSource : p.getResourceAttributes().getSources()) {
            DefaultMutableTreeNode resAttr_sourceN = new DefaultMutableTreeNode(theSource);
            resAttr_sources.add(resAttr_sourceN);
        }
        DefaultMutableTreeNode resAttr_subjects = new DefaultMutableTreeNode("Subjects");
        for (String theSubject : p.getResourceAttributes().getSubjects()) {
            DefaultMutableTreeNode resAttr_subjectN = new DefaultMutableTreeNode(theSubject);
            resAttr_subjects.add(resAttr_subjectN);
        }
        DefaultMutableTreeNode resAttr_title = new DefaultMutableTreeNode("Title");
        resAttr_title.add(new DefaultMutableTreeNode(p.getResourceAttributes().getTitle()));
        DefaultMutableTreeNode resAttr_types = new DefaultMutableTreeNode("Types");
        for (String theType : p.getResourceAttributes().getTypes()) {
            DefaultMutableTreeNode resAttr_typeN = new DefaultMutableTreeNode(theType);
            resAttr_types.add(resAttr_typeN);
        }
        resAttrRoot.add(resAttr_aggregation);
        resAttrRoot.add(resAttr_class);
        resAttrRoot.add(resAttr_contexts);
        resAttrRoot.add(resAttr_contributors);
        resAttrRoot.add(resAttr_coverages);
        resAttrRoot.add(resAttr_creators);
        resAttrRoot.add(resAttr_dates);
        resAttrRoot.add(resAttr_description);
        resAttrRoot.add(resAttr_formats);
        resAttrRoot.add(resAttr_identifier);
        resAttrRoot.add(resAttr_languages);
        resAttrRoot.add(resAttr_locations);
        resAttrRoot.add(resAttr_publishers);
        resAttrRoot.add(resAttr_relations);
        resAttrRoot.add(resAttr_rights);
        resAttrRoot.add(resAttr_sources);
        resAttrRoot.add(resAttr_subjects);
        resAttrRoot.add(resAttr_title);
        resAttrRoot.add(resAttr_types);
        for (String peKey : p.getProfileElements().keySet()) {
            ProfileElement theProfileElement = (ProfileElement)p.getProfileElements().get(peKey);
            DefaultMutableTreeNode thePENode = new DefaultMutableTreeNode(theProfileElement.getName());
            DefaultMutableTreeNode theCommentsRoot = new DefaultMutableTreeNode("Comments");
            DefaultMutableTreeNode theComments = new DefaultMutableTreeNode(theProfileElement.getComments());
            theCommentsRoot.add(theComments);
            DefaultMutableTreeNode theDesc = new DefaultMutableTreeNode(theProfileElement.getDescription());
            DefaultMutableTreeNode theDescRoot = new DefaultMutableTreeNode("Description");
            theDescRoot.add(theDesc);
            DefaultMutableTreeNode theID = new DefaultMutableTreeNode(theProfileElement.getID());
            DefaultMutableTreeNode theIDRoot = new DefaultMutableTreeNode("ID");
            theIDRoot.add(theID);
            DefaultMutableTreeNode theMO = new DefaultMutableTreeNode(new Integer(theProfileElement.getMaxOccurrence()).toString());
            DefaultMutableTreeNode theMORoot = new DefaultMutableTreeNode("Max Occurence");
            theMORoot.add(theMO);
            DefaultMutableTreeNode theSynonyms = new DefaultMutableTreeNode("Synonyms");
            for (String theSynonym : theProfileElement.getSynonyms()) {
                DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(theSynonym);
                theSynonyms.add(sNode);
            }
            DefaultMutableTreeNode theType = new DefaultMutableTreeNode(theProfileElement.getType());
            DefaultMutableTreeNode theTypeRoot = new DefaultMutableTreeNode("Type");
            theTypeRoot.add(theType);
            DefaultMutableTreeNode theUnit = new DefaultMutableTreeNode(theProfileElement.getUnit());
            DefaultMutableTreeNode theUnitRoot = new DefaultMutableTreeNode("Unit");
            theUnitRoot.add(theUnit);
            thePENode.add(theCommentsRoot);
            thePENode.add(theDescRoot);
            thePENode.add(theIDRoot);
            thePENode.add(theMORoot);
            thePENode.add(theSynonyms);
            thePENode.add(theTypeRoot);
            thePENode.add(theUnitRoot);
            profElemRoot.add(thePENode);
        }
        root.add(profAttrRoot);
        root.add(resAttrRoot);
        root.add(profElemRoot);
        return new DefaultTreeModel(root);
    }

    protected void openFileMenuItemActionPerformed(ActionEvent evt) {
        String filename = File.separator + "tmp";
        JFileChooser fc = new JFileChooser(new File(filename));
        int decision = fc.showOpenDialog(this);
        if (decision != 0) {
            return;
        }
        File selFile = fc.getSelectedFile();
        FileReader fr = null;
        try {
            fr = new FileReader(selFile);
        }
        catch (FileNotFoundException fne) {
            fne.printStackTrace();
            System.out.println(fne.getMessage());
        }
        char[] buf = new char[256];
        StringBuffer sb = new StringBuffer();
        int numRead = -1;
        try {
            while ((numRead = fr.read(buf, 0, 256)) != -1) {
                sb.append(buf, 0, numRead);
                buf = new char[256];
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe.getMessage());
        }
        System.out.println("Read in " + sb.toString());
        try {
            this.createdProfile = new Profile(sb.toString());
            this.jEditorPane1.setText(new ProfilePrinter(this.createdProfile, "http://oodt.jpl.nasa.gov/dtd/prof.dtd").toXMLString());
            this.getJTree1().setModel(this.generateModelFromProfile(this.createdProfile));
        }
        catch (SAXException se) {
            se.printStackTrace();
            System.out.println(se.getMessage());
        }
    }

    protected void jButton1ActionPerformed(ActionEvent evt) {
        this.createdProfile = this.generateProfileFromModel(this.getJTree1().getModel());
        this.jEditorPane1.setText(new ProfilePrinter(this.createdProfile, "http://oodt.jpl.nasa.gov/dtd/prof.dtd").toXMLString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int decision = fc.showSaveDialog(this);
        if (decision != 0) {
            return;
        }
        this.createdProfile = this.generateProfileFromModel(this.getJTree1().getModel());
        File file = fc.getSelectedFile();
        FileOutputStream fos = null;
        try {
            System.out.println("Trying to write to " + file.getAbsolutePath());
            fos = new FileOutputStream(file.getAbsolutePath());
            fos.write(new ProfilePrinter(this.createdProfile, "http://oodt.jpl.nasa.gov/dtd/prof.dtd").toXMLString().getBytes());
        }
        catch (FileNotFoundException fne) {
            fne.printStackTrace();
            System.out.println(fne.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception ignore) {}
        }
    }
}

