/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.lightweight;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.oodt.profile.handlers.lightweight.FalseResult;
import org.apache.oodt.profile.handlers.lightweight.Result;
import org.apache.oodt.profile.handlers.lightweight.SearchableProfileElement;
import org.apache.oodt.profile.handlers.lightweight.SearchableResourceAttributes;
import org.apache.oodt.profile.handlers.lightweight.WhereExpression;
import org.apache.oodt.xmlquery.XMLQuery;

class OperatorExpression
implements WhereExpression {
    private String name;
    private String value;
    private String operator;
    private static final String[] VALID_OPERATORS = new String[]{"EQ", "GE", "GT", "LE", "LIKE", "LT", "NE", "NOTLIKE"};
    private static final Set FROM_TOKENS = new HashSet<String>(Arrays.asList(XMLQuery.FROM_TOKENS));
    private static final Set RESOURCE_ATTRIBUTES = new HashSet<String>(Arrays.asList("Identifier", "Title", "Format", "Description", "Creator", "Subject", "Publisher", "Contributor", "Date", "Type", "Source", "Language", "Relation", "Coverage", "Rights", "resContext", "resClass", "resLocation"));

    public OperatorExpression(String value, String name, String operator) {
        if (Arrays.binarySearch(VALID_OPERATORS, operator) < 0) {
            throw new IllegalArgumentException("Invalid operator \"" + operator + "\"");
        }
        this.name = name;
        this.value = value;
        this.operator = operator;
    }

    @Override
    public Result result(SearchableResourceAttributes resAttr, Map elements) {
        if (FROM_TOKENS.contains(this.name)) {
            return resAttr.result(this.name, this.value, this.operator);
        }
        if (RESOURCE_ATTRIBUTES.contains(this.name)) {
            return resAttr.result(this.name, this.value, this.operator);
        }
        SearchableProfileElement element = (SearchableProfileElement)elements.get(this.name);
        if (element == null) {
            return FalseResult.INSTANCE;
        }
        return element.result(this.value, this.operator);
    }

    @Override
    public WhereExpression simplify() {
        return this;
    }

    @Override
    public WhereExpression negate() {
        String negated = this.operator.equals("EQ") ? "NE" : (this.operator.equals("NE") ? "EQ" : (this.operator.equals("LT") ? "GE" : (this.operator.equals("GT") ? "LE" : (this.operator.equals("LE") ? "GT" : (this.operator.equals("LIKE") ? "NE" : (this.operator.equals("NOTLIKE") ? "EQ" : "LT"))))));
        return new OperatorExpression(this.value, this.name, negated);
    }

    public String toString() {
        return "operator[" + this.name + " " + this.operator + " " + this.value + "]";
    }
}

