/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.oodt.commons.util.Documentable;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.Profile;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProfileAttributes
implements Serializable,
Cloneable,
Comparable,
Documentable {
    protected String id;
    protected String version;
    protected String type;
    protected String statusID;
    protected String securityType;
    protected String parent;
    protected List children;
    protected String regAuthority;
    protected List revisionNotes;
    static final long serialVersionUID = 6140264312462080058L;

    public ProfileAttributes() {
        this.id = "UNKNOWN";
        this.type = "UNKNOWN";
        this.statusID = "UNKNOWN";
        this.children = new ArrayList();
        this.revisionNotes = new ArrayList();
    }

    public ProfileAttributes(Node root) {
        this.children = new ArrayList();
        this.revisionNotes = new ArrayList();
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if ("profId".equals(node.getNodeName())) {
                this.id = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profVersion".equals(node.getNodeName())) {
                this.version = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profType".equals(node.getNodeName())) {
                this.type = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profStatusId".equals(node.getNodeName())) {
                this.statusID = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profSecurityType".equals(node.getNodeName())) {
                this.securityType = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profParentId".equals(node.getNodeName())) {
                this.parent = XML.unwrappedText((Node)node);
                continue;
            }
            if ("profChildId".equals(node.getNodeName())) {
                this.children.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("profRegAuthority".equals(node.getNodeName())) {
                this.regAuthority = XML.unwrappedText((Node)node);
                continue;
            }
            if (!"profRevisionNote".equals(node.getNodeName())) continue;
            this.revisionNotes.add(XML.unwrappedText((Node)node));
        }
    }

    public ProfileAttributes(String id, String version, String type, String statusID, String securityType, String parent, List children, String regAuthority, List revisionNotes) {
        this.id = id;
        this.version = version;
        this.type = type;
        this.statusID = statusID;
        this.securityType = securityType;
        this.parent = parent;
        this.children = children;
        this.regAuthority = regAuthority;
        this.revisionNotes = revisionNotes;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof ProfileAttributes)) {
            return false;
        }
        return ((ProfileAttributes)rhs).id.equals(this.id);
    }

    public int compareTo(Object rhs) {
        ProfileAttributes obj = (ProfileAttributes)rhs;
        return this.id.compareTo(obj.id);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.id + "]";
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String getID() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getStatusID() {
        return this.statusID;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getParent() {
        return this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public String getRegAuthority() {
        return this.regAuthority;
    }

    public List getRevisionNotes() {
        return this.revisionNotes;
    }

    public void setParent(String theParent) {
        this.parent = theParent;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatusID(String statusID) {
        this.statusID = statusID;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public void setRegAuthority(String regAuthority) {
        this.regAuthority = regAuthority;
    }

    public Node toXML(Document doc) throws DOMException {
        Element root = doc.createElement("profAttributes");
        XML.add((Node)root, (String)"profId", (String)this.id);
        XML.addNonNull((Node)root, (String)"profVersion", (String)this.version);
        XML.addNonNull((Node)root, (String)"profType", (String)this.type);
        XML.addNonNull((Node)root, (String)"profStatusId", (String)this.statusID);
        XML.addNonNull((Node)root, (String)"profSecurityType", (String)this.securityType);
        XML.addNonNull((Node)root, (String)"profParentId", (String)this.parent);
        XML.add((Node)root, (String)"profChildId", (Collection)this.children);
        XML.addNonNull((Node)root, (String)"profRegAuthority", (String)this.regAuthority);
        XML.add((Node)root, (String)"profRevisionNote", (Collection)this.revisionNotes);
        return root;
    }

    public static Document createProfAttributesDocument() {
        return Profile.createDocument("profAttributes");
    }
}

