/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.cas.util;

import java.util.List;
import org.apache.oodt.cas.filemgr.structs.Product;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.profile.EnumeratedProfileElement;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.ResourceAttributes;

public final class ProfileUtils {
    private static final String PROF_ID_PRE = "urn:oodt:profile:";
    private static final String PROF_TYPE = "profile";

    private ProfileUtils() throws InstantiationException {
        throw new InstantiationException("Don't construct utility classes!");
    }

    public static Profile buildProfile(Product p, Metadata met, String dataDelivBaseUrl) {
        Profile prof = new Profile();
        ProfileAttributes profAttrs = new ProfileAttributes();
        profAttrs.setID(PROF_ID_PRE + p.getProductId());
        profAttrs.setRegAuthority("CAS");
        profAttrs.setType(PROF_TYPE);
        prof.setProfileAttributes(profAttrs);
        ResourceAttributes resAttrs = new ResourceAttributes();
        resAttrs.setDescription(p.getProductType().getDescription());
        resAttrs.setIdentifier(p.getProductId());
        resAttrs.setResClass(p.getProductType().getName());
        resAttrs.setTitle(p.getProductName());
        resAttrs.getPublishers().add("CAS");
        resAttrs.getResLocations().add(dataDelivBaseUrl + "?productID=" + p.getProductId());
        prof.setResourceAttributes(resAttrs);
        for (String key : met.getHashtable().keySet()) {
            List vals = met.getAllMetadata(key);
            EnumeratedProfileElement elem = new EnumeratedProfileElement(prof);
            System.out.println("Adding [" + key + "]=>" + vals);
            elem.setName(key);
            elem.getValues().addAll(vals);
            prof.getProfileElements().put(key, elem);
        }
        return prof;
    }
}

