/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.oodt.commons.util.Documentable;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.Utility;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAttributes
implements Serializable,
Cloneable,
Comparable,
Documentable {
    protected Profile profile;
    protected String identifier;
    protected String title;
    protected List formats;
    protected String description;
    protected List creators;
    protected List subjects;
    protected List publishers;
    protected List contributors;
    protected List dates;
    protected List types;
    protected List sources;
    protected List languages;
    protected List relations;
    protected List coverages;
    protected List rights;
    protected List contexts;
    protected String aggregation;
    protected String clazz;
    protected List locations;
    private static final URI UNKNOWN_URI = URI.create("urn:eda:profile:UNKNOWN");
    static final long serialVersionUID = -4251763559607642607L;

    public ResourceAttributes() {
        this(null);
    }

    public ResourceAttributes(Profile profile) {
        this.profile = profile;
        this.identifier = "UNKNOWN";
        this.initializeLists();
    }

    public ResourceAttributes(Profile profile, Node root) {
        this.profile = profile;
        this.initializeLists();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("Identifier".equals(node.getNodeName())) {
                this.identifier = XML.unwrappedText((Node)node);
                continue;
            }
            if ("Title".equals(node.getNodeName())) {
                this.title = XML.unwrappedText((Node)node);
                continue;
            }
            if ("Format".equals(node.getNodeName())) {
                this.formats.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Description".equals(node.getNodeName())) {
                this.description = XML.unwrappedText((Node)node);
                continue;
            }
            if ("Creator".equals(node.getNodeName())) {
                this.creators.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Subject".equals(node.getNodeName())) {
                this.subjects.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Publisher".equals(node.getNodeName())) {
                this.publishers.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Contributor".equals(node.getNodeName())) {
                this.contributors.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Date".equals(node.getNodeName())) {
                this.dates.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Type".equals(node.getNodeName())) {
                this.types.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Source".equals(node.getNodeName())) {
                this.sources.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Language".equals(node.getNodeName())) {
                this.languages.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Relation".equals(node.getNodeName())) {
                this.relations.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Coverage".equals(node.getNodeName())) {
                this.coverages.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("Rights".equals(node.getNodeName())) {
                this.rights.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("resContext".equals(node.getNodeName())) {
                this.contexts.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("resAggregation".equals(node.getNodeName())) {
                this.aggregation = XML.unwrappedText((Node)node);
                continue;
            }
            if ("resClass".equals(node.getNodeName())) {
                this.clazz = XML.unwrappedText((Node)node);
                continue;
            }
            if (!"resLocation".equals(node.getNodeName())) continue;
            this.locations.add(XML.unwrappedText((Node)node));
        }
    }

    public ResourceAttributes(Profile profile, String identifier, String title, List formats, String description, List creators, List subjects, List publishers, List contributors, List dates, List types, List sources, List languages, List relations, List coverages, List rights, List contexts, String aggregation, String clazz, List locations) {
        this.profile = profile;
        this.identifier = identifier;
        this.title = title;
        this.formats = formats;
        this.description = description;
        this.creators = creators;
        this.subjects = subjects;
        this.publishers = publishers;
        this.contributors = contributors;
        this.dates = dates;
        this.types = types;
        this.sources = sources;
        this.languages = languages;
        this.relations = relations;
        this.coverages = coverages;
        this.rights = rights;
        this.contexts = contexts;
        this.aggregation = aggregation;
        this.clazz = clazz;
        this.locations = locations;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof ResourceAttributes)) {
            return false;
        }
        return ((ResourceAttributes)rhs).identifier.equals(this.identifier);
    }

    public int compareTo(Object rhs) {
        ResourceAttributes obj = (ResourceAttributes)rhs;
        return this.identifier.compareTo(obj.identifier);
    }

    public String toString() {
        return this.getClass().getName() + "[identifer=" + this.identifier + "]";
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    void addToModel(Model model, Resource resource, ProfileAttributes profAttr) {
        URI myURI = this.getURI();
        Utility.addProperty(model, resource, Utility.dcTitle, this.title, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcFormat, this.formats, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcDescription, this.description, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcCreator, this.creators, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcSubject, this.subjects, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcPublisher, this.publishers, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcContributor, this.contributors, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcDate, this.dates, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcType, this.types, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcSource, this.sources, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcLanguage, this.languages, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcRelation, this.relations, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.dcRights, this.rights, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.edmContext, this.contexts, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.edmAggregation, this.aggregation, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.edmClass, this.clazz, profAttr, myURI);
        Utility.addProperty(model, resource, Utility.edmLocation, this.locations, profAttr, myURI);
    }

    public URI getURI() {
        String identification = this.identifier == null || this.identifier.length() == 0 ? (this.locations.isEmpty() ? null : (String)this.locations.get(0)) : this.identifier;
        return identification == null ? UNKNOWN_URI : URI.create(identification);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List getFormats() {
        return this.formats;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public List getCreators() {
        return this.creators;
    }

    public List getSubjects() {
        return this.subjects;
    }

    public List getPublishers() {
        return this.publishers;
    }

    public List getContributors() {
        return this.contributors;
    }

    public List getDates() {
        return this.dates;
    }

    public List getTypes() {
        return this.types;
    }

    public List getSources() {
        return this.sources;
    }

    public List getLanguages() {
        return this.languages;
    }

    public List getRelations() {
        return this.relations;
    }

    public List getCoverages() {
        return this.coverages;
    }

    public List getRights() {
        return this.rights;
    }

    public List getResContexts() {
        return this.contexts;
    }

    public String getResAggregation() {
        return this.aggregation;
    }

    public void setResAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getResClass() {
        return this.clazz;
    }

    public void setResClass(String clazz) {
        this.clazz = clazz;
    }

    public List getResLocations() {
        return this.locations;
    }

    protected void initializeLists() {
        this.formats = new ArrayList();
        this.creators = new ArrayList();
        this.subjects = new ArrayList();
        this.publishers = new ArrayList();
        this.contributors = new ArrayList();
        this.dates = new ArrayList();
        this.types = new ArrayList();
        this.sources = new ArrayList();
        this.languages = new ArrayList();
        this.relations = new ArrayList();
        this.coverages = new ArrayList();
        this.rights = new ArrayList();
        this.contexts = new ArrayList();
        this.locations = new ArrayList();
    }

    public Node toXML(Document doc) throws DOMException {
        Element root = doc.createElement("resAttributes");
        XML.add((Node)root, (String)"Identifier", (String)this.identifier);
        XML.addNonNull((Node)root, (String)"Title", (String)this.title);
        XML.add((Node)root, (String)"Format", (Collection)this.formats);
        XML.addNonNull((Node)root, (String)"Description", (String)this.description);
        XML.add((Node)root, (String)"Creator", (Collection)this.creators);
        XML.add((Node)root, (String)"Subject", (Collection)this.subjects);
        XML.add((Node)root, (String)"Publisher", (Collection)this.publishers);
        XML.add((Node)root, (String)"Contributor", (Collection)this.contributors);
        XML.add((Node)root, (String)"Date", (Collection)this.dates);
        XML.add((Node)root, (String)"Type", (Collection)this.types);
        XML.add((Node)root, (String)"Source", (Collection)this.sources);
        XML.add((Node)root, (String)"Language", (Collection)this.languages);
        XML.add((Node)root, (String)"Relation", (Collection)this.relations);
        XML.add((Node)root, (String)"Coverage", (Collection)this.coverages);
        XML.add((Node)root, (String)"Rights", (Collection)this.rights);
        ArrayList<String> contexts = new ArrayList<String>(this.contexts);
        if (contexts.isEmpty()) {
            contexts.add("UNKNOWN");
        }
        XML.add((Node)root, (String)"resContext", contexts);
        XML.addNonNull((Node)root, (String)"resAggregation", (String)this.aggregation);
        if (this.clazz == null) {
            this.clazz = "UNKNOWN";
        }
        XML.addNonNull((Node)root, (String)"resClass", (String)this.clazz);
        XML.add((Node)root, (String)"resLocation", (Collection)this.locations);
        return root;
    }

    public static Document createResAttributesDocument() {
        return Profile.createDocument("resAttributes");
    }
}

