/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.oodt.commons.util.Documentable;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.ObjectFactory;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.Utility;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ProfileElement
implements Serializable,
Cloneable,
Comparable,
Documentable {
    protected Profile profile;
    protected String name;
    protected String id;
    protected String desc;
    protected String type;
    protected String unit;
    protected List synonyms;
    protected boolean obligation;
    protected int maxOccurrence;
    protected String comments;

    public static ProfileElement createProfileElement(Element root, Profile profile, ObjectFactory factory) {
        String name = null;
        String id = null;
        String desc = null;
        String type = null;
        String unit = null;
        ArrayList<String> synonyms = new ArrayList<String>();
        boolean obligation = false;
        int maxOccurrence = 0;
        String comments = null;
        boolean ranged = false;
        NodeList children = root.getChildNodes();
        String min = "0.0";
        String max = "0.0";
        boolean gotMin = false;
        boolean gotMax = false;
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("elemId".equals(node.getNodeName())) {
                id = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemName".equals(node.getNodeName())) {
                name = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemDesc".equals(node.getNodeName())) {
                desc = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemType".equals(node.getNodeName())) {
                type = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemUnit".equals(node.getNodeName())) {
                unit = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemEnumFlag".equals(node.getNodeName())) {
                ranged = "F".equals(XML.unwrappedText((Node)node));
                continue;
            }
            if ("elemSynonym".equals(node.getNodeName())) {
                synonyms.add(XML.unwrappedText((Node)node));
                continue;
            }
            if ("elemObligation".equals(node.getNodeName())) {
                String value = XML.unwrappedText((Node)node);
                obligation = "Required".equals(value) || "T".equals(value);
                continue;
            }
            if ("elemMaxOccurrence".equals(node.getNodeName())) {
                try {
                    maxOccurrence = Integer.parseInt(XML.unwrappedText((Node)node));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("elemComment".equals(node.getNodeName())) {
                comments = XML.unwrappedText((Node)node);
                continue;
            }
            if ("elemValue".equals(node.getNodeName())) {
                values.add(ProfileElement.text(node));
                continue;
            }
            if ("elemMinValue".equals(node.getNodeName())) {
                try {
                    min = XML.unwrappedText((Node)node);
                    gotMin = true;
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if (!"elemMaxValue".equals(node.getNodeName())) continue;
            try {
                max = XML.unwrappedText((Node)node);
                gotMax = true;
                continue;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (ranged) {
            if (gotMin && gotMax) {
                return factory.createRangedProfileElement(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comments, min, max);
            }
            return factory.createUnspecifiedProfileElement(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comments);
        }
        return factory.createEnumeratedProfileElement(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comments, values);
    }

    protected ProfileElement(Profile profile) {
        this.profile = profile;
        this.synonyms = new ArrayList();
    }

    protected ProfileElement(Profile profile, String name, String id, String desc, String type, String unit, List synonyms, boolean obligation, int maxOccurrence, String comments) {
        this.profile = profile;
        this.name = name;
        this.id = id;
        this.desc = desc;
        this.type = type;
        this.unit = unit;
        this.synonyms = synonyms;
        this.obligation = obligation;
        this.maxOccurrence = maxOccurrence;
        this.comments = comments;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof ProfileElement)) {
            return false;
        }
        ProfileElement obj = (ProfileElement)rhs;
        return this.profile.equals(obj.profile) && this.name.equals(obj.name);
    }

    public String toString() {
        return this.getClass().getName() + "[profile=" + this.profile.toString() + ",name=" + this.name + "]";
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public int compareTo(Object rhs) {
        ProfileElement obj = (ProfileElement)rhs;
        if (this.profile.compareTo(obj.profile) < 0) {
            return -1;
        }
        if (this.profile.compareTo(obj.profile) == 0) {
            return this.name.compareTo(obj.name);
        }
        return 1;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public List getSynonyms() {
        return this.synonyms;
    }

    public boolean isObligatory() {
        return this.obligation;
    }

    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public String getComments() {
        return this.comments;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setObligation(boolean obligatory) {
        this.obligation = obligatory;
    }

    public void setMaxOccurrence(int occurrence) {
        this.maxOccurrence = occurrence;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public abstract String getMinValue();

    public abstract String getMaxValue();

    public abstract List getValues();

    public Node toXML(Document doc) throws DOMException {
        return this.toXML(doc, true);
    }

    public Node toXMLWithoutValues(Document doc) throws DOMException {
        return this.toXML(doc, false);
    }

    private Node toXML(Document doc, boolean withValues) throws DOMException {
        Element profElement = doc.createElement("profElement");
        XML.addNonNull((Node)profElement, (String)"elemId", (String)this.id);
        XML.addNonNull((Node)profElement, (String)"elemName", (String)this.name);
        XML.addNonNull((Node)profElement, (String)"elemDesc", (String)this.desc);
        XML.addNonNull((Node)profElement, (String)"elemType", (String)this.type);
        XML.addNonNull((Node)profElement, (String)"elemUnit", (String)this.unit);
        XML.add((Node)profElement, (String)"elemEnumFlag", (String)(this.isEnumerated() ? "T" : "F"));
        if (withValues) {
            this.addValues(profElement);
        }
        XML.add((Node)profElement, (String)"elemSynonym", (Collection)this.synonyms);
        if (this.isObligatory()) {
            XML.add((Node)profElement, (String)"elemObligation", (String)"Required");
        }
        if (this.getMaxOccurrence() >= 0) {
            XML.add((Node)profElement, (String)"elemMaxOccurrence", (String)String.valueOf(this.getMaxOccurrence()));
        }
        XML.add((Node)profElement, (String)"elemComment", (String)this.comments);
        return profElement;
    }

    protected abstract boolean isEnumerated();

    protected abstract void addValues(Node var1) throws DOMException;

    void addToModel(Model model, Resource resource, ProfileAttributes profAttr) {
        URI profileURI = this.profile.getURI();
        URI myURI = URI.create(profileURI.toString() + "#" + this.name);
        Resource element = model.createResource(myURI.toString());
        Utility.addProperty(model, resource, Utility.edmElement, element, profAttr, myURI);
        String obStr = this.obligation ? "Required" : "Optional";
        String occurStr = String.valueOf(this.maxOccurrence);
        Utility.addProperty(model, element, Utility.edmElemID, this.id, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmDescription, this.desc, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmElemType, this.type, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmUnit, this.unit, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmSynonym, this.synonyms, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmObligation, obStr, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmMaxOccurrence, occurStr, profAttr, myURI);
        Utility.addProperty(model, element, Utility.edmComment, this.comments, profAttr, myURI);
        this.addElementSpecificProperties(model, element, profAttr, myURI);
    }

    protected abstract void addElementSpecificProperties(Model var1, Resource var2, ProfileAttributes var3, URI var4);

    public static Document createProfElementDocument() {
        return Profile.createDocument("profElement");
    }

    public static Set profiles(Set elements) {
        HashSet<Profile> rc = new HashSet<Profile>();
        for (ProfileElement element : elements) {
            rc.add(element.getProfile());
        }
        return rc;
    }

    public static Set elements(Set profiles, Set elements) {
        HashSet<ProfileElement> rc = new HashSet<ProfileElement>();
        for (ProfileElement element : elements) {
            if (!profiles.contains(element.getProfile())) continue;
            rc.add(element);
        }
        return rc;
    }

    static String text(Node node) {
        StringBuffer b = new StringBuffer();
        ProfileElement.text0(b, node);
        return b.toString();
    }

    static void text0(StringBuffer b, Node node) {
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            b.append(node.getNodeValue());
            return;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            ProfileElement.text0(b, children.item(i));
        }
    }
}

