/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oodt.commons.util.Documentable;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.DefaultFactory;
import org.apache.oodt.profile.ObjectFactory;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.ProfileElement;
import org.apache.oodt.profile.ResourceAttributes;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Profile
implements Serializable,
Cloneable,
Comparable,
Documentable {
    static final long serialVersionUID = -3936851809184360591L;
    public static final String PROFILES_DTD_FPI = "-//JPL//DTD Profile 1.1//EN";
    public static String PROFILES_DTD_URL = "http://oodt.jpl.nasa.gov/grid-profile/dtd/prof.dtd";
    protected ProfileAttributes profAttr;
    protected ResourceAttributes resAttr;
    protected Map elements = new HashMap();

    public static List createProfiles(Element root, ObjectFactory factory) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if ("profile".equals(root.getNodeName())) {
            profiles.add(factory.createProfile(root));
        } else if ("profiles".equals(root.getNodeName())) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"profile".equals(node.getNodeName())) continue;
                profiles.add(factory.createProfile((Element)node));
            }
        } else {
            throw new IllegalArgumentException("Expected a <profiles> or <profile> top level element but got " + root.getNodeName());
        }
        return profiles;
    }

    public static List createProfiles(Element root) {
        return Profile.createProfiles(root, new DefaultFactory());
    }

    public Profile() {
        this.profAttr = new ProfileAttributes();
        this.resAttr = new ResourceAttributes(this);
    }

    public Profile(String string) throws SAXException {
        this(XML.parse((String)string).getDocumentElement(), (ObjectFactory)new DefaultFactory());
    }

    public Profile(String string, ObjectFactory factory) throws SAXException {
        this(XML.parse((String)string).getDocumentElement(), factory);
    }

    public Profile(Node root) {
        this(root, (ObjectFactory)new DefaultFactory());
    }

    public Profile(Node root, ObjectFactory factory) {
        if (!root.getNodeName().equals("profile")) {
            throw new IllegalArgumentException("Construct a Profile from a <profile> element, not a <" + root.getNodeName() + ">");
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("profAttributes".equals(node.getNodeName())) {
                this.profAttr = factory.createProfileAttributes((Element)node);
                continue;
            }
            if ("resAttributes".equals(node.getNodeName())) {
                this.resAttr = factory.createResourceAttributes(this, (Element)node);
                continue;
            }
            if (!"profElement".equals(node.getNodeName())) continue;
            ProfileElement element = ProfileElement.createProfileElement((Element)node, this, factory);
            this.elements.put(element.getName(), element);
        }
    }

    public Profile(ProfileAttributes profAttr, ResourceAttributes resAttr) {
        this.profAttr = profAttr;
        this.resAttr = resAttr;
        if (this.resAttr != null) {
            this.resAttr.profile = this;
        }
    }

    public int hashCode() {
        return this.profAttr.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof Profile)) {
            return false;
        }
        Profile obj = (Profile)rhs;
        return this.profAttr.equals(obj.profAttr);
    }

    public int compareTo(Object rhs) {
        Profile obj = (Profile)rhs;
        return this.profAttr.compareTo(obj.profAttr);
    }

    public String toString() {
        Document doc = Profile.createProfileDocument();
        doc.removeChild(doc.getDocumentElement());
        doc.appendChild(this.toXML(doc));
        return XML.serialize((Document)doc);
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public ProfileAttributes getProfileAttributes() {
        return this.profAttr;
    }

    public ResourceAttributes getResourceAttributes() {
        return this.resAttr;
    }

    public void setProfileAttributes(ProfileAttributes profAttr) {
        this.profAttr = profAttr;
    }

    public void setResourceAttributes(ResourceAttributes resAttr) {
        this.resAttr = resAttr;
    }

    public Map getProfileElements() {
        return this.elements;
    }

    public URI getURI() {
        return this.resAttr.getURI();
    }

    public void addToModel(Model model) {
        Resource resource = model.createResource(this.getURI().toString());
        this.resAttr.addToModel(model, resource, this.profAttr);
        for (ProfileElement e : this.elements.values()) {
            e.addToModel(model, resource, this.profAttr);
        }
    }

    public Node toXML(Document doc) throws DOMException {
        return this.toXML(doc, true);
    }

    public Node toXMLWithoutElements(Document doc) throws DOMException {
        return this.toXML(doc, false);
    }

    private Node toXML(Document doc, boolean withElements) throws DOMException {
        Element profile = doc.createElement("profile");
        profile.appendChild(this.profAttr.toXML(doc));
        profile.appendChild(this.resAttr.toXML(doc));
        if (withElements) {
            Iterator i = this.elements.values().iterator();
            while (i.hasNext()) {
                profile.appendChild(((ProfileElement)i.next()).toXML(doc));
            }
        }
        return profile;
    }

    public static Document createProfilesDocument() {
        return Profile.createDocument("profiles");
    }

    public static Document createProfileDocument() {
        return Profile.createDocument("profile");
    }

    static Document createDocument(String root) {
        DocumentType docType = XML.getDOMImplementation().createDocumentType(root, PROFILES_DTD_FPI, PROFILES_DTD_URL);
        Document doc = XML.getDOMImplementation().createDocument(null, root, docType);
        return doc;
    }

    public static void main(String[] argv) throws Throwable {
        int num;
        if (argv.length != 1) {
            System.err.println("Usage: <profile.xml>");
            System.exit(1);
        }
        StringBuffer b = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(argv[0]));
        char[] buf = new char[512];
        while ((num = reader.read(buf)) != -1) {
            b.append(buf, 0, num);
        }
        reader.close();
        Profile p = new Profile(b.toString());
        Model model = ModelFactory.createDefaultModel();
        p.addToModel(model);
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        model.write((Writer)writer);
        writer.close();
        System.exit(0);
    }
}

