/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.lightweight;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.oodt.profile.ResourceAttributes;
import org.apache.oodt.profile.handlers.lightweight.FalseResult;
import org.apache.oodt.profile.handlers.lightweight.MatchingResult;
import org.apache.oodt.profile.handlers.lightweight.Result;
import org.apache.oodt.profile.handlers.lightweight.SearchableProfile;
import org.w3c.dom.Element;

public class SearchableResourceAttributes
extends ResourceAttributes {
    public SearchableResourceAttributes(SearchableProfile profile, Element node) {
        super(profile, node);
    }

    public Result result(String name, String value, String operator) {
        if ("Identifier".equals(name)) {
            return this.computeResult(this.identifier, value, operator);
        }
        if ("Title".equals(name)) {
            return this.computeResult(this.title, value, operator);
        }
        if ("Format".equals(name)) {
            return this.computeResult(this.formats, value, operator);
        }
        if ("Description".equals(name)) {
            return this.computeResult(this.description, value, operator);
        }
        if ("Creator".equals(name)) {
            return this.computeResult(this.creators, value, operator);
        }
        if ("Subject".equals(name)) {
            return this.computeResult(this.subjects, value, operator);
        }
        if ("Publisher".equals(name)) {
            return this.computeResult(this.publishers, value, operator);
        }
        if ("Contributor".equals(name)) {
            return this.computeResult(this.contributors, value, operator);
        }
        if ("Date".equals(name)) {
            return this.computeResult(this.dates, value, operator);
        }
        if ("Type".equals(name)) {
            return this.computeResult(this.types, value, operator);
        }
        if ("Source".equals(name)) {
            return this.computeResult(this.sources, value, operator);
        }
        if ("Language".equals(name)) {
            return this.computeResult(this.languages, value, operator);
        }
        if ("Relation".equals(name)) {
            return this.computeResult(this.relations, value, operator);
        }
        if ("Coverage".equals(name)) {
            return this.computeResult(this.coverages, value, operator);
        }
        if ("Rights".equals(name)) {
            return this.computeResult(this.rights, value, operator);
        }
        if ("resContext".equals(name)) {
            return this.computeResult(this.contexts, value, operator);
        }
        if ("resClass".equals(name)) {
            return this.computeResult(this.clazz, value, operator);
        }
        if ("resLocation".equals(name)) {
            return this.computeResult(this.locations, value, operator);
        }
        throw new IllegalArgumentException("Unknown attribute \"" + name + "\"");
    }

    private Result computeResult(String a, String b, String op) {
        boolean t;
        int c = a.compareTo(b);
        if ("EQ".equals(op) || "LIKE".equals(op)) {
            t = c == 0;
        } else if ("GE".equals(op)) {
            t = c >= 0;
        } else if ("GT".equals(op)) {
            t = c > 0;
        } else if ("LE".equals(op)) {
            t = c <= 0;
        } else if ("LT".equals(op)) {
            t = c < 0;
        } else if ("NE".equals(op) || "NOTLIKE".equals(op)) {
            t = c != 0;
        } else {
            throw new IllegalArgumentException("Unknown relational operator \"" + op + "\"");
        }
        if (t) {
            return new MatchingResult(new HashSet(this.profile.getProfileElements().values()));
        }
        return FalseResult.INSTANCE;
    }

    private Result computeResult(List a, String b, String op) {
        if (a == null || a.isEmpty()) {
            return FalseResult.INSTANCE;
        }
        FalseResult f = FalseResult.INSTANCE;
        MatchingResult t = new MatchingResult(new HashSet(this.profile.getProfileElements().values()));
        Result rc = f;
        if ("EQ".equals(op) || "LIKE".equals(op)) {
            if (a.contains(b)) {
                rc = t;
            } else if ("NE".equals(op) || "NOTLIKE".equals(op)) {
                if (!a.contains(b)) {
                    rc = t;
                } else if ("LT".equals(op) || "GT".equals(op) || "LE".equals(op) || "GE".equals(op)) {
                    String value;
                    Iterator i = a.iterator();
                    while (i.hasNext() && (rc = this.computeResult(value = (String)i.next(), b, op)) == f) {
                    }
                } else {
                    throw new IllegalArgumentException("Unknown relational operator \"" + op + "\"");
                }
            }
        }
        return rc;
    }
}

