/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers.lightweight;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.oodt.commons.util.DOMParser;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileException;
import org.apache.oodt.profile.handlers.ProfileHandler;
import org.apache.oodt.profile.handlers.lightweight.AndExpression;
import org.apache.oodt.profile.handlers.lightweight.ConstantExpression;
import org.apache.oodt.profile.handlers.lightweight.NotExpression;
import org.apache.oodt.profile.handlers.lightweight.OperatorExpression;
import org.apache.oodt.profile.handlers.lightweight.OrExpression;
import org.apache.oodt.profile.handlers.lightweight.Result;
import org.apache.oodt.profile.handlers.lightweight.SearchableObjectFactory;
import org.apache.oodt.profile.handlers.lightweight.SearchableProfile;
import org.apache.oodt.profile.handlers.lightweight.WhereExpression;
import org.apache.oodt.xmlquery.QueryElement;
import org.apache.oodt.xmlquery.XMLQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class LightweightProfileServer
implements ProfileHandler {
    private List profiles;
    private static Map cache = new HashMap();
    private String id;

    public LightweightProfileServer() throws IOException, SAXException, MalformedURLException {
        this(System.getProperties());
    }

    public LightweightProfileServer(Properties props) throws IOException, SAXException, MalformedURLException {
        this(new URL(props.getProperty("org.apache.oodt.profile.handlers.LightweightProfileServer.profiles.url", props.getProperty("org.apache.oodt.profile.webServer.baseURL", "http://eda.jpl.nasa.gov") + "/profiles.xml")), props.getProperty("org.apache.oodt.profile.handlers.LightweightProfileServer.id", "lightweight"));
    }

    public LightweightProfileServer(URL url, String id) throws IOException, SAXException, MalformedURLException {
        this.id = id;
        this.profiles = (List)cache.get(url);
        if (this.profiles != null) {
            return;
        }
        this.profiles = new ArrayList();
        DOMParser parser = XML.createDOMParser();
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXParseException {
                System.err.println("Parse error line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + ": " + ex.getMessage());
                throw ex;
            }

            public void warning(SAXParseException ex) {
                System.err.println("Parse warning: " + ex.getMessage());
            }

            public void fatalError(SAXParseException ex) throws SAXParseException {
                throw ex;
            }
        });
        InputSource inputSource = new InputSource(url.toString());
        parser.parse(inputSource);
        Document doc = parser.getDocument();
        doc.normalize();
        Element root = doc.getDocumentElement();
        this.profiles = Profile.createProfiles(root, new SearchableObjectFactory());
        cache.put(url, this.profiles);
        System.err.println("LightweightProfileServer ready");
    }

    public List findProfiles(XMLQuery query) throws ProfileException {
        HashSet<SearchableProfile> matchingProfiles = new HashSet<SearchableProfile>();
        WhereExpression whereExpression = LightweightProfileServer.createWhereExpression(query);
        for (SearchableProfile profile : this.profiles) {
            Result result = profile.search(whereExpression);
            if (result.matchingElements().isEmpty()) continue;
            matchingProfiles.add(profile);
        }
        return new ArrayList(matchingProfiles);
    }

    public Profile get(String profID) {
        if (profID == null) {
            return null;
        }
        Profile rc = null;
        for (Profile p : this.profiles) {
            if (!p.getProfileAttributes().getID().equals(profID)) continue;
            rc = p;
            break;
        }
        return rc;
    }

    private static WhereExpression createWhereExpression(XMLQuery query) {
        Stack<Object> stack = new Stack<Object>();
        ArrayList<QueryElement> allElements = new ArrayList<QueryElement>(query.getWhereElementSet());
        List fromElements = query.getFromElementSet();
        if (!fromElements.isEmpty()) {
            allElements.addAll(fromElements);
            allElements.add(new QueryElement("LOGOP", "AND"));
        }
        for (QueryElement queryElement : allElements) {
            String keyword = queryElement.getValue();
            String type = queryElement.getRole();
            if (type.equals("elemName")) {
                stack.push(keyword);
                continue;
            }
            if (type.equals("LITERAL")) {
                stack.push(keyword);
                continue;
            }
            if (type.equals("LOGOP")) {
                if (keyword.equals("AND")) {
                    stack.push(new AndExpression((WhereExpression)stack.pop(), (WhereExpression)stack.pop()));
                    continue;
                }
                if (keyword.equals("OR")) {
                    stack.push(new OrExpression((WhereExpression)stack.pop(), (WhereExpression)stack.pop()));
                    continue;
                }
                if (keyword.equals("NOT")) {
                    stack.push(new NotExpression((WhereExpression)stack.pop()));
                    continue;
                }
                throw new IllegalArgumentException("Illegal operator \"" + keyword + "\" in query");
            }
            if (!type.equals("RELOP")) continue;
            stack.push(new OperatorExpression((String)stack.pop(), (String)stack.pop(), keyword));
        }
        if (stack.size() == 0) {
            return new ConstantExpression(true);
        }
        if (stack.size() > 1) {
            throw new IllegalStateException("Imbalanced expression in query");
        }
        return ((WhereExpression)stack.pop()).simplify();
    }

    public String getID() {
        return this.id;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0) {
            System.err.println("Usage: <query>...");
            System.exit(1);
        }
        LightweightProfileServer lp = new LightweightProfileServer();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < argv.length; ++i) {
            b.append(argv[i]).append(' ');
        }
        XMLQuery query = new XMLQuery(b.toString().trim(), "cli1", "CmdLine-1", "This is a query entered on the command-line", null, null, null, null, 100);
        System.out.println(lp.findProfiles(query));
        System.exit(0);
    }
}

