/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile.handlers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileException;
import org.apache.oodt.profile.ProfileSQLException;
import org.apache.oodt.profile.handlers.ProfileManager;
import org.apache.oodt.xmlquery.XMLQuery;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class DatabaseProfileManager
implements ProfileManager {
    Connection conn;
    Properties props;

    private static void add(Node node, String name, String value) throws DOMException {
        if (value == null) {
            return;
        }
        XML.add((Node)node, (String)name, (String)value.trim());
    }

    public abstract List getProfiles(Connection var1) throws ProfileException;

    public DatabaseProfileManager(Properties props) throws SQLException, Exception {
        this(props, DatabaseProfileManager.openConnection(props));
    }

    public DatabaseProfileManager(Properties props, Connection conn) {
        this.conn = conn;
        this.props = props;
    }

    public List findProfiles(XMLQuery query) throws DOMException, ProfileException {
        try {
            return this.findProfiles(this.conn, query);
        }
        catch (Exception e) {
            throw new ProfileException(e.getMessage());
        }
    }

    public abstract List findProfiles(Connection var1, XMLQuery var2) throws DOMException, ProfileException;

    public void add(Profile profile) throws ProfileException {
        try {
            this.add(this.conn, profile);
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new ProfileSQLException(e);
        }
    }

    public abstract void add(Connection var1, Profile var2) throws ProfileException;

    public void addAll(Collection collection) throws ProfileException {
        try {
            this.addAll(this.conn, collection);
            this.conn.commit();
        }
        catch (Exception e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException se) {
                throw new ProfileSQLException(se);
            }
            throw new ProfileException(e.getMessage());
        }
    }

    public abstract void addAll(Connection var1, Collection var2) throws ProfileException;

    public abstract void clear(Connection var1) throws ProfileException;

    public void clear() throws ProfileException {
        try {
            this.clear(this.conn);
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new ProfileSQLException(e);
        }
    }

    public boolean contains(Profile profile) throws ProfileException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean containsAll(Collection collection) throws ProfileException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public abstract Profile get(Connection var1, String var2) throws ProfileException;

    public Profile get(String profId) throws ProfileException {
        return this.get(this.conn, profId);
    }

    public Collection getAll() throws ProfileException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isEmpty() throws ProfileException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Iterator iterator() throws ProfileException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public abstract boolean remove(Connection var1, String var2, String var3) throws ProfileException;

    public abstract boolean remove(Connection var1, String var2) throws ProfileException;

    public boolean remove(String profId, String version) throws ProfileException {
        try {
            boolean status = this.remove(this.conn, profId, version);
            this.conn.commit();
            return status;
        }
        catch (SQLException e) {
            throw new ProfileSQLException(e);
        }
    }

    public boolean remove(String profId) throws ProfileException {
        try {
            boolean status = this.remove(this.conn, profId);
            this.conn.commit();
            return status;
        }
        catch (SQLException e) {
            throw new ProfileSQLException(e);
        }
    }

    public int size() throws ProfileException {
        return this.size(this.conn);
    }

    public abstract int size(Connection var1) throws ProfileException;

    public void replace(Profile profile) throws ProfileException {
        try {
            this.replace(this.conn, profile);
            this.conn.commit();
        }
        catch (Exception e) {
            throw new ProfileException(e.getMessage());
        }
    }

    public abstract void replace(Connection var1, Profile var2) throws ProfileException;

    protected static Connection openConnection(Properties props) throws SQLException, ProfileException {
        String driver = props.getProperty("org.apache.oodt.util.JDBC_DB.driver", "oracle.jdbc.driver.OracleDriver");
        try {
            System.err.println("Attempting to load class " + driver);
            Class.forName(driver);
            System.err.println("Loaded " + driver);
        }
        catch (ClassNotFoundException e) {
            throw new ProfileException("Can't load JDBC driver \"" + driver + "\": " + e.getMessage());
        }
        String url = props.getProperty("org.apache.oodt.util.JDBC_DB.url", "jdbc:oracle:@");
        String database = props.getProperty("org.apache.oodt.util.JDBC_DB.database");
        if (database != null) {
            url = url + database;
        }
        Connection conn = DriverManager.getConnection(url, props.getProperty("org.apache.oodt.util.JDBC_DB.user"), props.getProperty("org.apache.oodt.util.JDBC_DB.password"));
        conn.setAutoCommit(false);
        return conn;
    }
}

