/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.ProfileElement;
import org.apache.oodt.profile.Utility;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class RangedProfileElement
extends ProfileElement {
    protected String min;
    protected String max;
    static final long serialVersionUID = -5697102597443089753L;

    public RangedProfileElement(Profile profile) {
        super(profile);
        this.min = "";
        this.max = "";
    }

    public RangedProfileElement(Profile profile, String name, String id, String desc, String type, String unit, List synonyms, boolean obligation, int maxOccurrence, String comment, String min, String max) {
        super(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comment);
        this.min = min;
        this.max = max;
    }

    protected boolean isEnumerated() {
        return false;
    }

    public void setMinValue(String min) {
        this.min = min;
    }

    public void setMaxValue(String max) {
        this.max = max;
    }

    protected void addValues(Node node) throws DOMException {
        XML.add((Node)node, (String)"elemMinValue", (String)this.min);
        XML.add((Node)node, (String)"elemMaxValue", (String)this.max);
    }

    public String getMinValue() {
        return String.valueOf(this.min);
    }

    public String getMaxValue() {
        return String.valueOf(this.max);
    }

    public List getValues() {
        return Collections.EMPTY_LIST;
    }

    protected void addElementSpecificProperties(Model model, Resource element, ProfileAttributes profAttr, URI uri) {
        Utility.addProperty(model, element, Utility.edmMinValue, this.min, profAttr, uri);
        Utility.addProperty(model, element, Utility.edmMaxValue, this.max, profAttr, uri);
    }
}

