/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.profile;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.oodt.profile.Profile;
import org.apache.oodt.profile.ProfileAttributes;
import org.apache.oodt.profile.ProfileElement;
import org.apache.oodt.profile.Utility;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnumeratedProfileElement
extends ProfileElement {
    protected List values;

    public EnumeratedProfileElement(Profile profile) {
        super(profile);
        this.values = new ArrayList();
    }

    public EnumeratedProfileElement(Profile profile, String name, String id, String desc, String type, String unit, List synonyms, boolean obligation, int maxOccurrence, String comment, List values) {
        super(profile, name, id, desc, type, unit, synonyms, obligation, maxOccurrence, comment);
        if (values.contains(null)) {
            throw new IllegalArgumentException("Null item in 'values' not allowed for enumerated profile elements");
        }
        this.values = values;
    }

    protected boolean isEnumerated() {
        return true;
    }

    protected void addValues(Node node) throws DOMException {
        if (this.values == null) {
            return;
        }
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            Element e = node.getOwnerDocument().createElement("elemValue");
            e.appendChild(node.getOwnerDocument().createCDATASection((String)i.next()));
            node.appendChild(e);
        }
    }

    public String getMinValue() {
        return "";
    }

    public String getMaxValue() {
        return "";
    }

    public List getValues() {
        return this.values;
    }

    protected void addElementSpecificProperties(Model model, Resource element, ProfileAttributes profAttr, URI uri) {
        Utility.addProperty(model, element, Utility.edmValue, this.values, profAttr, uri);
    }
}

