/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.AbstractCrawlLister;
import org.apache.oodt.product.handlers.ofsn.OFSNGetHandler;

public class URLGetHandler
extends AbstractCrawlLister
implements OFSNGetHandler {
    Logger LOG = Logger.getLogger(URLGetHandler.class.getName());
    private static final String PROD_SERVER_HOSTNAME = "prodServerHostname";
    private static final String PROD_SERVER_PORT = "prodServerPort";
    private static final String PROD_SERVER_CONTEXT = "prodServerContextRoot";
    private static final String PRODUCT_ROOT = "productRoot";
    private static final String RETURN_TYPE = "returnType";
    protected static final String DEFAULT_RETURN_VALUE = "";
    protected static final String DEFAULT_PROD_SERVER_HOSTNAME = "localhost";
    protected static final String DEFAULT_PROD_SERVER_PORT = "8080";
    protected static final String DEFAULT_PROD_SERVER_CONTEXT = "web-grid";
    protected static final String DEFAULT_PRODUCT_ROOT = "/some/path";
    protected static final String DEFAULT_RETURN_TYPE = "RAW";
    private String prodServerHostname = new String();
    private String prodServerPort = new String();
    private String prodServerContext = new String();
    private String productRoot = new String();
    private String returnType = new String();

    @Override
    public void configure(Properties prop) {
        if (prop != null) {
            if (prop.getProperty(PROD_SERVER_HOSTNAME) != null) {
                this.prodServerHostname = prop.getProperty(PROD_SERVER_HOSTNAME);
            } else {
                this.LOG.warning("Configuration property [prodServerHostname] not specified, using default");
                this.prodServerHostname = DEFAULT_PROD_SERVER_HOSTNAME;
            }
            this.LOG.info("Property [prodServerHostname] set with value [" + this.prodServerHostname + "]");
            if (prop.getProperty(PROD_SERVER_PORT) != null) {
                this.prodServerPort = prop.getProperty(PROD_SERVER_PORT);
            } else {
                this.LOG.warning("Configuration property [prodServerPort] not specified, using default");
                this.prodServerPort = DEFAULT_PROD_SERVER_PORT;
            }
            this.LOG.info("Property [prodServerPort] set with value [" + this.prodServerPort + "]");
            if (prop.getProperty(PROD_SERVER_CONTEXT) != null) {
                this.prodServerContext = prop.getProperty(PROD_SERVER_CONTEXT);
            } else {
                this.LOG.warning("Configuration property [prodServerContextRoot] not specified, using default");
                this.prodServerContext = DEFAULT_PROD_SERVER_CONTEXT;
            }
            this.LOG.info("Property [prodServerContextRoot] set with value [" + this.prodServerContext + "]");
            if (prop.getProperty(PRODUCT_ROOT) != null) {
                this.productRoot = prop.getProperty(PRODUCT_ROOT);
            } else {
                this.LOG.warning("Configuration property [productRoot] not specified, using default");
                this.productRoot = DEFAULT_PRODUCT_ROOT;
            }
            this.LOG.info("Property [productRoot] set with value [" + this.productRoot + "]");
            if (prop.getProperty(RETURN_TYPE) != null) {
                this.returnType = prop.getProperty(RETURN_TYPE);
            } else {
                this.LOG.warning("Configuration property [returnType] not specified, using default");
                this.returnType = DEFAULT_RETURN_TYPE;
            }
            this.LOG.info("Property [returnType] set with value [" + this.returnType + "]");
        } else {
            this.LOG.warning("Configuration properties could not be loaded");
        }
    }

    @Override
    public byte[] retrieveChunk(String filepath, long offset, int length) throws ProductException {
        this.LOG.info("Retrieving chunk of URL listing for path: [" + filepath + "] at offset " + offset + " for " + length + " bytes");
        String urlListing = DEFAULT_RETURN_VALUE;
        try {
            urlListing = this.getURLListing(filepath);
        }
        catch (ProductException e) {
            this.LOG.warning("Unable to obtain byte chunk (" + offset + " - " + (offset + (long)length) + ") " + "for filepath listing [" + filepath + "]");
            this.LOG.warning(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.LOG.warning("Unable to obtain byte chunk (" + offset + " - " + (offset + (long)length) + ") " + "for filepath listing [" + filepath + "]");
            this.LOG.warning(e.getMessage());
        }
        byte[] retBytes = new byte[length];
        byte[] metBytes = urlListing.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(metBytes);
        is.skip(offset);
        is.read(retBytes, 0, length);
        return retBytes;
    }

    private String getURLListing(String filePath) throws ProductException, IllegalArgumentException {
        File[] fileListing = this.getListing(filePath);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fileListing.length; ++i) {
            File file = fileListing[i];
            stringBuilder.append(this.buildOFSNURL(file).toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private URL buildOFSNURL(File file) {
        URL url = null;
        String fileRelativePath = file.getAbsolutePath().substring(this.productRoot.length());
        String ofsnPath = this.prodServerPort != null ? (!this.prodServerPort.isEmpty() ? "http://" + this.prodServerHostname + ":" + this.prodServerPort + "/" + this.prodServerContext + "/prod?q=OFSN=" + fileRelativePath + "+AND+RT%3D" + this.returnType : "http://" + this.prodServerHostname + "/" + this.prodServerContext + "/prod?q=OFSN=" + fileRelativePath + "+AND+RT%3D" + this.returnType) : "http://" + this.prodServerHostname + "/" + this.prodServerContext + "/prod?q=OFSN=" + fileRelativePath + "+AND+RT%3D" + this.returnType;
        try {
            url = new URL(ofsnPath);
        }
        catch (MalformedURLException e) {
            this.LOG.warning(e.getMessage());
        }
        return url;
    }

    @Override
    public long sizeOf(String filepath) {
        String urlListing = DEFAULT_RETURN_VALUE;
        try {
            urlListing = this.getURLListing(filepath);
        }
        catch (ProductException e) {
            this.LOG.warning("Unable to obtain size information for filepath listing [" + filepath + "]");
            this.LOG.warning(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.LOG.warning("Unable to obtain size information for filepath listing [" + filepath + "]");
            this.LOG.warning(e.getMessage());
        }
        return urlListing.getBytes().length;
    }

    @Override
    public File[] getListing(String filePath) throws ProductException, IllegalArgumentException {
        return this.crawlFiles(new File(filePath), true, false);
    }
}

