/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.File;
import java.util.Properties;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.OFSNListHandler;
import org.apache.oodt.product.handlers.ofsn.util.OFSNUtils;

public class SingleZipFileListHandler
implements OFSNListHandler {
    private String cacheRoot;

    @Override
    public void configure(Properties conf) {
        this.cacheRoot = conf.getProperty("cacheDirRoot");
        if (this.cacheRoot == null) {
            this.cacheRoot = "/tmp";
        }
        if (!this.cacheRoot.endsWith("/")) {
            this.cacheRoot = this.cacheRoot + "/";
        }
    }

    @Override
    public File[] getListing(String ofsn) throws ProductException {
        if (!new File(ofsn).exists()) {
            throw new ProductException("file: [" + ofsn + "] does not exist!");
        }
        String zipFilePath = this.cacheRoot + new File(ofsn).getName() + ".zip";
        File zipFile = OFSNUtils.buildZipFile(zipFilePath, new File[]{new File(ofsn)});
        return new File[]{zipFile};
    }
}

