/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.oodt.commons.xml.XMLUtils;
import org.apache.oodt.product.handlers.ofsn.OFSNFileHandlerConfiguration;
import org.apache.oodt.product.handlers.ofsn.OFSNHandlerConfig;
import org.apache.oodt.product.handlers.ofsn.metadata.OFSNXMLConfigMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class OFSNFileHandlerConfigurationReader
implements OFSNXMLConfigMetKeys {
    public static OFSNFileHandlerConfiguration getConfig(String filePath) throws FileNotFoundException {
        OFSNFileHandlerConfiguration config = new OFSNFileHandlerConfiguration();
        Document configDoc = XMLUtils.getDocumentRoot((InputStream)new FileInputStream(new File(filePath)));
        Element configElem = configDoc.getDocumentElement();
        config.setId(configElem.getAttribute("id"));
        config.setName(configElem.getAttribute("name"));
        config.setProductRoot(configElem.getAttribute("productRoot"));
        OFSNFileHandlerConfigurationReader.addHandlers(configElem, config);
        return config;
    }

    private static void addHandlers(Element configRootElem, OFSNFileHandlerConfiguration config) {
        NodeList handlerNodes = configRootElem.getElementsByTagName("handler");
        for (int i = 0; i < handlerNodes.getLength(); ++i) {
            OFSNHandlerConfig cfg = OFSNFileHandlerConfigurationReader.getHandlerConfig((Element)handlerNodes.item(i));
            config.handlerTable.put(cfg.getName(), cfg);
        }
    }

    private static OFSNHandlerConfig getHandlerConfig(Element handlerNodeElem) {
        OFSNHandlerConfig cfg = new OFSNHandlerConfig();
        cfg.setClassName(handlerNodeElem.getAttribute("class"));
        cfg.setName(handlerNodeElem.getAttribute("name"));
        cfg.setType(handlerNodeElem.getAttribute("type"));
        cfg.setHandlerConf(OFSNFileHandlerConfigurationReader.readConfig(handlerNodeElem));
        return cfg;
    }

    private static Properties readConfig(Element handlerNodeElem) {
        Properties config = new Properties();
        NodeList propertyNodes = handlerNodeElem.getElementsByTagName("property");
        if (propertyNodes != null && propertyNodes.getLength() > 0) {
            for (int j = 0; j < propertyNodes.getLength(); ++j) {
                Element propertyElem = (Element)propertyNodes.item(j);
                String propertyName = propertyElem.getAttribute("name");
                String propertyValue = propertyElem.getAttribute("value");
                config.setProperty(propertyName, propertyValue);
            }
        }
        return config;
    }
}

