/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.product.handlers.ofsn.OFSNGetHandler;
import org.apache.oodt.product.handlers.ofsn.OFSNListHandler;

public final class OFSNObjectFactory {
    private static final Logger LOG = Logger.getLogger(OFSNObjectFactory.class.getName());

    public static OFSNListHandler getListHandler(String className) {
        try {
            Class<?> listHandler = Class.forName(className);
            return (OFSNListHandler)listHandler.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "ClassNotFoundException when loading list handler class " + className + " Message: " + e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "InstantiationException when loading list handler class " + className + " Message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "IllegalAccessException when loading list handler class " + className + " Message: " + e.getMessage());
        }
        return null;
    }

    public static OFSNGetHandler getGetHandler(String className) {
        try {
            Class<?> getHandler = Class.forName(className);
            return (OFSNGetHandler)getHandler.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "ClassNotFoundException when loading get handler class " + className + " Message: " + e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "InstantiationException when loading get handler class " + className + " Message: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "IllegalAccessException when loading get handler class " + className + " Message: " + e.getMessage());
        }
        return null;
    }
}

