/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oodt.product.handlers.ofsn.OFSNHandlerConfig;

public class OFSNFileHandlerConfiguration {
    protected Map<String, OFSNHandlerConfig> handlerTable = new HashMap<String, OFSNHandlerConfig>();
    private String productRoot;
    private String id;
    private String name;

    public OFSNFileHandlerConfiguration(String productRoot, String id, String name) {
        this.productRoot = productRoot;
        this.id = id;
        this.name = name;
        this.cleanse(this.productRoot);
    }

    public OFSNFileHandlerConfiguration() {
        this(null, null, null);
    }

    public String getHandlerType(String handlerName) {
        if (this.handlerTable.containsKey(handlerName)) {
            return this.handlerTable.get(handlerName).getType();
        }
        return null;
    }

    public String getHandlerClass(String handlerName) {
        if (this.handlerTable.containsKey(handlerName)) {
            return this.handlerTable.get(handlerName).getClassName();
        }
        return null;
    }

    public List<OFSNHandlerConfig> getHandlerConfigs() {
        return Arrays.asList(this.handlerTable.values().toArray(new OFSNHandlerConfig[this.handlerTable.size()]));
    }

    public OFSNHandlerConfig getHandlerConfig(String handlerName) {
        return this.handlerTable.get(handlerName);
    }

    public String getProductRoot() {
        return this.productRoot;
    }

    public void setProductRoot(String productRoot) {
        this.productRoot = productRoot;
        this.cleanse(this.productRoot);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void cleanse(String path) {
        if (path != null && !path.endsWith("/")) {
            path = path + "/";
        }
    }
}

