/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.product.handlers.ofsn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.commons.xml.XMLUtils;
import org.apache.oodt.product.LargeProductQueryHandler;
import org.apache.oodt.product.ProductException;
import org.apache.oodt.product.handlers.ofsn.OFSNFileHandlerConfiguration;
import org.apache.oodt.product.handlers.ofsn.OFSNFileHandlerConfigurationReader;
import org.apache.oodt.product.handlers.ofsn.OFSNGetHandler;
import org.apache.oodt.product.handlers.ofsn.OFSNHandlerConfig;
import org.apache.oodt.product.handlers.ofsn.OFSNListHandler;
import org.apache.oodt.product.handlers.ofsn.metadata.OFSNMetKeys;
import org.apache.oodt.product.handlers.ofsn.metadata.OFSNXMLMetKeys;
import org.apache.oodt.product.handlers.ofsn.metadata.XMLQueryMetKeys;
import org.apache.oodt.product.handlers.ofsn.util.OFSNObjectFactory;
import org.apache.oodt.product.handlers.ofsn.util.OFSNUtils;
import org.apache.oodt.xmlquery.LargeResult;
import org.apache.oodt.xmlquery.Result;
import org.apache.oodt.xmlquery.XMLQuery;
import org.apache.tika.mime.MimeTypesFactory;
import org.w3c.dom.Document;

public class OFSNFileHandler
implements LargeProductQueryHandler,
XMLQueryMetKeys,
OFSNXMLMetKeys,
OFSNMetKeys {
    private static final Logger LOG = Logger.getLogger(OFSNFileHandler.class.getName());
    private static final String CMD_SEPARATOR = ";";
    private boolean computeDirSize = true;
    private boolean computeFileSize = true;
    private OFSNFileHandlerConfiguration conf;
    private static Map<String, Object> HANDLER_CACHE;

    public OFSNFileHandler() throws InstantiationException {
        String xmlConfigFilePath = System.getProperty("org.apache.oodt.product.handlers.ofsn.xmlConfigFilePath");
        this.computeDirSize = Boolean.getBoolean("org.apache.oodt.product.handlers.ofsn.computeDirSize");
        this.computeFileSize = Boolean.getBoolean("org.apache.oodt.product.handlers.ofsn.computeFileSize");
        if (xmlConfigFilePath == null) {
            throw new InstantiationException("Must define xml configuration file path via property : [org.apache.oodt.product.handlers.ofsn.xmlConfigFilePath]");
        }
        try {
            this.conf = OFSNFileHandlerConfigurationReader.getConfig(xmlConfigFilePath);
        }
        catch (FileNotFoundException e) {
            throw new InstantiationException("xml configuration file: [" + xmlConfigFilePath + "] not found!");
        }
        if (this.conf.getProductRoot() == null) {
            throw new InstantiationException("Must define: [productRoot] attribute in XML configuration!");
        }
        HANDLER_CACHE = new HashMap<String, Object>();
    }

    public XMLQuery query(XMLQuery xmlQuery) throws ProductException {
        String ofsn = OFSNUtils.extractFieldFromQuery(xmlQuery, "OFSN");
        String cmd = OFSNUtils.extractFieldFromQuery(xmlQuery, "RT");
        this.validate(ofsn, cmd);
        String cmdId = ofsn + CMD_SEPARATOR + cmd;
        OFSNHandlerConfig cfg = this.conf.getHandlerConfig(cmd);
        this.validateHandlerConfig(cfg, cmd);
        String realPath = this.conf.getProductRoot() + ofsn;
        if (this.isListingCmd(cmd)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            OFSNListHandler handler = this.getListHandler(cmd, cfg.getClassName());
            File[] fileList = handler.getListing(realPath);
            this.generateOFSNXml(fileList, cfg, outStream);
            xmlQuery.getResults().add(new Result(cmdId, "text/xml", null, cmdId, Collections.EMPTY_LIST, (Object)outStream.toString()));
        } else if (this.isGetCmd(cmd)) {
            OFSNGetHandler handler = this.getGetHandler(cmd, cfg.getClassName());
            String rtAndPath = cmd + CMD_SEPARATOR + realPath;
            xmlQuery.getResults().add(new LargeResult(rtAndPath, MimeTypesFactory.create().getMimeType(new File(realPath)).getName(), null, new File(realPath).getName(), Collections.EMPTY_LIST, handler.sizeOf(realPath)));
        } else {
            throw new ProductException("return type: [" + cmd + "] is unsupported!");
        }
        return xmlQuery;
    }

    public void close(String id) throws ProductException {
    }

    public byte[] retrieveChunk(String id, long offset, int length) throws ProductException {
        String[] rtTypeAndPathArr = id.split(CMD_SEPARATOR);
        String rtType = rtTypeAndPathArr[0];
        String filepath = rtTypeAndPathArr[1];
        OFSNGetHandler handler = this.getGetHandler(rtType, this.conf.getHandlerClass(rtType));
        return handler.retrieveChunk(filepath, offset, length);
    }

    private void generateOFSNXml(File[] mlsFileList, OFSNHandlerConfig cfg, OutputStream outStream) {
        XMLUtils.writeXmlToStream((Document)OFSNUtils.getOFSNDoc(Arrays.asList(mlsFileList), cfg, this.conf.getProductRoot(), this.computeDirSize, this.computeFileSize), (OutputStream)outStream);
    }

    private void validate(String ofsn, String cmd) throws ProductException {
        if (ofsn == null || cmd == null || ofsn != null && ofsn.equals("") || cmd != null && cmd.equals("")) {
            throw new ProductException("must specify OFSN and RT parameters!");
        }
    }

    private void validateHandlerConfig(OFSNHandlerConfig cfg, String cmd) throws ProductException {
        if (cfg == null) {
            throw new ProductException("Unrecognized command: [" + cmd + "]!");
        }
    }

    private OFSNListHandler getListHandler(String rtType, String className) {
        if (HANDLER_CACHE.containsKey(rtType)) {
            return (OFSNListHandler)HANDLER_CACHE.get(rtType);
        }
        OFSNListHandler handler = OFSNObjectFactory.getListHandler(className);
        LOG.log(Level.INFO, "Getting handler config for RT: [" + rtType + "]");
        handler.configure(this.conf.getHandlerConfig(rtType).getHandlerConf());
        HANDLER_CACHE.put(rtType, handler);
        return handler;
    }

    private OFSNGetHandler getGetHandler(String rtType, String className) {
        if (HANDLER_CACHE.containsKey(rtType)) {
            return (OFSNGetHandler)HANDLER_CACHE.get(rtType);
        }
        OFSNGetHandler handler = OFSNObjectFactory.getGetHandler(className);
        handler.configure(this.conf.getHandlerConfig(rtType).getHandlerConf());
        HANDLER_CACHE.put(rtType, handler);
        return handler;
    }

    private boolean isListingCmd(String cmd) throws ProductException {
        OFSNHandlerConfig cfg = this.conf.getHandlerConfig(cmd);
        if (cfg == null) {
            throw new ProductException("Unrecognized command: [" + cmd + "]!");
        }
        return cfg.getType().equals("listing");
    }

    private boolean isGetCmd(String cmd) throws ProductException {
        OFSNHandlerConfig cfg = this.conf.getHandlerConfig(cmd);
        return cfg.getType().equals("get");
    }
}

